/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;

public class SafeChunkyOutputStream
extends FilterOutputStream {
    protected String filePath;
    protected boolean isOpen;

    public SafeChunkyOutputStream(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public SafeChunkyOutputStream(String string) throws IOException {
        super(new BufferedOutputStream(new FileOutputStream(string, true)));
        this.filePath = string;
        this.isOpen = true;
        this.beginChunk();
    }

    protected void beginChunk() throws IOException {
        this.write(ILocalStoreConstants.BEGIN_CHUNK);
    }

    protected void endChunk() throws IOException {
        this.write(ILocalStoreConstants.END_CHUNK);
    }

    protected void open() throws IOException {
        this.out = new BufferedOutputStream(new FileOutputStream(this.filePath, true));
        this.isOpen = true;
        this.beginChunk();
    }

    public void succeed() throws IOException {
        try {
            this.endChunk();
        }
        finally {
            this.isOpen = false;
            this.close();
        }
    }

    public void write(int n) throws IOException {
        if (!this.isOpen) {
            this.open();
        }
        super.write(n);
    }
}

