/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SafeFileInputStream
extends FilterInputStream {
    protected static final String EXTENSION = ".bak";
    private static final int DEFAUT_BUFFER_SIZE = 2048;

    public SafeFileInputStream(File file) throws IOException {
        this(file.getAbsolutePath(), null);
    }

    public SafeFileInputStream(String string, String string2) throws IOException {
        super(SafeFileInputStream.getInputStream(string, string2, 2048));
    }

    public SafeFileInputStream(String string, String string2, int n) throws IOException {
        super(SafeFileInputStream.getInputStream(string, string2, n));
    }

    private static InputStream getInputStream(String string, String string2, int n) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            if (string2 == null) {
                string2 = String.valueOf(file.getAbsolutePath()) + EXTENSION;
            }
            file = new File(string2);
        }
        return new BufferedInputStream(new FileInputStream(file), n);
    }
}

