/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.internal.utils.FileUtil;

public class SafeFileOutputStream
extends OutputStream {
    protected File temp;
    protected File target;
    protected OutputStream output;
    protected boolean failed = false;
    protected static final String EXTENSION = ".bak";

    public SafeFileOutputStream(File file) throws IOException {
        this(file.getAbsolutePath(), null);
    }

    public SafeFileOutputStream(String string, String string2) throws IOException {
        this.target = new File(string);
        this.createTempFile(string2);
        if (!this.target.exists()) {
            if (!this.temp.exists()) {
                this.output = new BufferedOutputStream(new FileOutputStream(this.target));
                return;
            }
            this.copy(this.temp, this.target);
        }
        this.output = new BufferedOutputStream(new FileOutputStream(this.temp));
    }

    public void close() throws IOException {
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            this.failed = true;
            throw iOException;
        }
        if (this.failed) {
            this.temp.delete();
        } else {
            this.commit();
        }
    }

    protected void commit() throws IOException {
        if (!this.temp.exists()) {
            return;
        }
        this.target.delete();
        this.copy(this.temp, this.target);
        this.temp.delete();
    }

    protected void copy(File file, File file2) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.renameTo(file2)) {
            return;
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            this.transferStreams(bufferedInputStream, bufferedOutputStream);
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(bufferedInputStream);
            FileUtil.safeClose(bufferedOutputStream);
            throw throwable;
        }
        FileUtil.safeClose(bufferedInputStream);
        FileUtil.safeClose(bufferedOutputStream);
    }

    protected void createTempFile(String string) {
        if (string == null) {
            string = String.valueOf(this.target.getAbsolutePath()) + EXTENSION;
        }
        this.temp = new File(string);
    }

    public void flush() throws IOException {
        try {
            this.output.flush();
        }
        catch (IOException iOException) {
            this.failed = true;
            throw iOException;
        }
    }

    public String getTempFilePath() {
        return this.temp.getAbsolutePath();
    }

    protected void transferStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void write(int n) throws IOException {
        try {
            this.output.write(n);
        }
        catch (IOException iOException) {
            this.failed = true;
            throw iOException;
        }
    }
}

