/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.PrefixPool;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.refresh.RefreshJob;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Queue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;

public class UnifiedTree {
    protected static final UnifiedTreeNode childrenMarker = new UnifiedTreeNode(null, null, null, null, false);
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    protected static final UnifiedTreeNode levelMarker = new UnifiedTreeNode(null, null, null, null, false);
    private static final IFileInfo[] NO_CHILDREN = new IFileInfo[0];
    private static final IResource[] NO_RESOURCES = new IResource[0];
    protected boolean childLevelValid = false;
    protected IFileTree fileTree = null;
    protected ArrayList freeNodes = new ArrayList();
    protected int level;
    protected Queue queue;
    protected PrefixPool pathPrefixHistory;
    protected PrefixPool rootPathHistory;
    protected IResource root;

    public UnifiedTree(IResource iResource) {
        this.setRoot(iResource);
    }

    public UnifiedTree(IResource iResource, IFileTree iFileTree) {
        this(iResource);
        this.fileTree = iFileTree;
    }

    public void accept(IUnifiedTreeVisitor iUnifiedTreeVisitor) throws CoreException {
        this.accept(iUnifiedTreeVisitor, 2);
    }

    public void accept(IUnifiedTreeVisitor iUnifiedTreeVisitor, int n) throws CoreException {
        Assert.isNotNull((Object)this.root);
        this.initializeQueue();
        this.setLevel(0, n);
        while (!this.queue.isEmpty()) {
            UnifiedTreeNode unifiedTreeNode = (UnifiedTreeNode)this.queue.remove();
            if (this.isChildrenMarker(unifiedTreeNode)) continue;
            if (this.isLevelMarker(unifiedTreeNode)) {
                if (this.setLevel(this.getLevel() + 1, n)) continue;
                break;
            }
            if (iUnifiedTreeVisitor.visit(unifiedTreeNode)) {
                this.addNodeChildrenToQueue(unifiedTreeNode);
            } else {
                this.removeNodeChildrenFromQueue(unifiedTreeNode);
            }
            this.freeNodes.add(unifiedTreeNode);
        }
    }

    protected void addChildren(UnifiedTreeNode unifiedTreeNode) {
        Resource resource = (Resource)unifiedTreeNode.getResource();
        int n = resource.getType();
        if (n == 1 && !unifiedTreeNode.isFolder()) {
            return;
        }
        if (!resource.getProject().isAccessible()) {
            return;
        }
        IFileInfo[] iFileInfoArray = unifiedTreeNode.existsInFileSystem() ? this.getLocalList(unifiedTreeNode) : NO_CHILDREN;
        iFileInfoArray = resource.filterChildren(iFileInfoArray);
        int n2 = 0;
        ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
        int n3 = resource.getFlags(resourceInfo);
        boolean bl = ResourceInfo.isSet(n3, 0x100000);
        if (!bl && (n == 2 || n == 4) && resource.exists(n3, true)) {
            IResource[] iResourceArray;
            IResource iResource = null;
            UnifiedTreeNode unifiedTreeNode2 = null;
            try {
                iResourceArray = ((IContainer)((Object)resource)).members(10);
            }
            catch (CoreException coreException) {
                iResourceArray = NO_RESOURCES;
            }
            int n4 = 0;
            while (n4 < iResourceArray.length) {
                int n5;
                iResource = iResourceArray[n4];
                String string = iResource.getName();
                IFileInfo iFileInfo = n2 < iFileInfoArray.length ? iFileInfoArray[n2] : null;
                int n6 = n5 = iFileInfo != null ? string.compareTo(iFileInfo.getName()) : -1;
                if (iResource.isLinked()) {
                    unifiedTreeNode2 = this.createChildForLinkedResource(iResource);
                    ++n4;
                    if (n5 == 0) {
                        ++n2;
                    }
                } else if (n5 == 0) {
                    unifiedTreeNode2 = iFileInfo.getAttribute(32) && iFileInfo.isDirectory() && this.isRecursiveLink(unifiedTreeNode.getStore(), iFileInfo) ? this.createNode(iResource, null, null, true) : this.createNode(iResource, null, iFileInfo, true);
                    ++n2;
                    ++n4;
                } else if (n5 > 0) {
                    if (!(iFileInfo.getAttribute(32) && iFileInfo.isDirectory() && this.isRecursiveLink(unifiedTreeNode.getStore(), iFileInfo))) {
                        unifiedTreeNode2 = this.createChildNodeFromFileSystem(unifiedTreeNode, iFileInfo);
                    }
                    ++n2;
                } else {
                    unifiedTreeNode2 = this.createNode(iResource, null, null, true);
                    ++n4;
                }
                if (unifiedTreeNode2 == null) continue;
                this.addChildToTree(unifiedTreeNode, unifiedTreeNode2);
            }
        }
        this.addChildrenFromFileSystem(unifiedTreeNode, iFileInfoArray, n2);
        if (bl && (resourceInfo = resource.getResourceInfo(false, false)) != null) {
            resourceInfo.clear(0x100000);
        }
        if (unifiedTreeNode.getFirstChild() != null) {
            this.addChildrenMarker();
        }
    }

    protected void addChildrenFromFileSystem(UnifiedTreeNode unifiedTreeNode, IFileInfo[] iFileInfoArray, int n) {
        if (iFileInfoArray == null) {
            return;
        }
        int n2 = n;
        while (n2 < iFileInfoArray.length) {
            IFileInfo iFileInfo = iFileInfoArray[n2];
            if (!(iFileInfo.getAttribute(32) && iFileInfo.isDirectory() && this.isRecursiveLink(unifiedTreeNode.getStore(), iFileInfo))) {
                this.addChildToTree(unifiedTreeNode, this.createChildNodeFromFileSystem(unifiedTreeNode, iFileInfo));
            }
            ++n2;
        }
    }

    protected void addChildrenMarker() {
        this.addElementToQueue(childrenMarker);
    }

    protected void addChildToTree(UnifiedTreeNode unifiedTreeNode, UnifiedTreeNode unifiedTreeNode2) {
        if (unifiedTreeNode.getFirstChild() == null) {
            unifiedTreeNode.setFirstChild(unifiedTreeNode2);
        }
        this.addElementToQueue(unifiedTreeNode2);
    }

    protected void addElementToQueue(UnifiedTreeNode unifiedTreeNode) {
        this.queue.add(unifiedTreeNode);
    }

    protected void addNodeChildrenToQueue(UnifiedTreeNode unifiedTreeNode) {
        if (!this.childLevelValid || unifiedTreeNode.getFirstChild() != null) {
            return;
        }
        this.addChildren(unifiedTreeNode);
        if (this.queue.isEmpty()) {
            return;
        }
        UnifiedTreeNode unifiedTreeNode2 = (UnifiedTreeNode)this.queue.peek();
        if (this.isChildrenMarker(unifiedTreeNode2)) {
            this.queue.remove();
        }
        if (this.isLevelMarker(unifiedTreeNode2 = (UnifiedTreeNode)this.queue.peek())) {
            this.addElementToQueue(levelMarker);
        }
    }

    protected void addRootToQueue() {
        IFileInfo iFileInfo;
        if (!this.root.getProject().isAccessible()) {
            return;
        }
        IFileStore iFileStore = ((Resource)this.root).getStore();
        UnifiedTreeNode unifiedTreeNode = this.createNode(this.root, iFileStore, iFileInfo = this.fileTree != null ? this.fileTree.getFileInfo(iFileStore) : iFileStore.fetchInfo(), this.root.exists());
        if (unifiedTreeNode.existsInFileSystem() || unifiedTreeNode.existsInWorkspace()) {
            this.addElementToQueue(unifiedTreeNode);
        }
    }

    protected UnifiedTreeNode createChildForLinkedResource(IResource iResource) {
        IFileStore iFileStore = ((Resource)iResource).getStore();
        return this.createNode(iResource, iFileStore, iFileStore.fetchInfo(), true);
    }

    protected UnifiedTreeNode createChildNodeFromFileSystem(UnifiedTreeNode unifiedTreeNode, IFileInfo iFileInfo) {
        IPath iPath = unifiedTreeNode.getResource().getFullPath().append(iFileInfo.getName());
        int n = iFileInfo.isDirectory() ? 2 : 1;
        Resource resource = this.getWorkspace().newResource(iPath, n);
        return this.createNode(resource, null, iFileInfo, false);
    }

    protected UnifiedTreeNode createNode(IResource iResource, IFileStore iFileStore, IFileInfo iFileInfo, boolean bl) {
        UnifiedTreeNode unifiedTreeNode = null;
        int n = this.freeNodes.size();
        if (n > 0) {
            unifiedTreeNode = (UnifiedTreeNode)this.freeNodes.remove(n - 1);
            unifiedTreeNode.reuse(this, iResource, iFileStore, iFileInfo, bl);
            return unifiedTreeNode;
        }
        return new UnifiedTreeNode(this, iResource, iFileStore, iFileInfo, bl);
    }

    protected Iterator getChildren(UnifiedTreeNode unifiedTreeNode) {
        UnifiedTreeNode unifiedTreeNode2;
        if (unifiedTreeNode.getFirstChild() == null) {
            this.addNodeChildrenToQueue(unifiedTreeNode);
        }
        if (unifiedTreeNode.getFirstChild() == null) {
            return EMPTY_ITERATOR;
        }
        int n = this.queue.indexOf(unifiedTreeNode.getFirstChild());
        if (n == -1) {
            return EMPTY_ITERATOR;
        }
        ArrayList<UnifiedTreeNode> arrayList = new ArrayList<UnifiedTreeNode>(10);
        while (!this.isChildrenMarker(unifiedTreeNode2 = (UnifiedTreeNode)this.queue.elementAt(n))) {
            arrayList.add(unifiedTreeNode2);
            n = this.queue.increment(n);
        }
        return arrayList.iterator();
    }

    protected int getLevel() {
        return this.level;
    }

    protected IFileInfo[] getLocalList(UnifiedTreeNode unifiedTreeNode) {
        try {
            IFileInfo[] iFileInfoArray;
            IFileStore iFileStore = unifiedTreeNode.getStore();
            IFileInfo[] iFileInfoArray2 = iFileInfoArray = this.fileTree != null ? this.fileTree.getChildInfos(iFileStore) : iFileStore.childInfos(0, null);
            if (iFileInfoArray == null) {
                return NO_CHILDREN;
            }
            int n = iFileInfoArray.length;
            if (n > 1) {
                this.quickSort(iFileInfoArray, 0, n - 1);
            }
            return iFileInfoArray;
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected Workspace getWorkspace() {
        return (Workspace)this.root.getWorkspace();
    }

    protected void initializeQueue() {
        if (this.queue == null) {
            this.queue = new Queue(100, false);
        } else {
            this.queue.reset();
        }
        if (this.freeNodes == null) {
            this.freeNodes = new ArrayList(100);
        } else {
            this.freeNodes.clear();
        }
        this.addRootToQueue();
        this.addElementToQueue(levelMarker);
    }

    protected boolean isChildrenMarker(UnifiedTreeNode unifiedTreeNode) {
        return unifiedTreeNode == childrenMarker;
    }

    protected boolean isLevelMarker(UnifiedTreeNode unifiedTreeNode) {
        return unifiedTreeNode == levelMarker;
    }

    protected void initLinkHistoriesIfNeeded() {
        block10: {
            Object object;
            Job job;
            if (this.pathPrefixHistory == null) {
                job = Job.getJobManager().currentJob();
                if (job instanceof RefreshJob) {
                    object = (RefreshJob)job;
                    this.pathPrefixHistory = ((RefreshJob)((Object)object)).getPathPrefixHistory();
                    this.rootPathHistory = ((RefreshJob)((Object)object)).getRootPathHistory();
                } else {
                    this.pathPrefixHistory = new PrefixPool(20);
                    this.rootPathHistory = new PrefixPool(20);
                }
            }
            if (this.rootPathHistory.size() == 0) {
                job = ((Resource)this.root).getStore();
                try {
                    object = job.toLocalFile(0, null);
                    if (object == null) break block10;
                    IPath iPath = this.root.getProject().getLocation();
                    if (iPath != null) {
                        try {
                            File file = new File(iPath.toOSString());
                            this.rootPathHistory.insertShorter(String.valueOf(file.getCanonicalPath()) + '/');
                        }
                        catch (IOException iOException) {}
                    }
                    this.rootPathHistory.insertShorter(String.valueOf(((File)object).getCanonicalPath()) + '/');
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean isRecursiveLink(IFileStore iFileStore, IFileInfo iFileInfo) {
        block10: {
            String string;
            block11: {
                block9: {
                    File file;
                    block8: {
                        String string2 = iFileInfo.getStringAttribute(64);
                        if (string2 != null && PatternHolder.trivialSymlinkPattern.matcher(string2).matches()) {
                            return true;
                        }
                        file = iFileStore.toLocalFile(0, null);
                        if (file != null) break block8;
                        return false;
                    }
                    File file2 = new File(file, iFileInfo.getName());
                    String string3 = String.valueOf(file.getCanonicalPath()) + '/';
                    string = String.valueOf(file2.getCanonicalPath()) + '/';
                    this.initLinkHistoriesIfNeeded();
                    this.pathPrefixHistory.insertLonger(string3);
                    if (!this.pathPrefixHistory.containsAsPrefix(string)) break block9;
                    if (!this.rootPathHistory.insertShorter(string)) {
                        return true;
                    }
                    break block10;
                }
                if (!this.rootPathHistory.hasPrefixOf(string)) break block11;
                return false;
            }
            try {
                this.rootPathHistory.insertShorter(string);
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    protected boolean isValidLevel(int n, int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
            case 1: {
                return n <= 1;
            }
            case 0: {
                return n == 0;
            }
        }
        return n + 1000 <= n2;
    }

    protected void quickSort(IFileInfo[] iFileInfoArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        IFileInfo iFileInfo = iFileInfoArray[(n + n2) / 2];
        while (true) {
            if (iFileInfo.compareTo((Object)iFileInfoArray[n]) > 0) {
                ++n;
                continue;
            }
            while (iFileInfoArray[n2].compareTo((Object)iFileInfo) > 0) {
                --n2;
            }
            if (n <= n2) {
                IFileInfo iFileInfo2 = iFileInfoArray[n];
                iFileInfoArray[n] = iFileInfoArray[n2];
                iFileInfoArray[n2] = iFileInfo2;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            this.quickSort(iFileInfoArray, n3, n2);
        }
        if (n < n4) {
            this.quickSort(iFileInfoArray, n, n4);
        }
    }

    protected void removeNodeChildrenFromQueue(UnifiedTreeNode unifiedTreeNode) {
        UnifiedTreeNode unifiedTreeNode2 = unifiedTreeNode.getFirstChild();
        if (unifiedTreeNode2 == null) {
            return;
        }
        while (!unifiedTreeNode2.equals(this.queue.removeTail())) {
        }
        unifiedTreeNode.setFirstChild(null);
    }

    protected boolean setLevel(int n, int n2) {
        this.level = n;
        this.childLevelValid = this.isValidLevel(this.level + 1, n2);
        return this.isValidLevel(this.level, n2);
    }

    private void setRoot(IResource iResource) {
        this.root = iResource;
    }

    private static class PatternHolder {
        public static Pattern trivialSymlinkPattern = Pattern.compile("\\.[./]*");

        private PatternHolder() {
        }
    }
}

