/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.util.Iterator;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.localstore.UnifiedTree;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IResource;

public class UnifiedTreeNode
implements ILocalStoreConstants {
    protected UnifiedTreeNode child;
    protected boolean existsWorkspace;
    protected IFileInfo fileInfo;
    protected IResource resource;
    protected IFileStore store;
    protected UnifiedTree tree;

    public UnifiedTreeNode(UnifiedTree unifiedTree, IResource iResource, IFileStore iFileStore, IFileInfo iFileInfo, boolean bl) {
        this.tree = unifiedTree;
        this.resource = iResource;
        this.store = iFileStore;
        this.fileInfo = iFileInfo;
        this.existsWorkspace = bl;
    }

    public boolean existsInFileSystem() {
        return this.fileInfo != null && this.fileInfo.exists();
    }

    public boolean existsInWorkspace() {
        return this.existsWorkspace;
    }

    public Iterator getChildren() {
        return this.tree.getChildren(this);
    }

    protected UnifiedTreeNode getFirstChild() {
        return this.child;
    }

    public long getLastModified() {
        return this.fileInfo == null ? 0L : this.fileInfo.getLastModified();
    }

    public int getLevel() {
        return this.tree.getLevel();
    }

    public String getLocalName() {
        return this.fileInfo == null ? null : this.fileInfo.getName();
    }

    public IResource getResource() {
        return this.resource;
    }

    public IFileStore getStore() {
        if (this.store == null) {
            this.store = ((Resource)this.resource).getStore();
        }
        return this.store;
    }

    public boolean isFolder() {
        return this.fileInfo == null ? false : this.fileInfo.isDirectory();
    }

    public boolean isSymbolicLink() {
        return this.fileInfo == null ? false : this.fileInfo.getAttribute(32);
    }

    public void removeChildrenFromTree() {
        this.tree.removeNodeChildrenFromQueue(this);
    }

    public void reuse(UnifiedTree unifiedTree, IResource iResource, IFileStore iFileStore, IFileInfo iFileInfo, boolean bl) {
        this.tree = unifiedTree;
        this.child = null;
        this.resource = iResource;
        this.store = iFileStore;
        this.fileInfo = iFileInfo;
        this.existsWorkspace = bl;
    }

    public void setExistsWorkspace(boolean bl) {
        this.existsWorkspace = bl;
    }

    protected void setFirstChild(UnifiedTreeNode unifiedTreeNode) {
        this.child = unifiedTreeNode;
    }

    public void setResource(IResource iResource) {
        this.resource = iResource;
    }

    public String toString() {
        String string = this.resource == null ? "null" : this.resource.getFullPath().toString();
        return "Node: " + string;
    }
}

