/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class PropertyBucket
extends Bucket {
    public static final byte INDEX = 1;
    public static final byte QNAME = 2;
    private static final byte VERSION = 1;
    private final List qualifierIndex = new ArrayList();

    protected Bucket.Entry createEntry(IPath iPath, Object object) {
        return new PropertyEntry(iPath, (String[][])object);
    }

    private PropertyEntry getEntry(IPath iPath) {
        String string = iPath.toString();
        String[][] stringArray = (String[][])this.getEntryValue(string);
        if (stringArray == null) {
            return null;
        }
        return new PropertyEntry(iPath, stringArray);
    }

    protected String getIndexFileName() {
        return "properties.index";
    }

    public String getProperty(IPath iPath, QualifiedName qualifiedName) {
        PropertyEntry propertyEntry = this.getEntry(iPath);
        if (propertyEntry == null) {
            return null;
        }
        return propertyEntry.getProperty(qualifiedName);
    }

    protected byte getVersion() {
        return 1;
    }

    protected String getVersionFileName() {
        return "properties.version";
    }

    public void load(String string, File file, boolean bl) throws CoreException {
        this.qualifierIndex.clear();
        super.load(string, file, bl);
    }

    protected Object readEntryValue(DataInputStream dataInputStream) throws IOException, CoreException {
        int n = dataInputStream.readUnsignedShort();
        String[][] stringArray = new String[n][3];
        int n2 = 0;
        while (n2 < stringArray.length) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 2: {
                    stringArray[n2][0] = dataInputStream.readUTF();
                    this.qualifierIndex.add(stringArray[n2][0]);
                    break;
                }
                case 1: {
                    stringArray[n2][0] = (String)this.qualifierIndex.get(dataInputStream.readInt());
                    break;
                }
                default: {
                    Path path = this.projectName == null ? Path.ROOT : Path.ROOT.append(this.projectName);
                    String string = NLS.bind((String)Messages.properties_readProperties, (Object)path.toString());
                    throw new ResourceException(567, null, string, null);
                }
            }
            stringArray[n2][1] = dataInputStream.readUTF();
            stringArray[n2][2] = dataInputStream.readUTF();
            ++n2;
        }
        return stringArray;
    }

    public void save() throws CoreException {
        this.qualifierIndex.clear();
        super.save();
    }

    public void setProperties(PropertyEntry propertyEntry) {
        IPath iPath = propertyEntry.getPath();
        String[][] stringArray = (String[][])propertyEntry.getValue();
        String string = iPath.toString();
        String[][] stringArray2 = (String[][])this.getEntryValue(string);
        if (stringArray2 == null) {
            this.setEntryValue(string, stringArray);
            return;
        }
        this.setEntryValue(string, PropertyEntry.merge(stringArray2, stringArray));
    }

    public void setProperty(IPath iPath, QualifiedName qualifiedName, String string) {
        String string2 = iPath.toString();
        String[][] stringArray = (String[][])this.getEntryValue(string2);
        if (stringArray == null) {
            if (string != null) {
                this.setEntryValue(string2, new String[][]{{qualifiedName.getQualifier(), qualifiedName.getLocalName(), string}});
            }
            return;
        }
        String[][] stringArray2 = string != null ? PropertyEntry.insert(stringArray, qualifiedName, string) : PropertyEntry.delete(stringArray, qualifiedName);
        this.setEntryValue(string2, stringArray2);
    }

    protected void writeEntryValue(DataOutputStream dataOutputStream, Object object) throws IOException {
        String[][] stringArray = (String[][])object;
        dataOutputStream.writeShort(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.qualifierIndex.indexOf(stringArray[n][0]);
            if (n2 == -1) {
                dataOutputStream.writeByte(2);
                dataOutputStream.writeUTF(stringArray[n][0]);
                this.qualifierIndex.add(stringArray[n][0]);
            } else {
                dataOutputStream.writeByte(1);
                dataOutputStream.writeInt(n2);
            }
            dataOutputStream.writeUTF(stringArray[n][1]);
            dataOutputStream.writeUTF(stringArray[n][2]);
            ++n;
        }
    }

    public static class PropertyEntry
    extends Bucket.Entry {
        private static final Comparator COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                int n = ((String[])object)[0].compareTo(((String[])object2)[0]);
                return n != 0 ? n : ((String[])object)[1].compareTo(((String[])object2)[1]);
            }
        };
        private static final String[][] EMPTY_DATA = new String[0][];
        private String[][] value;

        static String[][] delete(String[][] stringArray, QualifiedName qualifiedName) {
            if (stringArray.length == 1) {
                return stringArray[0][0].equals(qualifiedName.getQualifier()) && stringArray[0][1].equals(qualifiedName.getLocalName()) ? null : stringArray;
            }
            int n = PropertyEntry.search(stringArray, qualifiedName);
            if (n < 0) {
                return stringArray;
            }
            String[][] stringArray2 = new String[stringArray.length - 1][];
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
            }
            if (n < stringArray.length - 1) {
                System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray2.length - n);
            }
            return stringArray2;
        }

        static String[][] insert(String[][] stringArray, QualifiedName qualifiedName, String string) {
            int n = PropertyEntry.search(stringArray, qualifiedName);
            if (n >= 0) {
                stringArray[n][2] = string;
                return stringArray;
            }
            int n2 = -n - 1;
            String[][] stringArray2 = new String[stringArray.length + 1][];
            if (n2 > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            }
            stringArray2[n2] = new String[]{qualifiedName.getQualifier(), qualifiedName.getLocalName(), string};
            if (n2 < stringArray.length) {
                System.arraycopy(stringArray, n2, stringArray2, n2 + 1, stringArray.length - n2);
            }
            return stringArray2;
        }

        static Object merge(String[][] stringArray, String[][] stringArray2) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String[][] stringArrayArray = new String[stringArray.length + stringArray2.length][];
            while (n2 < stringArray.length && n < stringArray2.length) {
                int n4 = COMPARATOR.compare(stringArray[n2], stringArray2[n]);
                if (n4 == 0) {
                    stringArrayArray[n3++] = stringArray2[n++];
                    ++n2;
                    continue;
                }
                stringArrayArray[n3++] = n4 < 0 ? stringArray[n2++] : stringArray2[n++];
            }
            String[][] stringArray3 = n2 == stringArray.length ? stringArray2 : stringArray;
            int n5 = n2 == stringArray.length ? n : n2;
            int n6 = stringArray3.length - n5;
            System.arraycopy(stringArray3, n5, stringArrayArray, n3, n6);
            if ((n3 += n6) == stringArray.length + stringArray2.length) {
                return stringArrayArray;
            }
            String[][] stringArrayArray2 = new String[n3][];
            System.arraycopy(stringArrayArray, 0, stringArrayArray2, 0, stringArrayArray2.length);
            return stringArrayArray2;
        }

        private static int search(String[][] stringArray, QualifiedName qualifiedName) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = qualifiedName.getQualifier();
            stringArray2[1] = qualifiedName.getLocalName();
            return Arrays.binarySearch(stringArray, stringArray2, COMPARATOR);
        }

        public PropertyEntry(IPath iPath, PropertyEntry propertyEntry) {
            super(iPath);
            int n = propertyEntry.value.length;
            this.value = new String[n][];
            int n2 = 0;
            while (n2 < n) {
                int n3 = propertyEntry.value[n2].length;
                this.value[n2] = new String[n3];
                System.arraycopy(propertyEntry.value[n2], 0, this.value[n2], 0, n3);
                ++n2;
            }
        }

        protected PropertyEntry(IPath iPath, String[][] stringArray) {
            super(iPath);
            this.value = stringArray;
        }

        private void compact() {
            if (!this.isDirty()) {
                return;
            }
            int n = 0;
            int n2 = 0;
            while (n2 < this.value.length) {
                if (this.value[n2] != null) {
                    this.value[n++] = this.value[n2];
                }
                ++n2;
            }
            if (n == this.value.length) {
                return;
            }
            if (n == 0) {
                this.value = EMPTY_DATA;
                this.delete();
                return;
            }
            String[][] stringArrayArray = new String[n][];
            System.arraycopy(this.value, 0, stringArrayArray, 0, n);
            this.value = stringArrayArray;
        }

        public int getOccurrences() {
            return this.value == null ? 0 : this.value.length;
        }

        public String getProperty(QualifiedName qualifiedName) {
            int n = PropertyEntry.search(this.value, qualifiedName);
            return n < 0 ? null : this.value[n][2];
        }

        public Object getPropertyName(int n) {
            return new QualifiedName(this.value[n][0], this.value[n][1]);
        }

        public Object getPropertyValue(int n) {
            return this.value[n][2];
        }

        public Object getValue() {
            return this.value;
        }

        public void visited() {
            this.compact();
        }
    }
}

