/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class PropertyManager2
implements IPropertyManager {
    BucketTree tree;

    public PropertyManager2(Workspace workspace) {
        this.tree = new BucketTree(workspace, new PropertyBucket());
    }

    public void closePropertyStore(IResource iResource) throws CoreException {
        this.tree.getCurrent().save();
        this.tree.getCurrent().flush();
    }

    public synchronized void copy(IResource iResource, IResource iResource2, int n) throws CoreException {
        this.copyProperties(iResource.getFullPath(), iResource2.getFullPath(), n);
    }

    private void copyProperties(IPath iPath, IPath iPath2, int n) throws CoreException {
        Assert.isLegal((iPath.segmentCount() > 0 ? 1 : 0) != 0);
        Assert.isLegal((iPath2.segmentCount() > 0 ? 1 : 0) != 0);
        Assert.isLegal((iPath.segmentCount() > 1 || iPath2.segmentCount() == 1 ? 1 : 0) != 0);
        PropertyCopyVisitor propertyCopyVisitor = new PropertyCopyVisitor(iPath, iPath2);
        this.tree.accept(propertyCopyVisitor, iPath, Integer.MAX_VALUE);
    }

    public synchronized void deleteProperties(IResource iResource, int n) throws CoreException {
        this.tree.accept(new Bucket.Visitor(){

            public int visit(Bucket.Entry entry) {
                entry.delete();
                return 0;
            }
        }, iResource.getFullPath(), n == 2 ? Integer.MAX_VALUE : n);
    }

    public void deleteResource(IResource iResource) throws CoreException {
        this.deleteProperties(iResource, 2);
    }

    public synchronized Map getProperties(IResource iResource) throws CoreException {
        final HashMap hashMap = new HashMap();
        this.tree.accept(new Bucket.Visitor(){

            public int visit(Bucket.Entry entry) {
                PropertyBucket.PropertyEntry propertyEntry = (PropertyBucket.PropertyEntry)entry;
                int n = propertyEntry.getOccurrences();
                int n2 = 0;
                while (n2 < n) {
                    hashMap.put(propertyEntry.getPropertyName(n2), propertyEntry.getPropertyValue(n2));
                    ++n2;
                }
                return 0;
            }
        }, iResource.getFullPath(), 0);
        return hashMap;
    }

    public synchronized String getProperty(IResource iResource, QualifiedName qualifiedName) throws CoreException {
        if (qualifiedName.getQualifier() == null) {
            String string = Messages.properties_qualifierIsNull;
            throw new ResourceException(567, iResource.getFullPath(), string, null);
        }
        IPath iPath = iResource.getFullPath();
        PropertyBucket propertyBucket = (PropertyBucket)this.tree.getCurrent();
        this.tree.loadBucketFor(iPath);
        return propertyBucket.getProperty(iPath, qualifiedName);
    }

    public BucketTree getTree() {
        return this.tree;
    }

    public File getVersionFile() {
        return this.tree.getVersionFile();
    }

    public synchronized void setProperty(IResource iResource, QualifiedName qualifiedName, String string) throws CoreException {
        Resource resource = (Resource)iResource;
        ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
        int n = resource.getFlags(resourceInfo);
        resource.checkAccessible(n);
        if (string != null && string.length() > 2048) {
            String string2 = NLS.bind((String)Messages.properties_valueTooLong, (Object)qualifiedName.getQualifier(), (Object)qualifiedName.getLocalName());
            throw new ResourceException(568, iResource.getFullPath(), string2, null);
        }
        if (qualifiedName.getQualifier() == null) {
            String string3 = Messages.properties_qualifierIsNull;
            throw new ResourceException(568, iResource.getFullPath(), string3, null);
        }
        IPath iPath = iResource.getFullPath();
        this.tree.loadBucketFor(iPath);
        PropertyBucket propertyBucket = (PropertyBucket)this.tree.getCurrent();
        propertyBucket.setProperty(iPath, qualifiedName, string);
        propertyBucket.save();
    }

    public void shutdown(IProgressMonitor iProgressMonitor) throws CoreException {
        this.tree.close();
    }

    public void startup(IProgressMonitor iProgressMonitor) {
    }

    class PropertyCopyVisitor
    extends Bucket.Visitor {
        private List changes = new ArrayList();
        private IPath destination;
        private IPath source;

        public PropertyCopyVisitor(IPath iPath, IPath iPath2) {
            this.source = iPath;
            this.destination = iPath2;
        }

        public void afterSaving(Bucket bucket) throws CoreException {
            this.saveChanges((PropertyBucket)bucket);
            this.changes.clear();
        }

        private void saveChanges(PropertyBucket propertyBucket) throws CoreException {
            if (this.changes.isEmpty()) {
                return;
            }
            Iterator iterator = this.changes.iterator();
            PropertyBucket.PropertyEntry propertyEntry = (PropertyBucket.PropertyEntry)iterator.next();
            PropertyManager2.this.tree.loadBucketFor(propertyEntry.getPath());
            propertyBucket.setProperties(propertyEntry);
            while (iterator.hasNext()) {
                propertyBucket.setProperties((PropertyBucket.PropertyEntry)iterator.next());
            }
            propertyBucket.save();
        }

        public int visit(Bucket.Entry entry) {
            PropertyBucket.PropertyEntry propertyEntry = (PropertyBucket.PropertyEntry)entry;
            IPath iPath = this.destination.append(propertyEntry.getPath().removeFirstSegments(this.source.segmentCount()));
            PropertyBucket.PropertyEntry propertyEntry2 = new PropertyBucket.PropertyEntry(iPath, propertyEntry);
            this.changes.add(propertyEntry2);
            return 0;
        }
    }
}

