/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.propertytester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.internal.propertytester.StringMatcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class ResourcePropertyTester
extends PropertyTester {
    protected static final String EXTENSION = "extension";
    protected static final String NAME = "name";
    protected static final String PATH = "path";
    protected static final String PERSISTENT_PROPERTY = "persistentProperty";
    protected static final String PROJECT_NATURE = "projectNature";
    protected static final String PROJECT_PERSISTENT_PROPERTY = "projectPersistentProperty";
    protected static final String PROJECT_SESSION_PROPERTY = "projectSessionProperty";
    protected static final String READ_ONLY = "readOnly";
    protected static final String SESSION_PROPERTY = "sessionProperty";

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        if (!(object instanceof IResource)) {
            return false;
        }
        IResource iResource = (IResource)object;
        if (string.equals(NAME)) {
            return new StringMatcher(this.toString(object2)).match(iResource.getName());
        }
        if (string.equals(PATH)) {
            return new StringMatcher(this.toString(object2)).match(iResource.getFullPath().toString());
        }
        if (string.equals(EXTENSION)) {
            return new StringMatcher(this.toString(object2)).match(iResource.getFileExtension());
        }
        if (string.equals(READ_ONLY)) {
            ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
            return (resourceAttributes != null && resourceAttributes.isReadOnly()) == this.toBoolean(object2);
        }
        if (string.equals(PROJECT_NATURE)) {
            try {
                IProject iProject = iResource.getProject();
                return iProject != null && iProject.isAccessible() && iProject.hasNature(this.toString(object2));
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (string.equals(PERSISTENT_PROPERTY)) {
            return this.testProperty(iResource, true, objectArray, object2);
        }
        if (string.equals(PROJECT_PERSISTENT_PROPERTY)) {
            return this.testProperty(iResource.getProject(), true, objectArray, object2);
        }
        if (string.equals(SESSION_PROPERTY)) {
            return this.testProperty(iResource, false, objectArray, object2);
        }
        if (string.equals(PROJECT_SESSION_PROPERTY)) {
            return this.testProperty(iResource.getProject(), false, objectArray, object2);
        }
        return false;
    }

    protected boolean testProperty(IResource iResource, boolean bl, Object[] objectArray, Object object) {
        Object object2;
        String string;
        block8: {
            String string2;
            if (iResource == null) {
                return false;
            }
            if (objectArray.length == 0) {
                string2 = this.toString(object);
                string = null;
            } else if (objectArray.length == 1) {
                string2 = this.toString(objectArray[0]);
                string = null;
            } else {
                string2 = this.toString(objectArray[0]);
                string = this.toString(objectArray[1]);
            }
            try {
                QualifiedName qualifiedName = this.toQualifedName(string2);
                Object object3 = object2 = bl ? iResource.getPersistentProperty(qualifiedName) : iResource.getSessionProperty(qualifiedName);
                if (object2 != null) break block8;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return string == null || string.equals(object2.toString());
    }

    protected boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return true;
    }

    protected QualifiedName toQualifedName(String string) {
        int n = string.lastIndexOf(46);
        QualifiedName qualifiedName = n != -1 ? new QualifiedName(string.substring(0, n), string.substring(n + 1)) : new QualifiedName(null, string);
        return qualifiedName;
    }

    protected String toString(Object object) {
        return object == null ? "" : object.toString();
    }
}

