/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.refresh.PollingMonitor;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.RefreshProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

class MonitorManager
implements ILifecycleListener,
IPathVariableChangeListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected final PollingMonitor pollMonitor;
    private RefreshProvider[] providers;
    protected final RefreshManager refreshManager;
    protected final Map registeredMonitors;
    protected IWorkspace workspace;

    public MonitorManager(IWorkspace iWorkspace, RefreshManager refreshManager) {
        this.workspace = iWorkspace;
        this.refreshManager = refreshManager;
        this.registeredMonitors = Collections.synchronizedMap(new HashMap(10));
        this.pollMonitor = new PollingMonitor(refreshManager);
    }

    private RefreshProvider[] getRefreshProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "refreshProviders");
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        ArrayList<RefreshProvider> arrayList = new ArrayList<RefreshProvider>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            RefreshProvider refreshProvider = null;
            try {
                refreshProvider = (RefreshProvider)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                Policy.log(2, Messages.refresh_installError, coreException);
            }
            if (refreshProvider != null) {
                arrayList.add(refreshProvider);
            }
            ++n;
        }
        this.providers = arrayList.toArray(new RefreshProvider[arrayList.size()]);
        return this.providers;
    }

    private List getResourcesToMonitor() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(10);
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isAccessible()) {
                arrayList.add(iProjectArray[n]);
                try {
                    IResource[] iResourceArray = iProjectArray[n].members();
                    int n2 = 0;
                    while (n2 < iResourceArray.length) {
                        if (iResourceArray[n2].isLinked()) {
                            arrayList.add(iResourceArray[n2]);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    Policy.log(2, Messages.refresh_refreshErr, coreException);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.kind) {
            case 1: 
            case 16: 
            case 1024: {
                this.unmonitor(lifecycleEvent.resource);
                if (lifecycleEvent.resource.getType() != 4) break;
                ((IProject)lifecycleEvent.resource).getPathVariableManager().removeChangeListener(this);
                break;
            }
            case 32: {
                ((IProject)lifecycleEvent.resource).getPathVariableManager().addChangeListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMonitoring(IResource iResource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            List list;
            Iterator iterator = this.registeredMonitors.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((list = (List)this.registeredMonitors.get(iterator.next())) == null || !list.contains(iResource));
            return true;
        }
    }

    boolean monitor(IResource iResource) {
        if (this.isMonitoring(iResource)) {
            return false;
        }
        boolean bl = true;
        RefreshProvider[] refreshProviderArray = this.getRefreshProviders();
        int n = 0;
        while (n < refreshProviderArray.length) {
            IRefreshMonitor iRefreshMonitor = this.safeInstallMonitor(refreshProviderArray[n], iResource);
            if (iRefreshMonitor != null) {
                this.registerMonitor(iRefreshMonitor, iResource);
                bl = false;
            }
            ++n;
        }
        if (bl) {
            this.pollMonitor.monitor(iResource);
            this.registerMonitor(this.pollMonitor, iResource);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorFailed(IRefreshMonitor iRefreshMonitor, IResource iResource) {
        if (RefreshManager.DEBUG) {
            System.err.println("Auto-refresh:  monitor (" + iRefreshMonitor + ") failed to monitor resource: " + iResource);
        }
        if (this.registeredMonitors == null || iRefreshMonitor == null) {
            return;
        }
        if (iResource == null) {
            List list = (List)this.registeredMonitors.get(iRefreshMonitor);
            if (list == null || list.isEmpty()) {
                this.registeredMonitors.remove(iRefreshMonitor);
                return;
            }
            Map map = this.registeredMonitors;
            synchronized (map) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    iResource = (IResource)iterator.next();
                    this.pollMonitor.monitor(iResource);
                    this.registerMonitor(this.pollMonitor, iResource);
                }
                this.registeredMonitors.remove(iRefreshMonitor);
            }
        } else {
            this.removeMonitor(iRefreshMonitor, iResource);
            this.pollMonitor.monitor(iResource);
            this.registerMonitor(this.pollMonitor, iResource);
        }
    }

    public void pathVariableChanged(IPathVariableChangeEvent iPathVariableChangeEvent) {
        Object object;
        if (this.registeredMonitors.isEmpty()) {
            return;
        }
        String string = iPathVariableChangeEvent.getVariableName();
        HashSet<IResource> hashSet = new HashSet<IResource>();
        Iterator<Object> iterator = this.registeredMonitors.values().iterator();
        while (iterator.hasNext()) {
            object = ((List)iterator.next()).iterator();
            while (object.hasNext()) {
                IResource iResource = (IResource)object.next();
                IPath iPath = iResource.getRawLocation();
                if (iPath == null || iPath.segmentCount() <= 0 || !string.equals(iPath.segment(0)) || hashSet.contains(iResource)) continue;
                hashSet.add(iResource);
            }
        }
        if (!hashSet.isEmpty()) {
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (IResource)iterator.next();
                this.unmonitor((IResource)object);
                this.monitor((IResource)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMonitor(IRefreshMonitor iRefreshMonitor, IResource iResource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            ArrayList<IResource> arrayList = (ArrayList<IResource>)this.registeredMonitors.get(iRefreshMonitor);
            if (arrayList == null) {
                arrayList = new ArrayList<IResource>(1);
                this.registeredMonitors.put(iRefreshMonitor, arrayList);
            }
            if (!arrayList.contains(iResource)) {
                arrayList.add(iResource);
            }
        }
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  added monitor (" + iRefreshMonitor + ") on resource: " + iResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMonitor(IRefreshMonitor iRefreshMonitor, IResource iResource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            List list = (List)this.registeredMonitors.get(iRefreshMonitor);
            if (list != null && !list.isEmpty()) {
                list.remove(iResource);
            } else {
                this.registeredMonitors.remove(iRefreshMonitor);
            }
        }
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  removing monitor (" + iRefreshMonitor + ") on resource: " + iResource);
        }
    }

    private IRefreshMonitor safeInstallMonitor(RefreshProvider refreshProvider, IResource iResource) {
        Throwable throwable = null;
        try {
            return refreshProvider.installMonitor(iResource, this.refreshManager);
        }
        catch (Exception exception) {
            throwable = exception;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        Status status = new Status(4, "org.eclipse.core.resources", 1, Messages.refresh_installError, throwable);
        Policy.log((IStatus)status);
        return null;
    }

    public void start() {
        boolean bl = false;
        Iterator iterator = this.getResourcesToMonitor().iterator();
        while (iterator.hasNext()) {
            bl |= !this.monitor((IResource)iterator.next());
        }
        this.workspace.getPathVariableManager().addChangeListener(this);
        this.workspace.addResourceChangeListener(this, 1);
        ((Workspace)this.workspace).addLifecycleListener(this);
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  starting monitor manager.");
        }
        if (bl) {
            new PollingMonitor(this.refreshManager).runOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.workspace.removeResourceChangeListener(this);
        this.workspace.getPathVariableManager().removeChangeListener(this);
        Map map = this.registeredMonitors;
        synchronized (map) {
            Iterator iterator = this.registeredMonitors.keySet().iterator();
            while (iterator.hasNext()) {
                IRefreshMonitor iRefreshMonitor = (IRefreshMonitor)iterator.next();
                iRefreshMonitor.unmonitor(null);
            }
        }
        this.registeredMonitors.clear();
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  stopping monitor manager.");
        }
        this.pollMonitor.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmonitor(IResource iResource) {
        if (iResource == null || !this.isMonitoring(iResource)) {
            return;
        }
        Map map = this.registeredMonitors;
        synchronized (map) {
            Iterator iterator = this.registeredMonitors.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                List list = (List)entry.getValue();
                if (list == null || list.isEmpty() || !list.contains(iResource)) continue;
                ((IRefreshMonitor)entry.getKey()).unmonitor(iResource);
                list.remove(iResource);
            }
        }
        if (iResource.getType() == 4) {
            this.unmonitorLinkedContents((IProject)iResource);
        }
    }

    private void unmonitorLinkedContents(IProject iProject) {
        if (!iProject.isAccessible()) {
            return;
        }
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iProject.members();
        }
        catch (CoreException coreException) {
            Policy.log(2, Messages.refresh_refreshErr, coreException);
        }
        if (iResourceArray != null && iResourceArray.length > 0) {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].isLinked()) {
                    this.unmonitor(iResourceArray[n]);
                }
                ++n;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        try {
            iResourceDelta.accept(this);
        }
        catch (CoreException coreException) {}
    }

    public boolean visit(IResourceDelta iResourceDelta) {
        IResource iResource;
        if (iResourceDelta.getKind() == 1 && (iResource = iResourceDelta.getResource()).isLinked()) {
            this.monitor(iResource);
        }
        if ((iResourceDelta.getFlags() & 0x4000) != 0 && (iResource = (IProject)iResourceDelta.getResource()).isAccessible()) {
            this.monitor(iResource);
        }
        return true;
    }
}

