/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

public class PollingMonitor
extends Job
implements IRefreshMonitor {
    private static final long MAX_DURATION = 250L;
    private static final long HOT_ROOT_DECAY = 90000L;
    private static final long MIN_FREQUENCY = 4000L;
    private final ArrayList resourceRoots;
    private final ArrayList toRefresh;
    private IResource hotRoot;
    private long hotRootTime;
    private final RefreshManager refreshManager;
    private boolean firstRun = true;

    public PollingMonitor(RefreshManager refreshManager) {
        super(Messages.refresh_pollJob);
        this.refreshManager = refreshManager;
        this.setPriority(50);
        this.setSystem(true);
        this.resourceRoots = new ArrayList();
        this.toRefresh = new ArrayList();
    }

    public synchronized void monitor(IResource iResource) {
        this.resourceRoots.add(iResource);
        this.schedule(4000L);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.firstRun) {
            this.firstRun = false;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
            long l = System.currentTimeMillis();
            while (bundle.getState() == 8) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                if (System.currentTimeMillis() - l > 90000L) break;
            }
        }
        long l = System.currentTimeMillis();
        if (this.toRefresh.isEmpty()) {
            this.beginIteration();
            if (RefreshManager.DEBUG) {
                System.out.println("Auto-refresh: New polling iteration on " + this.toRefresh.size() + " roots");
            }
        }
        int n = this.toRefresh.size();
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh: started polling");
        }
        if (l - this.hotRootTime > 90000L) {
            this.hotRoot = null;
        } else if (this.hotRoot != null && !iProgressMonitor.isCanceled()) {
            this.poll(this.hotRoot);
        }
        long l2 = System.currentTimeMillis();
        while (!this.toRefresh.isEmpty()) {
            if (iProgressMonitor.isCanceled()) break;
            this.poll((IResource)this.toRefresh.remove(this.toRefresh.size() - 1));
            if (System.currentTimeMillis() - l2 > 250L) break;
        }
        l = System.currentTimeMillis() - l;
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh: polled " + (n - this.toRefresh.size()) + " roots in " + l + "ms");
        }
        long l3 = Math.max(4000L, l * 20L);
        if (!PollingMonitor.getJobManager().isIdle()) {
            l3 *= 2L;
        }
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh: rescheduling polling job in: " + l3 / 1000L + " seconds");
        }
        if (Platform.getBundle((String)"org.eclipse.core.resources").getState() == 32) {
            this.schedule(l3);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runOnce() {
        PollingMonitor pollingMonitor = this;
        synchronized (pollingMonitor) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects(8);
            int n = 0;
            while (n < iProjectArray.length) {
                this.toRefresh.add(iProjectArray[n]);
                ++n;
            }
        }
        this.schedule(4000L);
    }

    private void poll(IResource iResource) {
        if (iResource.isSynchronized(2)) {
            return;
        }
        if (iResource.isLinked() && !((Resource)iResource).getStore().fetchInfo().exists()) {
            return;
        }
        this.refreshManager.refresh(iResource);
        this.hotRoot = iResource;
        this.hotRootTime = System.currentTimeMillis();
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh: new hot root: " + iResource);
        }
    }

    public boolean shouldRun() {
        return !this.resourceRoots.isEmpty() || !this.toRefresh.isEmpty();
    }

    private synchronized void beginIteration() {
        this.toRefresh.addAll(this.resourceRoots);
        if (this.hotRoot != null) {
            this.toRefresh.remove(this.hotRoot);
        }
    }

    public synchronized void unmonitor(IResource iResource) {
        if (iResource == null) {
            this.resourceRoots.clear();
        } else {
            this.resourceRoots.remove(iResource);
        }
        if (this.resourceRoots.isEmpty()) {
            this.cancel();
        }
    }
}

