/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.localstore.PrefixPool;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RefreshJob
extends WorkspaceJob {
    private static final long UPDATE_DELAY = 200L;
    private final List fRequests = new ArrayList(1);
    private PrefixPool pathPrefixHistory;
    private PrefixPool rootPathHistory;

    public RefreshJob() {
        super(Messages.refresh_jobName);
    }

    private synchronized void addRequest(IResource iResource) {
        IPath iPath = iResource.getFullPath();
        Iterator iterator = this.fRequests.iterator();
        while (iterator.hasNext()) {
            IPath iPath2 = ((IResource)iterator.next()).getFullPath();
            if (iPath.isPrefixOf(iPath2)) {
                iterator.remove();
                continue;
            }
            if (!iPath2.isPrefixOf(iPath)) continue;
            return;
        }
        this.fRequests.add(iResource);
    }

    private synchronized void addRequests(List list) {
        this.fRequests.addAll(0, list);
    }

    public boolean belongsTo(Object object) {
        return object == ResourcesPlugin.FAMILY_AUTO_REFRESH;
    }

    private List collectChildrenToDepth(IResource iResource, ArrayList arrayList, int n) {
        IResource[] iResourceArray;
        if (iResource.getType() == 1) {
            return arrayList;
        }
        try {
            iResourceArray = ((IContainer)iResource).members();
        }
        catch (CoreException coreException) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            if (iResourceArray[n2].getType() != 1) {
                if (n <= 1) {
                    arrayList.add(iResourceArray[n2]);
                } else {
                    this.collectChildrenToDepth(iResourceArray[n2], arrayList, n - 1);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public PrefixPool getPathPrefixHistory() {
        if (this.pathPrefixHistory == null) {
            this.pathPrefixHistory = new PrefixPool(20);
        }
        return this.pathPrefixHistory;
    }

    public PrefixPool getRootPathHistory() {
        if (this.rootPathHistory == null) {
            this.rootPathHistory = new PrefixPool(20);
        }
        return this.rootPathHistory;
    }

    private synchronized IResource nextRequest() {
        int n = this.fRequests.size();
        if (n == 0) {
            return null;
        }
        return (IResource)this.fRequests.remove(n - 1);
    }

    public void refresh(IResource iResource) {
        if (iResource == null) {
            return;
        }
        this.addRequest(iResource);
        this.schedule(200L);
    }

    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) {
        long l = System.currentTimeMillis();
        String string = Messages.refresh_refreshErr;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 1, string, null);
        long l2 = 0L;
        try {
            IResource iResource;
            if (RefreshManager.DEBUG) {
                Policy.debug("Auto-refresh:  starting refresh job");
            }
            int n = 0;
            int n2 = 2;
            iProgressMonitor.beginTask("", -1);
            while ((iResource = this.nextRequest()) != null) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    ++n;
                    long l3 = -System.currentTimeMillis();
                    iResource.refreshLocal(1000 + n2, null);
                    if ((l3 += System.currentTimeMillis()) > l2) {
                        l2 = l3;
                    }
                    if (n % 100 == 0) {
                        iProgressMonitor.subTask(NLS.bind((String)Messages.refresh_task, (Object)Integer.toString(this.fRequests.size())));
                    }
                    if (n % 1000 == 0) {
                        Thread.yield();
                        if (l2 > 2000L && n2 > 1) {
                            n2 = 1;
                        }
                        if (l2 < 1000L) {
                            n2 *= 2;
                        }
                        l2 = 0L;
                    }
                    this.addRequests(this.collectChildrenToDepth(iResource, new ArrayList(), n2));
                }
                catch (CoreException coreException) {
                    multiStatus.merge((IStatus)new Status(4, "org.eclipse.core.resources", 1, multiStatus.getMessage(), (Throwable)coreException));
                }
            }
        }
        finally {
            this.pathPrefixHistory = null;
            this.rootPathHistory = null;
            iProgressMonitor.done();
            if (RefreshManager.DEBUG) {
                System.out.println("Auto-refresh:  finished refresh job in: " + (System.currentTimeMillis() - l) + "ms");
            }
        }
        if (!multiStatus.isOK()) {
            return multiStatus;
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean shouldRun() {
        return !this.fRequests.isEmpty();
    }

    public void start() {
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  enabling auto-refresh");
        }
    }

    public void stop() {
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  disabling auto-refresh");
        }
        this.cancel();
    }
}

