/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import org.eclipse.core.internal.refresh.MonitorManager;
import org.eclipse.core.internal.refresh.RefreshJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;

public class RefreshManager
implements IRefreshResult,
IManager,
Preferences.IPropertyChangeListener {
    public static boolean DEBUG = Policy.DEBUG_AUTO_REFRESH;
    public static final String DEBUG_PREFIX = "Auto-refresh: ";
    MonitorManager monitors;
    private RefreshJob refreshJob;
    private IWorkspace workspace;

    public RefreshManager(IWorkspace iWorkspace) {
        this.workspace = iWorkspace;
    }

    protected void manageAutoRefresh(boolean bl) {
        if (this.refreshJob == null) {
            return;
        }
        if (bl) {
            this.refreshJob.start();
            this.monitors.start();
        } else {
            this.refreshJob.stop();
            this.monitors.stop();
        }
    }

    public void monitorFailed(IRefreshMonitor iRefreshMonitor, IResource iResource) {
        this.monitors.monitorFailed(iRefreshMonitor, iResource);
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("refresh.enabled".equals(string)) {
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            boolean bl = preferences.getBoolean("refresh.enabled");
            this.manageAutoRefresh(bl);
        }
    }

    public void refresh(IResource iResource) {
        if (this.refreshJob != null) {
            this.refreshJob.refresh(iResource);
        }
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        if (this.monitors != null) {
            this.monitors.stop();
            this.monitors = null;
        }
        if (this.refreshJob != null) {
            this.refreshJob.stop();
            this.refreshJob = null;
        }
    }

    public void startup(IProgressMonitor iProgressMonitor) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.refreshJob = new RefreshJob();
        this.monitors = new MonitorManager(this.workspace, this);
        boolean bl = preferences.getBoolean("refresh.enabled");
        if (bl) {
            this.manageAutoRefresh(bl);
        }
    }
}

