/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class AliasManager
implements IManager,
ILifecycleListener,
IResourceChangeListener {
    private final AddToCollectionDoit addToCollection = new AddToCollectionDoit();
    protected final Set aliasedProjects = new HashSet();
    protected final HashSet aliases = new HashSet();
    private final Set changedLinks = new HashSet();
    private boolean changedProjects = false;
    private final FindAliasesDoit findAliases = new FindAliasesDoit();
    protected final LocationMap locationsMap = new LocationMap();
    private int nonDefaultResourceCount = 0;
    public IPath suffix;
    protected final Workspace workspace;

    public AliasManager(Workspace workspace) {
        this.workspace = workspace;
    }

    private void addToLocationsMap(IProject iProject) {
        HashMap hashMap;
        ProjectDescription projectDescription;
        IFileStore iFileStore = ((Resource)((Object)iProject)).getStore();
        if (iFileStore != null) {
            this.locationsMap.add(iFileStore, iProject);
        }
        if ((projectDescription = ((Project)iProject).internalGetDescription()) == null) {
            return;
        }
        if (projectDescription.getLocationURI() != null) {
            ++this.nonDefaultResourceCount;
        }
        if ((hashMap = projectDescription.getLinks()) == null) {
            return;
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            LinkDescription linkDescription = (LinkDescription)iterator.next();
            IResource iResource = iProject.findMember(linkDescription.getProjectRelativePath());
            if (iResource == null) continue;
            try {
                URI uRI = linkDescription.getLocationURI();
                uRI = iProject.getPathVariableManager().resolveURI(uRI);
                this.addToLocationsMap(iResource, EFS.getStore((URI)uRI));
            }
            catch (CoreException coreException) {}
        }
    }

    private void addToLocationsMap(IResource iResource, IFileStore iFileStore) {
        if (iFileStore != null && !iResource.isGroup() && this.locationsMap.add(iFileStore, iResource)) {
            ++this.nonDefaultResourceCount;
        }
    }

    private void buildAliasedProjectsSet() {
        this.aliasedProjects.clear();
        if (this.nonDefaultResourceCount <= 0) {
            return;
        }
        this.addToCollection.setCollection(this.aliasedProjects);
        this.locationsMap.overLappingResourcesDo(this.addToCollection);
    }

    private void buildLocationsMap() {
        this.locationsMap.clear();
        this.nonDefaultResourceCount = 0;
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isAccessible()) {
                this.addToLocationsMap(iProjectArray[n]);
            }
            ++n;
        }
    }

    private boolean checkDeletion(Project project, IFileStore iFileStore) throws CoreException {
        if (project.exists() && !iFileStore.fetchInfo().exists()) {
            Assert.isTrue((this.workspace.getWorkManager().getLock().getDepth() > 0 ? 1 : 0) != 0);
            project.deleteResource(false, null);
            return true;
        }
        return false;
    }

    public IResource[] computeAliases(IResource iResource, IFileStore iFileStore) {
        if (this.hasNoAliases(iResource)) {
            return null;
        }
        this.aliases.clear();
        this.internalComputeAliases(iResource, iFileStore);
        int n = this.aliases.size();
        if (n == 0) {
            return null;
        }
        return this.aliases.toArray(new IResource[n]);
    }

    private void computeDeepAliases(IResource iResource, IFileStore iFileStore) {
        if (iFileStore == null) {
            return;
        }
        this.internalComputeAliases(iResource, iFileStore);
        this.addToCollection.setCollection(this.aliases);
        this.locationsMap.matchingPrefixDo(iFileStore, this.addToCollection);
        if (iResource.getType() == 4) {
            try {
                IResource[] iResourceArray = ((IProject)iResource).members();
                FileSystemResourceManager fileSystemResourceManager = this.workspace.getFileSystemManager();
                int n = 0;
                while (n < iResourceArray.length) {
                    IFileStore iFileStore2;
                    if (iResourceArray[n].isLinked() && (iFileStore2 = fileSystemResourceManager.getStore(iResourceArray[n])) != null) {
                        this.locationsMap.matchingPrefixDo(iFileStore2, this.addToCollection);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private Comparator getComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                URI uRI;
                URI uRI2;
                IFileStore iFileStore = (IFileStore)object;
                IFileStore iFileStore2 = (IFileStore)object2;
                int n = this.compareStringOrNull(iFileStore.getFileSystem().getScheme(), iFileStore2.getFileSystem().getScheme());
                if (n != 0) {
                    return n;
                }
                try {
                    uRI2 = iFileStore.toURI();
                    uRI = iFileStore2.toURI();
                }
                catch (Exception exception) {
                    Policy.log(exception);
                    return 1;
                }
                Path path = new Path(uRI2.getPath());
                Path path2 = new Path(uRI.getPath());
                n = this.compareStringOrNull(path.getDevice(), path2.getDevice());
                if (n != 0) {
                    return n;
                }
                int n2 = path.segmentCount();
                int n3 = path2.segmentCount();
                int n4 = 0;
                while (n4 < n2 && n4 < n3) {
                    n = path.segment(n4).compareTo(path2.segment(n4));
                    if (n != 0) {
                        return n;
                    }
                    ++n4;
                }
                n = n2 - n3;
                if (n != 0) {
                    return n;
                }
                return this.compareStringOrNull(uRI2.getQuery(), uRI.getQuery());
            }

            private int compareStringOrNull(String string, String string2) {
                if (string == null) {
                    if (string2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (string2 == null) {
                    return -1;
                }
                return string.compareTo(string2);
            }
        };
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.kind) {
            case 1024: 
            case 524288: {
                Resource resource = (Resource)lifecycleEvent.resource;
                if (resource.isLinked()) {
                    this.removeFromLocationsMap(resource, resource.getStore());
                }
            }
            case 131072: {
                this.changedLinks.add(lifecycleEvent.resource);
                break;
            }
            case 262144: {
                this.changedLinks.add(lifecycleEvent.resource);
                break;
            }
            case 512: {
                this.changedLinks.add(lifecycleEvent.resource);
                break;
            }
            case 256: {
                this.changedLinks.add(lifecycleEvent.newResource);
                break;
            }
            case 2048: {
                Resource resource = (Resource)lifecycleEvent.resource;
                if (resource.isLinked()) {
                    this.removeFromLocationsMap(resource, resource.getStore());
                }
                this.changedLinks.add(lifecycleEvent.newResource);
            }
        }
    }

    private boolean hasNoAliases(IResource iResource) {
        boolean bl;
        IProject iProject = iResource.getProject();
        boolean bl2 = bl = !this.aliasedProjects.contains(iProject);
        if (this.hasStructureChanges()) {
            this.updateStructureChanges();
            bl &= this.nonDefaultResourceCount <= 0 || !this.aliasedProjects.contains(iProject);
        }
        return bl;
    }

    private boolean hasStructureChanges() {
        return this.changedProjects || !this.changedLinks.isEmpty();
    }

    private void internalComputeAliases(IResource iResource, IFileStore iFileStore) {
        IFileStore iFileStore2 = iFileStore;
        if (iFileStore2 == null) {
            iFileStore2 = ((Resource)iResource).getStore();
        }
        if (iFileStore2 == null) {
            return;
        }
        this.suffix = Path.EMPTY;
        this.findAliases.setSearchAlias(iResource);
        do {
            this.locationsMap.matchingResourcesDo(iFileStore2, this.findAliases);
            this.suffix = new Path(iFileStore2.getName()).append(this.suffix);
        } while ((iFileStore2 = iFileStore2.getParent()) != null);
    }

    private void removeFromLocationsMap(IResource iResource, IFileStore iFileStore) {
        if (iFileStore != null && this.locationsMap.remove(iFileStore, iResource)) {
            --this.nonDefaultResourceCount;
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        if (iResourceDelta.getAffectedChildren(3).length > 0) {
            this.changedProjects = true;
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            if ((iResourceDeltaArray[n].getFlags() & 0x80000) == 524288 || (iResourceDeltaArray[n].getFlags() & 0x4000) == 16384) {
                this.changedProjects = true;
                break;
            }
            ++n;
        }
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        this.workspace.removeResourceChangeListener(this);
        this.locationsMap.clear();
    }

    public void startup(IProgressMonitor iProgressMonitor) {
        this.workspace.addLifecycleListener(this);
        this.workspace.addResourceChangeListener(this, 1);
        this.buildLocationsMap();
        this.buildAliasedProjectsSet();
    }

    public void updateAliases(IResource iResource, IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.hasNoAliases(iResource)) {
            return;
        }
        this.aliases.clear();
        if (n == 0) {
            this.internalComputeAliases(iResource, iFileStore);
        } else {
            this.computeDeepAliases(iResource, iFileStore);
        }
        if (this.aliases.size() == 0) {
            return;
        }
        FileSystemResourceManager fileSystemResourceManager = this.workspace.getFileSystemManager();
        HashSet hashSet = (HashSet)this.aliases.clone();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IResource iResource2 = (IResource)iterator.next();
            iProgressMonitor.subTask(NLS.bind((String)Messages.links_updatingDuplicate, (Object)iResource2.getFullPath()));
            if (iResource2.getType() == 4 && this.checkDeletion((Project)iResource2, iFileStore) || ((Resource)iResource2).isFilteredFromParent()) continue;
            fileSystemResourceManager.refresh(iResource2, 2, false, null);
        }
    }

    private void updateStructureChanges() {
        boolean bl = false;
        if (this.changedProjects) {
            this.changedProjects = false;
            bl = true;
            this.buildLocationsMap();
        } else {
            Iterator iterator = this.changedLinks.iterator();
            while (iterator.hasNext()) {
                IResource iResource = (IResource)iterator.next();
                bl = true;
                if (!iResource.isAccessible() || !iResource.isLinked()) continue;
                this.addToLocationsMap(iResource, ((Resource)iResource).getStore());
            }
        }
        this.changedLinks.clear();
        if (bl) {
            this.buildAliasedProjectsSet();
        }
        this.changedProjects = false;
    }

    public class AddToCollectionDoit
    implements Doit {
        Collection collection;

        public void doit(IResource iResource) {
            this.collection.add(iResource);
        }

        public void setCollection(Collection collection) {
            this.collection = collection;
        }
    }

    static interface Doit {
        public void doit(IResource var1);
    }

    class FindAliasesDoit
    implements Doit {
        private int aliasType;
        private IPath searchPath;

        FindAliasesDoit() {
        }

        public void doit(IResource iResource) {
            if (iResource.getFullPath().isPrefixOf(this.searchPath)) {
                return;
            }
            IPath iPath = null;
            switch (iResource.getType()) {
                case 4: {
                    IResource iResource2;
                    if (AliasManager.this.suffix.segmentCount() > 0 && (iResource2 = ((IProject)iResource).findMember(AliasManager.this.suffix.segment(0))) != null && iResource2.isLinked()) {
                        return;
                    }
                    iPath = iResource.getFullPath().append(AliasManager.this.suffix);
                    break;
                }
                case 2: {
                    iPath = iResource.getFullPath().append(AliasManager.this.suffix);
                    break;
                }
                case 1: {
                    if (AliasManager.this.suffix.segmentCount() != 0) break;
                    iPath = iResource.getFullPath();
                }
            }
            if (iPath != null) {
                if (this.aliasType == 1) {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getFile(iPath));
                } else if (iPath.segmentCount() == 1) {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getProject(iPath.lastSegment()));
                } else {
                    AliasManager.this.aliases.add(AliasManager.this.workspace.getRoot().getFolder(iPath));
                }
            }
        }

        public void setSearchAlias(IResource iResource) {
            this.aliasType = iResource.getType();
            this.searchPath = iResource.getFullPath();
        }
    }

    class LocationMap {
        private final SortedMap map;

        LocationMap() {
            this.map = new TreeMap(AliasManager.this.getComparator());
        }

        public boolean add(IFileStore iFileStore, IResource iResource) {
            Object v = this.map.get(iFileStore);
            if (v == null) {
                this.map.put(iFileStore, iResource);
                return true;
            }
            if (v instanceof IResource) {
                if (iResource.equals(v)) {
                    return false;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(v);
                arrayList.add(iResource);
                this.map.put(iFileStore, arrayList);
                return true;
            }
            ArrayList arrayList = (ArrayList)v;
            if (arrayList.contains(iResource)) {
                return false;
            }
            arrayList.add(iResource);
            return true;
        }

        public void clear() {
            this.map.clear();
        }

        public void matchingPrefixDo(IFileStore iFileStore, Doit doit) {
            SortedMap sortedMap;
            IFileStore iFileStore2;
            IFileStore iFileStore3 = iFileStore.getParent();
            if (iFileStore3 != null) {
                iFileStore2 = iFileStore3.getChild(String.valueOf(iFileStore.getName()) + "\u0000");
                sortedMap = this.map.subMap(iFileStore, iFileStore2);
            } else {
                sortedMap = this.map;
            }
            iFileStore2 = sortedMap.values().iterator();
            while (iFileStore2.hasNext()) {
                Object e = iFileStore2.next();
                if (e == null) {
                    return;
                }
                if (e instanceof List) {
                    Iterator iterator = ((List)e).iterator();
                    while (iterator.hasNext()) {
                        doit.doit((IResource)iterator.next());
                    }
                    continue;
                }
                doit.doit((IResource)e);
            }
        }

        public void matchingResourcesDo(IFileStore iFileStore, Doit doit) {
            Object v = this.map.get(iFileStore);
            if (v == null) {
                return;
            }
            if (v instanceof List) {
                Iterator iterator = ((List)v).iterator();
                while (iterator.hasNext()) {
                    doit.doit((IResource)iterator.next());
                }
            } else {
                doit.doit((IResource)v);
            }
        }

        public void overLappingResourcesDo(Doit doit) {
            Iterator iterator = this.map.entrySet().iterator();
            IFileStore iFileStore = null;
            IResource iResource = null;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                IFileStore iFileStore2 = (IFileStore)entry.getKey();
                IResource iResource2 = null;
                Object v = entry.getValue();
                if (v instanceof List) {
                    Iterator iterator2 = ((List)v).iterator();
                    while (iterator2.hasNext()) {
                        doit.doit(((IResource)iterator2.next()).getProject());
                    }
                } else {
                    iResource2 = (IResource)v;
                }
                if (iFileStore != null && iFileStore.isParentOf(iFileStore2)) {
                    if (iResource != null) {
                        doit.doit(iResource.getProject());
                        iResource = null;
                    }
                    if (iResource2 == null) continue;
                    doit.doit(iResource2.getProject());
                    continue;
                }
                iFileStore = iFileStore2;
                iResource = iResource2;
            }
        }

        public boolean remove(IFileStore iFileStore, IResource iResource) {
            Object v = this.map.get(iFileStore);
            if (v == null) {
                return false;
            }
            if (v instanceof IResource) {
                if (iResource.equals(v)) {
                    this.map.remove(iFileStore);
                    return true;
                }
                return false;
            }
            ArrayList arrayList = (ArrayList)v;
            boolean bl = arrayList.remove(iResource);
            if (arrayList.size() == 0) {
                this.map.remove(iFileStore);
            }
            return bl;
        }
    }
}

