/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.CharsetDeltaJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class CharsetManager
implements IManager {
    public static final String ENCODING_PREF_NODE = "encoding";
    private static final String PROJECT_KEY = "<project>";
    private CharsetDeltaJob charsetListener;
    CharsetManagerJob job;
    private IResourceChangeListener listener;
    protected final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    Workspace workspace;

    public CharsetManager(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getCharsetFor(IPath iPath, boolean bl) {
        Assert.isLegal((iPath.segmentCount() >= 1 ? 1 : 0) != 0);
        IProject iProject = this.workspace.getRoot().getProject(iPath.segment(0));
        org.osgi.service.prefs.Preferences preferences = this.getPreferences(iProject, false);
        if (preferences == null) {
            return bl ? ResourcesPlugin.getEncoding() : null;
        }
        return this.internalGetCharsetFor(iPath, preferences, bl);
    }

    String getKeyFor(IPath iPath) {
        return iPath.segmentCount() > 1 ? iPath.removeFirstSegments(1).toString() : PROJECT_KEY;
    }

    org.osgi.service.prefs.Preferences getPreferences(IProject iProject, boolean bl) {
        org.osgi.service.prefs.Preferences preferences;
        block8: {
            block7: {
                block6: {
                    if (bl) {
                        return new ProjectScope(iProject).getNode("org.eclipse.core.resources").node(ENCODING_PREF_NODE);
                    }
                    preferences = Platform.getPreferencesService().getRootNode().node("project");
                    try {
                        if (preferences.nodeExists(iProject.getName())) break block6;
                        return null;
                    }
                    catch (BackingStoreException backingStoreException) {
                        String string = Messages.resources_readingEncoding;
                        Policy.log(new ResourceStatus(383, iProject.getFullPath(), string, backingStoreException));
                        return null;
                    }
                }
                preferences = preferences.node(iProject.getName());
                if (preferences.nodeExists("org.eclipse.core.resources")) break block7;
                return null;
            }
            preferences = preferences.node("org.eclipse.core.resources");
            if (preferences.nodeExists(ENCODING_PREF_NODE)) break block8;
            return null;
        }
        return preferences.node(ENCODING_PREF_NODE);
    }

    /*
     * Unable to fully structure code
     */
    private String internalGetCharsetFor(IPath var1_1, org.osgi.service.prefs.Preferences var2_2, boolean var3_3) {
        var4_4 = var2_2.get(this.getKeyFor(var1_1), null);
        if (var3_3) ** GOTO lbl6
        return var4_4;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.removeLastSegments(1);
            var4_4 = var2_2.get(this.getKeyFor(var1_1), null);
lbl6:
            // 2 sources

            ** while (var4_4 == null && var1_1.segmentCount() > 1)
        }
lbl7:
        // 1 sources

        return var4_4 == null ? ResourcesPlugin.getEncoding() : var4_4;
    }

    public void projectPreferencesChanged(IProject iProject) {
        this.charsetListener.charsetPreferencesChanged(iProject);
    }

    public void setCharsetFor(IPath iPath, String string) throws CoreException {
        if (iPath.segmentCount() == 0) {
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            if (string != null) {
                preferences.setValue(ENCODING_PREF_NODE, string);
            } else {
                preferences.setToDefault(ENCODING_PREF_NODE);
            }
            ResourcesPlugin.getPlugin().savePluginPreferences();
            return;
        }
        IProject iProject = this.workspace.getRoot().getProject(iPath.segment(0));
        org.osgi.service.prefs.Preferences preferences = this.getPreferences(iProject, true);
        if (string == null || string.trim().length() == 0) {
            preferences.remove(this.getKeyFor(iPath));
        } else {
            preferences.put(this.getKeyFor(iPath), string);
        }
        try {
            try {
                this.charsetListener.setDisabled(true);
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                String string2 = Messages.resources_savingEncoding;
                throw new ResourceException(382, iProject.getFullPath(), string2, backingStoreException);
            }
        }
        finally {
            this.charsetListener.setDisabled(false);
        }
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        this.workspace.removeResourceChangeListener(this.listener);
        if (this.charsetListener != null) {
            this.charsetListener.shutdown();
        }
    }

    public void startup(IProgressMonitor iProgressMonitor) {
        this.job = new CharsetManagerJob();
        this.listener = new Listener();
        this.workspace.addResourceChangeListener(this.listener, 1);
        this.charsetListener = new CharsetDeltaJob(this.workspace);
        this.charsetListener.startup();
    }

    private class CharsetManagerJob
    extends Job {
        private static final int CHARSET_UPDATE_DELAY = 500;
        private List asyncChanges = new ArrayList();

        public CharsetManagerJob() {
            super(Messages.resources_charsetUpdating);
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChanges(Set set) {
            if (set.isEmpty()) {
                return;
            }
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(set);
                this.asyncChanges.notify();
            }
            this.schedule(500L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getNextChange() {
            List list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : (IProject)this.asyncChanges.remove(this.asyncChanges.size() - 1);
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }
    }

    class Listener
    implements IResourceChangeListener {
        Listener() {
        }

        private void processEntryChanges(IResourceDelta iResourceDelta, Set set) {
            String[] stringArray;
            boolean bl = false;
            IProject iProject = (IProject)iResourceDelta.getResource();
            org.osgi.service.prefs.Preferences preferences = CharsetManager.this.getPreferences(iProject, false);
            if (preferences == null) {
                return;
            }
            try {
                stringArray = preferences.keys();
            }
            catch (BackingStoreException backingStoreException) {
                String string = Messages.resources_readingEncoding;
                Policy.log(new ResourceStatus(383, iProject.getFullPath(), string, backingStoreException));
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDelta.findMember((IPath)new Path(stringArray[n]));
                if (iResourceDelta2 != null && iResourceDelta2.getKind() == 2) {
                    bl = true;
                    String string = preferences.get(stringArray[n], null);
                    preferences.remove(stringArray[n]);
                    if ((iResourceDelta2.getFlags() & 0x2000) != 0) {
                        IProject iProject2 = CharsetManager.this.workspace.getRoot().getProject(iResourceDelta2.getMovedToPath().segment(0));
                        org.osgi.service.prefs.Preferences preferences2 = CharsetManager.this.getPreferences(iProject2, true);
                        preferences2.put(CharsetManager.this.getKeyFor(iResourceDelta2.getMovedToPath()), string);
                        if (iProject2 != iProject) {
                            set.add(iProject2);
                        }
                    }
                }
                ++n;
            }
            if (bl) {
                set.add(iProject);
            }
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            if (iResourceDelta == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            HashSet hashSet = new HashSet();
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                if (iResourceDeltaArray[n].getKind() == 4 && (iResourceDeltaArray[n].getFlags() & 0x4000) == 0) {
                    this.processEntryChanges(iResourceDeltaArray[n], hashSet);
                }
                ++n;
            }
            CharsetManager.this.job.addChanges(hashSet);
        }
    }
}

