/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public abstract class Container
extends Resource
implements IContainer {
    protected Container(IPath iPath, Workspace workspace) {
        super(iPath, workspace);
    }

    public void convertToPhantom() throws CoreException {
        if (this.isPhantom()) {
            return;
        }
        super.convertToPhantom();
        IResource[] iResourceArray = this.members(11);
        int n = 0;
        while (n < iResourceArray.length) {
            ((Resource)iResourceArray[n]).convertToPhantom();
            ++n;
        }
    }

    public boolean exists(IPath iPath) {
        return this.workspace.getResourceInfo(this.getFullPath().append(iPath), false, false) != null;
    }

    public IResource findMember(String string) {
        return this.findMember(string, false);
    }

    public IResource findMember(String string, boolean bl) {
        IPath iPath = this.getFullPath().append(string);
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, bl, false);
        return resourceInfo == null ? null : this.workspace.newResource(iPath, resourceInfo.getType());
    }

    public IResource findMember(IPath iPath) {
        return this.findMember(iPath, false);
    }

    public IResource findMember(IPath iPath, boolean bl) {
        iPath = this.getFullPath().append(iPath);
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, bl, false);
        return resourceInfo == null ? null : this.workspace.newResource(iPath, resourceInfo.getType());
    }

    protected void fixupAfterMoveSource() throws CoreException {
        super.fixupAfterMoveSource();
        if (!this.synchronizing(this.getResourceInfo(true, false))) {
            return;
        }
        IResource[] iResourceArray = this.members(11);
        int n = 0;
        while (n < iResourceArray.length) {
            ((Resource)iResourceArray[n]).fixupAfterMoveSource();
            ++n;
        }
    }

    protected IResource[] getChildren(int n) {
        IPath[] iPathArray = null;
        try {
            iPathArray = this.workspace.tree.getChildren(this.path);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (iPathArray == null || iPathArray.length == 0) {
            return ICoreConstants.EMPTY_RESOURCE_ARRAY;
        }
        IResource[] iResourceArray = new Resource[iPathArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < iPathArray.length) {
            ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPathArray[n3], true, false);
            if (resourceInfo != null && this.isMember(resourceInfo.getFlags(), n)) {
                iResourceArray[n2++] = this.workspace.newResource(iPathArray[n3], resourceInfo.getType());
            }
            ++n3;
        }
        if (n2 == iResourceArray.length) {
            return iResourceArray;
        }
        IResource[] iResourceArray2 = new Resource[n2];
        System.arraycopy(iResourceArray, 0, iResourceArray2, 0, n2);
        return iResourceArray2;
    }

    public IFile getFile(String string) {
        return (IFile)((Object)this.workspace.newResource(this.getFullPath().append(string), 1));
    }

    public IFile getFile(IPath iPath) {
        return (IFile)((Object)this.workspace.newResource(this.getFullPath().append(iPath), 1));
    }

    public IFolder getFolder(String string) {
        return (IFolder)((Object)this.workspace.newResource(this.getFullPath().append(string), 2));
    }

    public IFolder getFolder(IPath iPath) {
        return (IFolder)((Object)this.workspace.newResource(this.getFullPath().append(iPath), 2));
    }

    public boolean isLocal(int n, int n2) {
        if (!super.isLocal(n, n2)) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 == 1) {
            n2 = 0;
        }
        IResource[] iResourceArray = this.getChildren(0);
        int n3 = 0;
        while (n3 < iResourceArray.length) {
            if (!iResourceArray[n3].isLocal(n2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public IResource[] members() throws CoreException {
        return this.members(0);
    }

    public IResource[] members(boolean bl) throws CoreException {
        return this.members(bl ? 1 : 0);
    }

    public IResource[] members(int n) throws CoreException {
        boolean bl = (n & 1) != 0;
        ResourceInfo resourceInfo = this.getResourceInfo(bl, false);
        this.checkAccessible(this.getFlags(resourceInfo));
        if (resourceInfo.isSet(0x100000)) {
            this.workspace.refreshManager.refresh(this);
        }
        return this.getChildren(n);
    }

    public String getDefaultCharset() throws CoreException {
        return this.getDefaultCharset(true);
    }

    public IFile[] findDeletedMembersWithHistory(int n, IProgressMonitor iProgressMonitor) {
        IHistoryStore iHistoryStore = this.getLocalManager().getHistoryStore();
        IPath iPath = this.getFullPath();
        IWorkspaceRoot iWorkspaceRoot = this.getWorkspace().getRoot();
        HashSet<IFile> hashSet = new HashSet<IFile>();
        if (n == 0) {
            IFile iFile;
            if (iHistoryStore.getStates(iPath, iProgressMonitor).length > 0 && !(iFile = iWorkspaceRoot.getFile(iPath)).exists()) {
                hashSet.add(iFile);
            }
        } else {
            Set set = iHistoryStore.allFiles(iPath, n, iProgressMonitor);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IPath iPath2 = (IPath)iterator.next();
                IFile iFile = iWorkspaceRoot.getFile(iPath2);
                if (iFile.exists()) continue;
                hashSet.add(iFile);
            }
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }

    public void setDefaultCharset(String string) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(resourceInfo));
        this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), string);
    }

    public void setDefaultCharset(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string2 = NLS.bind((String)Messages.resources_settingDefaultCharsetContainer, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string2, 100);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().charsetRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
                    this.workspace.beginOperation(true);
                    this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), string);
                    IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){
                        boolean visitedRoot = false;

                        public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                            if (object == null) {
                                return false;
                            }
                            IPath iPath = iPathRequestor.requestPath();
                            if (!this.visitedRoot) {
                                this.visitedRoot = true;
                                ResourceInfo resourceInfo = Container.this.workspace.getResourceInfo(iPath, false, true);
                                if (resourceInfo == null) {
                                    return false;
                                }
                                resourceInfo.incrementCharsetGenerationCount();
                                return true;
                            }
                            if (Container.this.workspace.getCharsetManager().getCharsetFor(iPath, false) != null) {
                                return false;
                            }
                            ResourceInfo resourceInfo = Container.this.workspace.getResourceInfo(iPath, false, true);
                            if (resourceInfo == null) {
                                return false;
                            }
                            resourceInfo.incrementCharsetGenerationCount();
                            return true;
                        }
                    };
                    try {
                        new ElementTreeIterator(this.workspace.getElementTree(), this.getFullPath()).iterate(iElementContentVisitor);
                    }
                    catch (WrappedRuntimeException wrappedRuntimeException) {
                        throw (CoreException)wrappedRuntimeException.getTargetException();
                    }
                    iProgressMonitor.worked(Policy.opWork);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

