/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectContentTypes;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Cache;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ContentDescriptionManager
implements IManager,
IRegistryChangeListener,
IContentTypeManager.IContentTypeChangeListener,
ILifecycleListener {
    private static final QualifiedName CACHE_STATE = new QualifiedName("org.eclipse.core.resources", "contentCacheState");
    private static final QualifiedName CACHE_TIMESTAMP = new QualifiedName("org.eclipse.core.resources", "contentCacheTimestamp");
    public static final String FAMILY_DESCRIPTION_CACHE_FLUSH = "org.eclipse.core.resources.contentDescriptionCacheFamily";
    public static final byte EMPTY_CACHE = 1;
    public static final byte USED_CACHE = 2;
    public static final byte INVALID_CACHE = 3;
    public static final byte FLUSHING_CACHE = 4;
    public static final byte ABOUT_TO_FLUSH = 5;
    private static final String PT_CONTENTTYPES = "contentTypes";
    private Cache cache;
    private byte cacheState;
    private FlushJob flushJob;
    private ProjectContentTypes projectContentTypes;
    Workspace workspace;
    protected final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");

    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent contentTypeChangeEvent) {
        if (Policy.DEBUG_CONTENT_TYPE) {
            Policy.debug("Content type settings changed for " + contentTypeChangeEvent.getContentType());
        }
        this.invalidateCache(true, null);
    }

    synchronized void doFlushCache(IProgressMonitor iProgressMonitor, IPath[] iPathArray) throws CoreException {
        if (this.getCacheState() != 3 && this.getCacheState() != 5) {
            if (Policy.DEBUG_CONTENT_TYPE_CACHE) {
                Policy.debug("Content type cache flush not performed");
            }
            return;
        }
        try {
            this.setCacheState((byte)4);
            this.cache.discardAll();
            if (iPathArray == null || iPathArray.length == 0) {
                this.clearContentFlags((IPath)Path.ROOT, iProgressMonitor);
            } else {
                int n = 0;
                while (n < iPathArray.length) {
                    this.clearContentFlags(iPathArray[n], iProgressMonitor);
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            this.setCacheState((byte)3);
            throw coreException;
        }
        this.setCacheState((byte)1);
    }

    private void clearContentFlags(IPath iPath, final IProgressMonitor iProgressMonitor) {
        long l = System.currentTimeMillis();
        if (Policy.DEBUG_CONTENT_TYPE_CACHE) {
            Policy.debug("Flushing content type cache for " + iPath);
        }
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (object == null) {
                    return false;
                }
                ResourceInfo resourceInfo = (ResourceInfo)object;
                if (resourceInfo.getType() != 1) {
                    return true;
                }
                resourceInfo = ContentDescriptionManager.this.workspace.getResourceInfo(iPathRequestor.requestPath(), false, true);
                if (resourceInfo == null) {
                    return false;
                }
                resourceInfo.clear(393216);
                return true;
            }
        };
        new ElementTreeIterator(this.workspace.getElementTree(), iPath).iterate(iElementContentVisitor);
        if (Policy.DEBUG_CONTENT_TYPE_CACHE) {
            Policy.debug("Content type cache for " + iPath + " flushed in " + (System.currentTimeMillis() - l) + " ms");
        }
    }

    Cache getCache() {
        return this.cache;
    }

    public synchronized byte getCacheState() {
        if (this.cacheState != 0) {
            return this.cacheState;
        }
        try {
            String string = this.workspace.getRoot().getPersistentProperty(CACHE_STATE);
            this.cacheState = (byte)(string != null ? (int)Byte.parseByte(string) : 3);
        }
        catch (NumberFormatException numberFormatException) {
            this.cacheState = (byte)3;
        }
        catch (CoreException coreException) {
            Policy.log(coreException.getStatus());
            this.cacheState = (byte)3;
        }
        return this.cacheState;
    }

    public long getCacheTimestamp() throws CoreException {
        try {
            return Long.parseLong(this.workspace.getRoot().getPersistentProperty(CACHE_TIMESTAMP));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public IContentTypeMatcher getContentTypeMatcher(Project project) throws CoreException {
        return this.projectContentTypes.getMatcherFor(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IContentDescription getDescriptionFor(File file, ResourceInfo resourceInfo) throws CoreException {
        Cache.Entry entry;
        ContentDescriptionManager contentDescriptionManager;
        if (ProjectContentTypes.usesContentTypePreferences(file.getFullPath().segment(0))) {
            return this.readDescription(file);
        }
        if (this.getCacheState() == 3) {
            this.setCacheState((byte)5);
            this.cache.discardAll();
            this.flushJob.schedule(1000L);
        }
        if (this.getCacheState() != 5) {
            if (resourceInfo == null) {
                return null;
            }
            if (resourceInfo.isSet(131072)) {
                return null;
            }
            if (resourceInfo.isSet(262144)) {
                contentDescriptionManager = Platform.getContentTypeManager();
                entry = contentDescriptionManager.findContentTypeFor(file.getName());
                if (entry != null) {
                    return entry.getDefaultDescription();
                }
                resourceInfo.clear(393216);
            }
        }
        contentDescriptionManager = this;
        synchronized (contentDescriptionManager) {
            entry = this.cache.getEntry(file.getFullPath());
            if (entry != null && entry.getTimestamp() == this.getTimestamp(resourceInfo)) {
                return (IContentDescription)entry.getCached();
            }
            IContentDescription iContentDescription = this.readDescription(file);
            if (this.getCacheState() != 5) {
                this.setCacheState((byte)2);
                if (iContentDescription == null) {
                    resourceInfo.set(131072);
                    return null;
                }
                if (iContentDescription.getContentType().getDefaultDescription().equals(iContentDescription)) {
                    IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                    if (iContentDescription.getContentType().equals(iContentType)) {
                        resourceInfo.set(262144);
                        return iContentDescription;
                    }
                }
            }
            if (entry == null) {
                entry = this.cache.addEntry(file.getFullPath(), iContentDescription, this.getTimestamp(resourceInfo));
            } else {
                entry.setTimestamp(resourceInfo.getContentId());
                entry.setCached(iContentDescription);
            }
            return iContentDescription;
        }
    }

    private long getTimestamp(ResourceInfo resourceInfo) {
        return (long)resourceInfo.getContentId() + resourceInfo.getNodeId();
    }

    public synchronized void invalidateCache(boolean bl, IProject iProject) {
        if (this.getCacheState() == 1) {
            return;
        }
        try {
            this.setCacheState((byte)3);
        }
        catch (CoreException coreException) {
            Policy.log(coreException.getStatus());
        }
        if (Policy.DEBUG_CONTENT_TYPE_CACHE) {
            Policy.debug("Invalidated cache for " + (iProject == null ? Path.ROOT : iProject.getFullPath()));
        }
        if (bl) {
            try {
                this.setCacheState((byte)5);
                this.cache.discardAll();
            }
            catch (CoreException coreException) {
                Policy.log(coreException.getStatus());
            }
            this.flushJob.flush(iProject);
        }
    }

    private IContentDescription readDescription(File file) throws CoreException {
        if (Policy.DEBUG_CONTENT_TYPE) {
            Policy.debug("reading contents of " + file);
        }
        LazyFileInputStream lazyFileInputStream = new LazyFileInputStream(file.getStore());
        try {
            IContentTypeMatcher iContentTypeMatcher = this.getContentTypeMatcher((Project)file.getProject());
            IContentDescription iContentDescription = iContentTypeMatcher.getDescriptionFor((InputStream)lazyFileInputStream, file.getName(), IContentDescription.ALL);
            return iContentDescription;
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_errorContentDescription, (Object)file.getFullPath());
            throw new ResourceException(381, file.getFullPath(), string, iOException);
        }
        finally {
            file.ensureClosed(lazyFileInputStream);
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        if (iRegistryChangeEvent.getExtensionDeltas("org.eclipse.core.runtime", PT_CONTENTTYPES).length == 0) {
            return;
        }
        this.invalidateCache(true, null);
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.kind) {
            case 2: 
            case 16: 
            case 64: {
                this.invalidateCache(true, (IProject)lifecycleEvent.resource);
            }
        }
    }

    synchronized void setCacheState(byte by) throws CoreException {
        if (this.cacheState == by) {
            return;
        }
        this.workspace.getRoot().setPersistentProperty(CACHE_STATE, Byte.toString(by));
        this.cacheState = by;
    }

    private void setCacheTimeStamp(long l) throws CoreException {
        this.workspace.getRoot().setPersistentProperty(CACHE_TIMESTAMP, Long.toString(l));
    }

    public void shutdown(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.getCacheState() != 3) {
            this.setCacheTimeStamp(Platform.getStateStamp());
        }
        Platform.getContentTypeManager().removeContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        this.cache.dispose();
        this.cache = null;
        this.flushJob.cancel();
        this.flushJob = null;
        this.projectContentTypes = null;
    }

    public void startup(IProgressMonitor iProgressMonitor) throws CoreException {
        this.workspace = (Workspace)ResourcesPlugin.getWorkspace();
        this.cache = new Cache(100, 1000, 0.1);
        this.projectContentTypes = new ProjectContentTypes(this.workspace);
        this.getCacheState();
        if (this.cacheState == 4 || this.cacheState == 5) {
            this.setCacheState((byte)3);
        }
        this.flushJob = new FlushJob();
        if (this.getCacheTimestamp() != Platform.getStateStamp()) {
            this.invalidateCache(false, null);
        }
        this.workspace.addLifecycleListener(this);
        Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.core.runtime");
    }

    public void projectPreferencesChanged(IProject iProject) {
        if (Policy.DEBUG_CONTENT_TYPE) {
            Policy.debug("Project preferences changed for " + iProject);
        }
        this.projectContentTypes.contentTypePreferencesChanged(iProject);
    }

    private class FlushJob
    extends WorkspaceJob {
        private final List toFlush;
        private boolean fullFlush;

        public FlushJob() {
            super(Messages.resources_flushingContentDescriptionCache);
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
            this.setRule(ContentDescriptionManager.this.workspace.getRoot());
            this.toFlush = new ArrayList(5);
        }

        public boolean belongsTo(Object object) {
            return ContentDescriptionManager.FAMILY_DESCRIPTION_CACHE_FLUSH.equals(object);
        }

        public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) {
            if (iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                try {
                    iProgressMonitor.beginTask("", Policy.opWork);
                    IWorkspaceRoot iWorkspaceRoot = ContentDescriptionManager.this.workspace.getRoot();
                    try {
                        ContentDescriptionManager.this.workspace.prepareOperation(iWorkspaceRoot, iProgressMonitor);
                        ContentDescriptionManager.this.workspace.beginOperation(true);
                        if (ContentDescriptionManager.this.systemBundle.getState() != 16) {
                            ContentDescriptionManager.this.doFlushCache(iProgressMonitor, this.getPathsToFlush());
                        }
                    }
                    finally {
                        ContentDescriptionManager.this.workspace.endOperation(iWorkspaceRoot, false, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    iProgressMonitor.done();
                    return iStatus;
                }
                catch (CoreException coreException) {
                    IStatus iStatus = coreException.getStatus();
                    iProgressMonitor.done();
                    return iStatus;
                }
            }
            finally {
                iProgressMonitor.done();
            }
            return Status.OK_STATUS;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IPath[] getPathsToFlush() {
            List list = this.toFlush;
            synchronized (list) {
                try {
                    if (this.fullFlush) {
                        return null;
                    }
                    int n = this.toFlush.size();
                    IPath[] iPathArray = n == 0 ? null : this.toFlush.toArray(new IPath[n]);
                    return iPathArray;
                }
                finally {
                    this.fullFlush = false;
                    this.toFlush.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flush(IProject iProject) {
            if (Policy.DEBUG_CONTENT_TYPE_CACHE) {
                Policy.debug("Scheduling flushing of content type cache for " + (iProject == null ? Path.ROOT : iProject.getFullPath()));
            }
            List list = this.toFlush;
            synchronized (list) {
                if (!this.fullFlush) {
                    if (iProject == null) {
                        this.fullFlush = true;
                    } else {
                        this.toFlush.add(iProject.getFullPath());
                    }
                }
            }
            this.schedule(1000L);
        }
    }

    class LazyFileInputStream
    extends InputStream {
        private InputStream actual;
        private IFileStore target;

        LazyFileInputStream(IFileStore iFileStore) {
            this.target = iFileStore;
        }

        public int available() throws IOException {
            if (this.actual == null) {
                return 0;
            }
            return this.actual.available();
        }

        public void close() throws IOException {
            if (this.actual == null) {
                return;
            }
            this.actual.close();
        }

        private void ensureOpened() throws IOException {
            if (this.actual != null) {
                return;
            }
            if (this.target == null) {
                throw new FileNotFoundException();
            }
            try {
                this.actual = this.target.openInputStream(0, null);
            }
            catch (CoreException coreException) {
                throw new IOException(coreException.getMessage());
            }
        }

        public int read() throws IOException {
            this.ensureOpened();
            return this.actual.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.ensureOpened();
            return this.actual.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            this.ensureOpened();
            return this.actual.skip(l);
        }
    }
}

