/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.BitMask;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class File
extends Resource
implements IFile {
    protected File(IPath iPath, Workspace workspace) {
        super(iPath, workspace);
    }

    public void appendContents(InputStream inputStream, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_settingContents, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            Assert.isNotNull((Object)inputStream, (String)"Content cannot be null.");
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    ResourceInfo resourceInfo = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(resourceInfo));
                    this.workspace.beginOperation(true);
                    IFileInfo iFileInfo = this.getStore().fetchInfo();
                    this.internalSetContents(inputStream, iFileInfo, n, true, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void appendContents(InputStream inputStream, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.appendContents(inputStream, n |= bl2 ? 2 : 0, iProgressMonitor);
    }

    public IFolder changeToFolder() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 0);
        IFolder iFolder = this.workspace.getRoot().getFolder(this.path);
        if (this.isLinked()) {
            IPath iPath = this.getRawLocation();
            this.delete(0, null);
            iFolder.createLink(iPath, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource((IResource)iFolder, false);
        }
        return iFolder;
    }

    private void checkSynchronized() throws CoreException {
        if (!this.isSynchronized(0)) {
            String string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)this.getFullPath());
            throw new ResourceException(274, this.getFullPath(), string, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(InputStream inputStream, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = iProgressMonitor == null;
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = bl ? "" : NLS.bind((String)Messages.resources_creating, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            this.checkValidPath(this.path, 1, true);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    boolean bl2;
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.checkDoesNotExist();
                    Container container = (Container)this.getParent();
                    ResourceInfo resourceInfo = container.getResourceInfo(false, false);
                    container.checkAccessible(this.getFlags(resourceInfo));
                    this.checkValidGroupContainer(container, false, false);
                    this.workspace.beginOperation(true);
                    IFileStore iFileStore = this.getStore();
                    IFileInfo iFileInfo = iFileStore.fetchInfo();
                    if (BitMask.isSet(n, 1)) {
                        if (!Workspace.caseSensitive && iFileInfo.exists()) {
                            String string2 = this.getLocalManager().getLocalName(iFileStore);
                            if (string2 != null && !iFileInfo.getName().equals(string2)) {
                                string = NLS.bind((String)Messages.resources_existsLocalDifferentCase, (Object)new Path(iFileStore.toString()).removeLastSegments(1).append(string2).toOSString());
                                throw new ResourceException(275, this.getFullPath(), string, null);
                            }
                            this.delete(true, null);
                        }
                    } else if (iFileInfo.exists()) {
                        String string3;
                        if (!Workspace.caseSensitive && (string3 = this.getLocalManager().getLocalName(iFileStore)) != null && !iFileInfo.getName().equals(string3)) {
                            string = NLS.bind((String)Messages.resources_existsLocalDifferentCase, (Object)new Path(iFileStore.toString()).removeLastSegments(1).append(string3).toOSString());
                            throw new ResourceException(275, this.getFullPath(), string, null);
                        }
                        string = NLS.bind((String)Messages.resources_fileExists, (Object)iFileStore.toString());
                        throw new ResourceException(272, this.getFullPath(), string, null);
                    }
                    iProgressMonitor.worked(Policy.opWork * 40 / 100);
                    resourceInfo = this.workspace.createResource((IResource)this, n);
                    boolean bl3 = bl2 = inputStream != null;
                    if (bl2) {
                        try {
                            this.internalSetContents(inputStream, iFileInfo, n, false, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 60 / 100));
                        }
                        catch (CoreException coreException) {
                            this.workspace.deleteResource(this);
                            iFileStore.delete(0, null);
                            throw coreException;
                        }
                    }
                    this.internalSetLocal(bl2, 0);
                    if (bl2) return;
                    this.getResourceInfo(true, true).clearModificationStamp();
                    return;
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
            this.ensureClosed(inputStream);
        }
    }

    public void create(InputStream inputStream, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.create(inputStream, bl ? 1 : 0, iProgressMonitor);
    }

    protected void ensureClosed(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getCharset() throws CoreException {
        return this.getCharset(true);
    }

    public String getCharset(boolean bl) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        if (!this.exists(n, false)) {
            return bl ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
        }
        this.checkLocal(n, 0);
        return this.internalGetCharset(bl, resourceInfo);
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        IContentDescription iContentDescription;
        String string;
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        if (this.exists(n, true) && (string = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false)) != null) {
            return string;
        }
        try {
            IContentTypeManager iContentTypeManager = Platform.getContentTypeManager();
            iContentDescription = iContentTypeManager.getDescriptionFor(reader, this.getName(), new QualifiedName[]{IContentDescription.CHARSET});
        }
        catch (IOException iOException) {
            String string2 = NLS.bind((String)Messages.resources_errorContentDescription, (Object)this.getFullPath());
            throw new ResourceException(381, this.getFullPath(), string2, iOException);
        }
        if (iContentDescription != null && (string = iContentDescription.getCharset()) != null) {
            return string;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    private String internalGetCharset(boolean bl, ResourceInfo resourceInfo) throws CoreException {
        String string;
        String string2 = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false);
        if (string2 != null || !bl) {
            return string2;
        }
        IContentDescription iContentDescription = this.workspace.getContentDescriptionManager().getDescriptionFor(this, resourceInfo);
        if (iContentDescription != null && (string = iContentDescription.getCharset()) != null) {
            return string;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    public IContentDescription getContentDescription() throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        this.checkAccessible(n);
        this.checkSynchronized();
        this.checkLocal(n, 0);
        return this.workspace.getContentDescriptionManager().getDescriptionFor(this, resourceInfo);
    }

    public InputStream getContents() throws CoreException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean bl) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        this.checkAccessible(n);
        this.checkLocal(n, 0);
        return this.getLocalManager().read(this, bl, null);
    }

    public int getEncoding() throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        this.checkAccessible(n);
        this.checkLocal(n, 0);
        return this.getLocalManager().getEncoding(this);
    }

    public IFileState[] getHistory(IProgressMonitor iProgressMonitor) {
        return this.getLocalManager().getHistoryStore().getStates(this.getFullPath(), iProgressMonitor);
    }

    public int getType() {
        return 1;
    }

    protected void internalSetContents(InputStream inputStream, IFileInfo iFileInfo, int n, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        this.getLocalManager().write(this, inputStream, iFileInfo, n, bl, iProgressMonitor);
        this.updateMetadataFiles();
        this.workspace.getAliasManager().updateAliases(this, this.getStore(), 0, iProgressMonitor);
    }

    public void refreshLocal(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.getLocalManager().fastIsSynchronized(this)) {
            super.refreshLocal(0, iProgressMonitor);
        }
    }

    public void setContents(IFileState iFileState, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.setContents(iFileState.getContents(), n, iProgressMonitor);
    }

    public void setContents(InputStream inputStream, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_settingContents, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    ResourceInfo resourceInfo = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(resourceInfo));
                    this.workspace.beginOperation(true);
                    IFileInfo iFileInfo = this.getStore().fetchInfo();
                    this.internalSetContents(inputStream, iFileInfo, n, false, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
            this.ensureClosed(inputStream);
        }
    }

    public long setLocalTimeStamp(long l) throws CoreException {
        ResourceInfo resourceInfo;
        long l2 = super.setLocalTimeStamp(l);
        if (this.path.segmentCount() == 2 && this.path.segment(1).equals(".project") && (resourceInfo = ((Project)this.getProject()).getResourceInfo(false, false)) != null) {
            this.getLocalManager().updateLocalSync(resourceInfo, l2);
        }
        return l2;
    }

    public void updateMetadataFiles() throws CoreException {
        int n = this.path.segmentCount();
        String string = this.path.segment(1);
        if (n == 2 && string.equals(".project")) {
            ((Project)this.getProject()).updateDescription();
            return;
        }
        if (n == 3 && ".settings".equals(string)) {
            ProjectPreferences.updatePreferences(this);
            return;
        }
    }

    public void setCharset(String string) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(resourceInfo));
        this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), string);
    }

    public void setCharset(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string2 = NLS.bind((String)Messages.resources_settingCharset, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string2, 100);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().charsetRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    ResourceInfo resourceInfo = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(resourceInfo));
                    this.workspace.beginOperation(true);
                    this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), string);
                    resourceInfo = this.getResourceInfo(false, true);
                    resourceInfo.incrementCharsetGenerationCount();
                    iProgressMonitor.worked(Policy.opWork);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void setContents(InputStream inputStream, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.setContents(inputStream, n |= bl2 ? 2 : 0, iProgressMonitor);
    }

    public void setContents(IFileState iFileState, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.setContents(iFileState.getContents(), n |= bl2 ? 2 : 0, iProgressMonitor);
    }
}

