/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.util.NLS;

public class FileState
extends PlatformObject
implements IFileState {
    private static final IWorkspace workspace = ResourcesPlugin.getWorkspace();
    protected long lastModified;
    protected UniversalUniqueIdentifier uuid;
    protected IHistoryStore store;
    protected IPath fullPath;

    public FileState(IHistoryStore iHistoryStore, IPath iPath, long l, UniversalUniqueIdentifier universalUniqueIdentifier) {
        this.store = iHistoryStore;
        this.lastModified = l;
        this.uuid = universalUniqueIdentifier;
        this.fullPath = iPath;
    }

    public boolean exists() {
        return this.store.exists(this);
    }

    public String getCharset() throws CoreException {
        IResource iResource = workspace.getRoot().findMember(this.fullPath);
        if (iResource != null && iResource.getType() == 1) {
            return ((IFile)iResource).getCharset();
        }
        IContentTypeManager iContentTypeManager = Platform.getContentTypeManager();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getContents());
        boolean bl = false;
        try {
            IContentDescription iContentDescription = iContentTypeManager.getDescriptionFor((InputStream)bufferedInputStream, this.getName(), new QualifiedName[]{IContentDescription.CHARSET});
            String string = iContentDescription == null ? null : iContentDescription.getCharset();
            return string;
        }
        catch (IOException iOException) {
            bl = true;
            String string = NLS.bind((String)Messages.history_errorContentDescription, (Object)this.getFullPath());
            throw new ResourceException(381, this.getFullPath(), string, iOException);
        }
        finally {
            block10: {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {
                    if (bl) break block10;
                    String string = NLS.bind((String)Messages.history_errorContentDescription, (Object)this.getFullPath());
                    throw new ResourceException(381, this.getFullPath(), string, iOException);
                }
            }
        }
    }

    public InputStream getContents() throws CoreException {
        return this.store.getContents(this);
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public long getModificationTime() {
        return this.lastModified;
    }

    public String getName() {
        return this.fullPath.lastSegment();
    }

    public UniversalUniqueIdentifier getUUID() {
        return this.uuid;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FileState(uuid: ");
        stringBuffer.append(this.uuid.toString());
        stringBuffer.append(", lastModified: ");
        stringBuffer.append(this.lastModified);
        stringBuffer.append(", path: ");
        stringBuffer.append(this.fullPath);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

