/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.resources.IFilterType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Filter
implements IFilter {
    FilterDescription description;
    IProject project;
    IFilterType provider = null;

    public Filter(IProject iProject, FilterDescription filterDescription) {
        this.description = filterDescription;
        this.project = iProject;
    }

    public boolean match(IFileInfo iFileInfo) throws CoreException {
        if (this.provider == null) {
            this.provider = FilterTypeManager.getDefault().instantiate(this.getId(), this.project, this.getArguments());
            if (this.provider == null) {
                String string = NLS.bind((String)Messages.filters_missingFilterType, (Object)this.getId());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources", 2, string, (Throwable)new Error()));
            }
        }
        if (this.provider != null) {
            return this.provider.matches(iFileInfo);
        }
        return false;
    }

    public boolean isFirst() {
        FilterTypeManager.Descriptor descriptor = FilterTypeManager.getDefault().findDescriptor(this.getId());
        if (descriptor != null) {
            return descriptor.isFirstOrdering();
        }
        return false;
    }

    public String getArguments() {
        return this.description.getArguments();
    }

    public String getId() {
        return this.description.getFilterID();
    }

    public IPath getPath() {
        return this.description.getProjectRelativePath();
    }

    public IProject getProject() {
        return this.project;
    }

    public int getType() {
        return this.description.getType();
    }

    public boolean isIncludeOnly() {
        return (this.getType() & 1) != 0;
    }

    public boolean appliesTo(IFileInfo iFileInfo) {
        if (iFileInfo.isDirectory()) {
            return (this.getType() & 8) != 0;
        }
        return (this.getType() & 4) != 0;
    }

    public static IFileInfo[] filter(IProject iProject, LinkedList linkedList, LinkedList linkedList2, IFileInfo[] iFileInfoArray) throws CoreException {
        IFileInfo[] iFileInfoArray2 = Filter.filterIncludes(iProject, linkedList, iFileInfoArray);
        return Filter.filterExcludes(iProject, linkedList2, iFileInfoArray2);
    }

    public static IFileInfo[] filterIncludes(IProject iProject, LinkedList linkedList, IFileInfo[] iFileInfoArray) throws CoreException {
        if (linkedList.size() > 0) {
            IFileInfo[] iFileInfoArray2 = new IFileInfo[iFileInfoArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < iFileInfoArray.length) {
                IFileInfo iFileInfo = iFileInfoArray[n2];
                Iterator iterator = linkedList.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    Filter filter = (Filter)iterator.next();
                    if (!filter.appliesTo(iFileInfo)) continue;
                    bl = true;
                    if (!filter.match(iFileInfo)) continue;
                    iFileInfoArray2[n++] = iFileInfo;
                    break;
                }
                if (!bl) {
                    iFileInfoArray2[n++] = iFileInfo;
                }
                ++n2;
            }
            if (n != iFileInfoArray2.length) {
                IFileInfo[] iFileInfoArray3 = new IFileInfo[n];
                System.arraycopy(iFileInfoArray2, 0, iFileInfoArray3, 0, n);
                iFileInfoArray2 = iFileInfoArray3;
            }
            return iFileInfoArray2;
        }
        return iFileInfoArray;
    }

    public static IFileInfo[] filterExcludes(IProject iProject, LinkedList linkedList, IFileInfo[] iFileInfoArray) throws CoreException {
        if (linkedList.size() > 0) {
            IFileInfo[] iFileInfoArray2 = new IFileInfo[iFileInfoArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < iFileInfoArray.length) {
                IFileInfo iFileInfo = iFileInfoArray[n2];
                Iterator iterator = linkedList.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    Filter filter = (Filter)iterator.next();
                    if (!filter.appliesTo(iFileInfo) || !filter.match(iFileInfo)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    iFileInfoArray2[n++] = iFileInfo;
                }
                ++n2;
            }
            if (n != iFileInfoArray2.length) {
                IFileInfo[] iFileInfoArray3 = new IFileInfo[n];
                System.arraycopy(iFileInfoArray2, 0, iFileInfoArray3, 0, n);
                iFileInfoArray2 = iFileInfoArray3;
            }
            return iFileInfoArray2;
        }
        return iFileInfoArray;
    }
}

