/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FilterDescription
implements Comparable {
    private String id;
    private String arguments;
    private IPath path;
    private int type;
    static /* synthetic */ Class class$0;

    public FilterDescription() {
        this.path = Path.EMPTY;
        this.type = -1;
        this.id = null;
        this.arguments = null;
    }

    public FilterDescription(IResource iResource, int n, String string, String string2) {
        Assert.isNotNull((Object)iResource);
        Assert.isNotNull((Object)string);
        this.type = n;
        this.path = iResource.getProjectRelativePath();
        this.id = string;
        this.arguments = string2;
    }

    public FilterDescription(IPath iPath, int n, String string, String string2) {
        Assert.isNotNull((Object)iPath);
        Assert.isNotNull((Object)string);
        this.type = n;
        this.path = iPath;
        this.id = string;
        this.arguments = string2;
    }

    public boolean equals(Object object) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.FilterDescription");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            return false;
        }
        FilterDescription filterDescription = (FilterDescription)object;
        return this.path.equals((Object)filterDescription.path) && this.type == filterDescription.type && this.id.equals(filterDescription.id) && (this.arguments == null ? this.arguments == filterDescription.arguments : this.arguments.equals(filterDescription.arguments));
    }

    public String getFilterID() {
        return this.id;
    }

    public String getArguments() {
        return this.arguments;
    }

    public IPath getProjectRelativePath() {
        return this.path;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type + this.path.hashCode() + this.id.hashCode();
    }

    public void setFilterID(String string) {
        this.id = string;
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public void setPath(IPath iPath) {
        this.path = iPath;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int compareTo(Object object) {
        FilterDescription filterDescription = (FilterDescription)object;
        IPath iPath = this.getProjectRelativePath();
        IPath iPath2 = filterDescription.getProjectRelativePath();
        int n = iPath.segmentCount();
        int n2 = n - iPath2.segmentCount();
        if (n2 != 0) {
            return n2;
        }
        int n3 = 0;
        while (n3 < n) {
            n2 = iPath.segment(n3).compareTo(iPath2.segment(n3));
            if (n2 != 0) {
                return n2;
            }
            ++n3;
        }
        return 0;
    }

    public boolean isInheritable() {
        return (this.getType() & 0x10) != 0;
    }

    public static LinkedList copy(LinkedList linkedList, IPath iPath) {
        LinkedList<FilterDescription> linkedList2 = new LinkedList<FilterDescription>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            FilterDescription filterDescription = (FilterDescription)iterator.next();
            FilterDescription filterDescription2 = new FilterDescription(iPath, filterDescription.getType(), filterDescription.getFilterID(), filterDescription.getArguments());
            linkedList2.add(filterDescription2);
        }
        return linkedList2;
    }
}

