/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class Folder
extends Container
implements IFolder {
    protected Folder(IPath iPath, Workspace workspace) {
        super(iPath, workspace);
    }

    protected void assertCreateRequirements(IFileStore iFileStore, IFileInfo iFileInfo, int n) throws CoreException {
        boolean bl;
        this.checkDoesNotExist();
        Container container = (Container)this.getParent();
        ResourceInfo resourceInfo = container.getResourceInfo(false, false);
        container.checkAccessible(this.getFlags(resourceInfo));
        this.checkValidGroupContainer(container, false, false);
        boolean bl2 = bl = (n & 1) != 0;
        if (!bl && iFileInfo.exists()) {
            String string;
            if (!Workspace.caseSensitive && (string = this.getLocalManager().getLocalName(iFileStore)) != null && !iFileStore.getName().equals(string)) {
                String string2 = NLS.bind((String)Messages.resources_existsLocalDifferentCase, (Object)new Path(iFileStore.toString()).removeLastSegments(1).append(string).toOSString());
                throw new ResourceException(275, this.getFullPath(), string2, null);
            }
            string = NLS.bind((String)Messages.resources_fileExists, (Object)iFileStore.toString());
            throw new ResourceException(272, this.getFullPath(), string, null);
        }
    }

    public IFile changeToFile() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 2);
        IFile iFile = this.workspace.getRoot().getFile(this.path);
        if (this.isLinked()) {
            URI uRI = this.getRawLocationURI();
            this.delete(0, null);
            iFile.createLink(uRI, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource((IResource)iFile, false);
        }
        return iFile;
    }

    public void create(int n, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl2 = (n & 1) != 0;
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_creating, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            this.checkValidPath(this.path, 2, true);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    IFileStore iFileStore = this.getStore();
                    IFileInfo iFileInfo = iFileStore.fetchInfo();
                    this.assertCreateRequirements(iFileStore, iFileInfo, n);
                    this.workspace.beginOperation(true);
                    if (bl2 && !Workspace.caseSensitive && iFileInfo.exists()) {
                        String string2 = this.getLocalManager().getLocalName(iFileStore);
                        if (string2 == null || iFileInfo.getName().equals(string2)) {
                            this.delete(true, null);
                        } else {
                            String string3 = NLS.bind((String)Messages.resources_existsLocalDifferentCase, (Object)new Path(iFileStore.toString()).removeLastSegments(1).append(string2).toOSString());
                            throw new ResourceException(275, this.getFullPath(), string3, null);
                        }
                    }
                    this.internalCreate(n, bl, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                    this.workspace.getAliasManager().updateAliases(this, this.getStore(), 0, iProgressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void create(boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.create(bl ? 1 : 0, bl2, iProgressMonitor);
    }

    public void createGroup(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.createLink(LinkDescription.GROUP_LOCATION, n, iProgressMonitor);
    }

    public void ensureExists(IProgressMonitor iProgressMonitor) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        if (this.exists(n, true)) {
            return;
        }
        if (this.exists(n, false)) {
            String string = NLS.bind((String)Messages.resources_folderOverFile, (Object)this.getFullPath());
            throw new ResourceException(366, this.getFullPath(), string, null);
        }
        Container container = (Container)this.getParent();
        if (container.getType() == 4) {
            resourceInfo = container.getResourceInfo(false, false);
            container.checkExists(this.getFlags(resourceInfo), true);
        } else {
            ((Folder)container).ensureExists(iProgressMonitor);
        }
        if (this.getType() == 2 && this.isUnderGroup()) {
            this.createGroup(1, iProgressMonitor);
        } else {
            this.internalCreate(1, true, iProgressMonitor);
        }
    }

    public String getDefaultCharset(boolean bl) {
        if (!this.exists()) {
            return bl ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), bl);
    }

    public int getType() {
        return 2;
    }

    public void internalCreate(int n, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_creating, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            this.workspace.createResource((IResource)this, n);
            if (bl) {
                try {
                    boolean bl2 = (n & 1) != 0;
                    this.getLocalManager().write(this, bl2, Policy.subMonitorFor(iProgressMonitor, 100));
                }
                catch (CoreException coreException) {
                    this.workspace.deleteResource(this);
                    throw coreException;
                }
            }
            this.internalSetLocal(bl, 0);
            if (!bl) {
                this.getResourceInfo(true, true).clearModificationStamp();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

