/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class GroupFileStore
extends FileStore {
    private final URI location;

    public GroupFileStore(URI uRI) {
        this.location = uRI;
    }

    public String[] childNames(int n, IProgressMonitor iProgressMonitor) {
        return FileStore.EMPTY_STRING_ARRAY;
    }

    public IFileInfo fetchInfo(int n, IProgressMonitor iProgressMonitor) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDirectory(true);
        fileInfo.setExists(true);
        fileInfo.setLastModified(1L);
        return fileInfo;
    }

    public void delete(int n, IProgressMonitor iProgressMonitor) {
    }

    public IFileStore getChild(String string) {
        return EFS.getNullFileSystem().getStore(new Path(string).makeAbsolute());
    }

    public String getName() {
        return "group";
    }

    public IFileStore getParent() {
        return null;
    }

    public void move(IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iFileStore.mkdir(0, iProgressMonitor);
    }

    public InputStream openInputStream(int n, IProgressMonitor iProgressMonitor) {
        return null;
    }

    public URI toURI() {
        return this.location;
    }
}

