/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class InternalWorkspaceJob
extends Job {
    private Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();

    public InternalWorkspaceJob(String string) {
        super(string);
    }

    public final IStatus run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus;
        block9: {
            iProgressMonitor = Policy.monitorFor(iProgressMonitor);
            int n = -1;
            try {
                this.workspace.prepareOperation(null, iProgressMonitor);
                this.workspace.beginOperation(true);
                n = this.workspace.getWorkManager().beginUnprotected();
                iStatus = this.runInWorkspace(iProgressMonitor);
                if (n < 0) break block9;
                this.workspace.getWorkManager().endUnprotected(n);
            }
            catch (OperationCanceledException operationCanceledException) {
                IStatus iStatus2;
                block10: {
                    try {
                        this.workspace.getWorkManager().operationCanceled();
                        iStatus2 = Status.CANCEL_STATUS;
                        if (n < 0) break block10;
                        this.workspace.getWorkManager().endUnprotected(n);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (n >= 0) {
                                this.workspace.getWorkManager().endUnprotected(n);
                            }
                            this.workspace.endOperation(null, false, iProgressMonitor);
                            throw throwable;
                        }
                        catch (CoreException coreException) {
                            return coreException.getStatus();
                        }
                    }
                }
                this.workspace.endOperation(null, false, iProgressMonitor);
                return iStatus2;
            }
        }
        this.workspace.endOperation(null, false, iProgressMonitor);
        return iStatus;
    }

    protected abstract IStatus runInWorkspace(IProgressMonitor var1) throws CoreException;
}

