/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LinkDescription
implements Comparable {
    public static final URI GROUP_LOCATION = LinkDescription.getGroupLocation();
    private URI localLocation;
    private IPath path;
    private int type;
    static /* synthetic */ Class class$0;

    private static URI getGroupLocation() {
        try {
            return new URI("group:/group");
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public LinkDescription() {
        this.path = Path.EMPTY;
        this.type = -1;
    }

    public LinkDescription(IResource iResource, URI uRI) {
        Assert.isNotNull((Object)iResource);
        Assert.isNotNull((Object)uRI);
        this.type = iResource.getType();
        this.path = iResource.getProjectRelativePath();
        this.localLocation = uRI;
    }

    public boolean equals(Object object) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.LinkDescription");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            return false;
        }
        LinkDescription linkDescription = (LinkDescription)object;
        return this.localLocation.equals(linkDescription.localLocation) && this.path.equals((Object)linkDescription.path) && this.type == linkDescription.type;
    }

    public URI getLocationURI() {
        return this.localLocation;
    }

    public IPath getProjectRelativePath() {
        return this.path;
    }

    public int getType() {
        return this.type;
    }

    public boolean isGroup() {
        return this.localLocation.equals(GROUP_LOCATION);
    }

    public int hashCode() {
        return this.type + this.path.hashCode() + this.localLocation.hashCode();
    }

    public void setLocationURI(URI uRI) {
        this.localLocation = uRI;
    }

    public void setPath(IPath iPath) {
        this.path = iPath;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int compareTo(Object object) {
        LinkDescription linkDescription = (LinkDescription)object;
        IPath iPath = this.getProjectRelativePath();
        IPath iPath2 = linkDescription.getProjectRelativePath();
        int n = iPath.segmentCount();
        int n2 = n - iPath2.segmentCount();
        if (n2 != 0) {
            return n2;
        }
        int n3 = 0;
        while (n3 < n) {
            n2 = iPath.segment(n3).compareTo(iPath2.segment(n3));
            if (n2 != 0) {
                return n2;
            }
            ++n3;
        }
        return 0;
    }
}

