/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspaceDescriptionReader;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LocalMetaArea
implements ICoreConstants {
    static final String F_BACKUP_FILE_EXTENSION = ".bak";
    static final String F_DESCRIPTION = ".workspace";
    static final String F_HISTORY_STORE = ".history";
    static final String F_MARKERS = ".markers";
    static final String F_OLD_PROJECT = ".prj";
    static final String F_PROJECT_LOCATION = ".location";
    static final String F_PROJECTS = ".projects";
    static final String F_PROPERTIES = ".properties";
    static final String F_ROOT = ".root";
    static final String F_SAFE_TABLE = ".safetable";
    static final String F_SNAP = ".snap";
    static final String F_SNAP_EXTENSION = "snap";
    static final String F_SYNCINFO = ".syncinfo";
    static final String F_TREE = ".tree";
    static final String URI_PREFIX = "URI//";
    static final String F_METADATA = ".metadata";
    protected final IPath metaAreaLocation = ResourcesPlugin.getPlugin().getStateLocation();
    protected final IPath projectMetaLocation = this.metaAreaLocation.append(".projects");

    public void clearOldDescription(IProject iProject) {
        Workspace.clear(this.getOldDescriptionLocationFor(iProject).toFile());
    }

    public void create(IProject iProject) {
        File file = this.locationFor(iProject).toFile();
        Workspace.clear(file);
        file.mkdirs();
    }

    public synchronized void createMetaArea() throws CoreException {
        File file = this.metaAreaLocation.toFile();
        Workspace.clear(file);
        if (!file.mkdirs()) {
            String string = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)file);
            throw new ResourceException(568, null, string, null);
        }
    }

    public void delete(IProject iProject) throws CoreException {
        IPath iPath = this.locationFor(iProject);
        if (!Workspace.clear(iPath.toFile()) && iPath.toFile().exists()) {
            String string = NLS.bind((String)Messages.resources_deleteMeta, (Object)iProject.getFullPath());
            throw new ResourceException(569, iProject.getFullPath(), string, null);
        }
    }

    public IPath getBackupLocationFor(IPath iPath) {
        return iPath.removeLastSegments(1).append(String.valueOf(iPath.lastSegment()) + F_BACKUP_FILE_EXTENSION);
    }

    public IPath getHistoryStoreLocation() {
        return this.metaAreaLocation.append(F_HISTORY_STORE);
    }

    public IPath getLocation() {
        return this.metaAreaLocation;
    }

    public IPath getMarkersLocationFor(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        Assert.isLegal((iResource.getType() == 8 || iResource.getType() == 4 ? 1 : 0) != 0);
        return this.locationFor(iResource).append(F_MARKERS);
    }

    public IPath getMarkersSnapshotLocationFor(IResource iResource) {
        return this.getMarkersLocationFor(iResource).addFileExtension(F_SNAP_EXTENSION);
    }

    public IPath getOldDescriptionLocationFor(IProject iProject) {
        return this.locationFor(iProject).append(F_OLD_PROJECT);
    }

    public IPath getOldWorkspaceDescriptionLocation() {
        return this.metaAreaLocation.append(F_DESCRIPTION);
    }

    public IPath getPropertyStoreLocation(IResource iResource) {
        int n = iResource.getType();
        Assert.isTrue((n != 1 && n != 2 ? 1 : 0) != 0);
        return this.locationFor(iResource).append(F_PROPERTIES);
    }

    public IPath getSafeTableLocationFor(String string) {
        IPath iPath = this.metaAreaLocation.append(F_SAFE_TABLE);
        if (string.equals("org.eclipse.core.resources")) {
            return iPath.append(string);
        }
        int n = this.getWorkspace().getSaveManager().getSaveNumber(string);
        return iPath.append(String.valueOf(string) + "." + n);
    }

    public IPath getSnapshotLocationFor(IResource iResource) {
        return this.metaAreaLocation.append(F_SNAP);
    }

    public IPath getSyncInfoLocationFor(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        Assert.isLegal((iResource.getType() == 8 || iResource.getType() == 4 ? 1 : 0) != 0);
        return this.locationFor(iResource).append(F_SYNCINFO);
    }

    public IPath getSyncInfoSnapshotLocationFor(IResource iResource) {
        return this.getSyncInfoLocationFor(iResource).addFileExtension(F_SNAP_EXTENSION);
    }

    public IPath getTreeLocationFor(IResource iResource, boolean bl) {
        IPath iPath = iResource.getFullPath().append(F_TREE);
        String string = this.getWorkspace().getSaveManager().getMasterTable().getProperty(iPath.toString());
        if (string == null) {
            string = "0";
        }
        if (bl) {
            int n = new Integer(string) + 1;
            n = n < 0 ? 1 : n;
            string = new Integer(n).toString();
            this.getWorkspace().getSaveManager().getMasterTable().setProperty(iPath.toString(), new Integer(string).toString());
        }
        return this.locationFor(iResource).append(String.valueOf(string) + F_TREE);
    }

    public IPath getWorkingLocation(IResource iResource, String string) {
        return this.locationFor(iResource).append(string);
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public boolean hasSavedProject(IProject iProject) {
        return this.getOldDescriptionLocationFor(iProject).toFile().exists() || this.locationFor(iProject).append(F_PROJECT_LOCATION).toFile().exists();
    }

    public boolean hasSavedWorkspace() {
        return this.metaAreaLocation.toFile().exists() || this.getBackupLocationFor(this.metaAreaLocation).toFile().exists();
    }

    public IPath locationFor(IPath iPath) {
        if (Path.ROOT.equals((Object)iPath)) {
            return this.metaAreaLocation.append(F_ROOT);
        }
        return this.projectMetaLocation.append(iPath.segment(0));
    }

    public IPath locationFor(IResource iResource) {
        if (iResource.getType() == 8) {
            return this.metaAreaLocation.append(F_ROOT);
        }
        return this.projectMetaLocation.append(iResource.getProject().getName());
    }

    public ProjectDescription readOldDescription(IProject iProject) throws CoreException {
        IPath iPath = this.getOldDescriptionLocationFor(iProject);
        if (!iPath.toFile().exists()) {
            return null;
        }
        IPath iPath2 = this.getBackupLocationFor(iPath);
        ProjectDescription projectDescription = null;
        try {
            projectDescription = new ProjectDescriptionReader(iProject).read(iPath, iPath2);
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_readMeta, (Object)iProject.getName());
            throw new ResourceException(567, iProject.getFullPath(), string, iOException);
        }
        if (projectDescription == null) {
            String string = NLS.bind((String)Messages.resources_readMeta, (Object)iProject.getName());
            throw new ResourceException(567, iProject.getFullPath(), string, null);
        }
        return projectDescription;
    }

    public WorkspaceDescription readOldWorkspace() {
        IPath iPath = this.getOldWorkspaceDescriptionLocation();
        IPath iPath2 = this.getBackupLocationFor(iPath);
        try {
            WorkspaceDescription workspaceDescription = (WorkspaceDescription)new WorkspaceDescriptionReader().read(iPath, iPath2);
            Workspace.clear(iPath.toFile());
            Workspace.clear(iPath2.toFile());
            return workspaceDescription;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void readPrivateDescription(IProject iProject, IProjectDescription iProjectDescription) {
        IPath iPath = this.locationFor(iProject).append(F_PROJECT_LOCATION);
        File file = iPath.toFile();
        if (!file.exists() && !(file = (iPath = this.getBackupLocationFor(iPath)).toFile()).exists()) {
            return;
        }
        try {
            SafeChunkyInputStream safeChunkyInputStream = new SafeChunkyInputStream(file, 500);
            DataInputStream dataInputStream = new DataInputStream(safeChunkyInputStream);
            try {
                IProject[] iProjectArray;
                try {
                    String string = dataInputStream.readUTF();
                    if (string.length() > 0) {
                        if (string.startsWith(URI_PREFIX)) {
                            iProjectDescription.setLocationURI(URI.create(string.substring(URI_PREFIX.length())));
                        } else {
                            iProjectDescription.setLocationURI(URIUtil.toURI((IPath)Path.fromOSString((String)string)));
                        }
                    }
                }
                catch (Exception exception) {
                    iProjectArray = NLS.bind((String)Messages.resources_exReadProjectLocation, (Object)iProject.getName());
                    Policy.log(new ResourceStatus(4, 567, iProject.getFullPath(), (String)iProjectArray, exception));
                }
                int n = dataInputStream.readInt();
                iProjectArray = new IProject[n];
                IWorkspaceRoot iWorkspaceRoot = this.getWorkspace().getRoot();
                int n2 = 0;
                while (n2 < n) {
                    iProjectArray[n2] = iWorkspaceRoot.getProject(dataInputStream.readUTF());
                    ++n2;
                }
                iProjectDescription.setDynamicReferences(iProjectArray);
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized void write(WorkspaceDescription workspaceDescription) throws CoreException {
        IPath iPath = this.getOldWorkspaceDescriptionLocation();
        iPath.toFile().getParentFile().mkdirs();
        IPath iPath2 = this.getBackupLocationFor(iPath);
        try {
            new ModelObjectWriter().write(workspaceDescription, iPath, iPath2);
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)iPath);
            throw new ResourceException(568, null, string, iOException);
        }
    }

    public void writePrivateDescription(IProject iProject) throws CoreException {
        IPath iPath = this.locationFor(iProject).append(F_PROJECT_LOCATION);
        File file = iPath.toFile();
        Workspace.clear(file);
        ProjectDescription projectDescription = ((Project)iProject).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        URI uRI = projectDescription.getLocationURI();
        IProject[] iProjectArray = projectDescription.getDynamicReferences(false);
        int n = iProjectArray.length;
        if (uRI == null && n == 0) {
            return;
        }
        try {
            SafeChunkyOutputStream safeChunkyOutputStream = new SafeChunkyOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(safeChunkyOutputStream);
            try {
                if (uRI == null) {
                    dataOutputStream.writeUTF("");
                } else {
                    dataOutputStream.writeUTF(URI_PREFIX + uRI.toString());
                }
                dataOutputStream.writeInt(n);
                int n2 = 0;
                while (n2 < n) {
                    dataOutputStream.writeUTF(iProjectArray[n2].getName());
                    ++n2;
                }
                safeChunkyOutputStream.succeed();
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_exSaveProjectLocation, (Object)iProject.getName());
            throw new ResourceException(566, null, string, iOException);
        }
    }
}

