/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class LocationValidator {
    private final Workspace workspace;

    public LocationValidator(Workspace workspace) {
        this.workspace = workspace;
    }

    private String toString(URI uRI) {
        try {
            return EFS.getStore((URI)uRI).toString();
        }
        catch (CoreException coreException) {
            return uRI.toString();
        }
    }

    private IStatus validateAbsolute(URI uRI, boolean bl) {
        if (!uRI.isAbsolute()) {
            Path path;
            String string = uRI.getSchemeSpecificPart() == null ? Messages.links_noPath : ((path = new Path(uRI.getSchemeSpecificPart())).segmentCount() > 0 ? NLS.bind((String)Messages.pathvar_undefined, (Object)uRI.toString(), (Object)path.segment(0)) : Messages.links_noPath);
            int n = bl ? 379 : 333;
            return new ResourceStatus(n, null, string);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateLinkLocation(IResource iResource, IPath iPath) {
        IPath iPath2 = iResource.getProject() != null ? iResource.getProject().getPathVariableManager().resolvePath(iPath) : this.workspace.getPathVariableManager().resolvePath(iPath);
        if (iPath2.isEmpty()) {
            return new ResourceStatus(77, iResource.getFullPath(), Messages.links_noPath);
        }
        if (!iPath2.isAbsolute()) {
            String string = NLS.bind((String)Messages.pathvar_undefined, (Object)iPath2.toOSString(), (Object)iPath2.segment(0));
            return new ResourceStatus(333, iResource.getFullPath(), string);
        }
        if (iPath2.getDevice() == null) {
            iPath2 = new Path(iPath2.toFile().getAbsolutePath());
        }
        return this.validateLinkLocationURI(iResource, URIUtil.toURI((IPath)iPath2));
    }

    public IStatus validateLinkLocationURI(IResource iResource, URI uRI) {
        if (uRI.getSchemeSpecificPart() == null) {
            return new ResourceStatus(77, iResource.getFullPath(), Messages.links_noPath);
        }
        if (ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking")) {
            String string = NLS.bind((String)Messages.links_workspaceVeto, (Object)iResource.getName());
            return new ResourceStatus(77, iResource.getFullPath(), string);
        }
        int n = iResource.getType();
        if (n != 2 && n != 1) {
            String string = NLS.bind((String)Messages.links_notFileFolder, (Object)iResource.getName());
            return new ResourceStatus(77, iResource.getFullPath(), string);
        }
        IContainer iContainer = iResource.getParent();
        if (!iContainer.isAccessible()) {
            String string = NLS.bind((String)Messages.links_parentNotAccessible, (Object)iResource.getFullPath());
            return new ResourceStatus(77, iResource.getFullPath(), string);
        }
        URI uRI2 = iResource.getProject() != null ? iResource.getProject().getPathVariableManager().resolveURI(uRI) : this.workspace.getPathVariableManager().resolveURI(uRI);
        String[] stringArray = ((Project)iResource.getProject()).internalGetDescription().getNatureIds();
        IStatus iStatus = this.workspace.getNatureManager().validateLinkCreation(stringArray);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        iStatus = iResource.getType() == 1 ? this.workspace.getTeamHook().validateCreateLink((IFile)iResource, 0, uRI2) : this.workspace.getTeamHook().validateCreateLink((IFolder)iResource, 0, uRI2);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        iStatus = this.validateSegments(uRI2);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        iStatus = this.validateAbsolute(uRI2, false);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        URI uRI3 = this.workspace.getMetaArea().getLocation().toFile().toURI();
        if (FileUtil.isOverlapping(uRI2, uRI3)) {
            String string = NLS.bind((String)Messages.links_invalidLocation, (Object)this.toString(uRI2));
            return new ResourceStatus(77, iResource.getFullPath(), string);
        }
        uRI3 = iResource.getProject().getLocationURI();
        if (uRI3 != null && FileUtil.isPrefixOf(uRI2, uRI3)) {
            String string = NLS.bind((String)Messages.links_locationOverlapsProject, (Object)this.toString(uRI2));
            return new ResourceStatus(77, iResource.getFullPath(), string);
        }
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            IProject iProject = iProjectArray[n2];
            ProjectDescription projectDescription = ((Project)iProject).internalGetDescription();
            uRI3 = projectDescription.getLocationURI();
            if (uRI3 != null && FileUtil.isOverlapping(uRI2, uRI3)) {
                String string = NLS.bind((String)Messages.links_overlappingResource, (Object)this.toString(uRI2));
                return new ResourceStatus(235, iResource.getFullPath(), string);
            }
            if (iProject.isOpen()) {
                IResource[] iResourceArray = null;
                try {
                    iResourceArray = iProject.members();
                }
                catch (CoreException coreException) {}
                if (iResourceArray != null) {
                    int n3 = 0;
                    while (n3 < iResourceArray.length) {
                        if (iResourceArray[n3].isLinked() && (uRI3 = iResourceArray[n3].getLocationURI()) != null && FileUtil.isOverlapping(uRI2, uRI3)) {
                            String string = NLS.bind((String)Messages.links_overlappingResource, (Object)this.toString(uRI2));
                            return new ResourceStatus(235, iResource.getFullPath(), string);
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateName(String string, int n) {
        if (string == null) {
            String string2 = Messages.resources_nameNull;
            return new ResourceStatus(77, null, string2);
        }
        if (string.length() == 0) {
            String string3 = Messages.resources_nameEmpty;
            return new ResourceStatus(77, null, string3);
        }
        char[] cArray = OS.INVALID_RESOURCE_CHARACTERS;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (string.indexOf(cArray[n2]) != -1) {
                String string4 = NLS.bind((String)Messages.resources_invalidCharInName, (Object)String.valueOf(cArray[n2]), (Object)string);
                return new ResourceStatus(77, null, string4);
            }
            ++n2;
        }
        if (!OS.isNameValid(string)) {
            String string5 = NLS.bind((String)Messages.resources_invalidName, (Object)string);
            return new ResourceStatus(77, null, string5);
        }
        return Status.OK_STATUS;
    }

    public IStatus validatePath(IPath iPath, int n, boolean bl) {
        if (iPath == null) {
            String string = Messages.resources_pathNull;
            return new ResourceStatus(77, null, string);
        }
        if (iPath.getDevice() != null) {
            String string = NLS.bind((String)Messages.resources_invalidCharInPath, (Object)String.valueOf(':'), (Object)iPath);
            return new ResourceStatus(77, null, string);
        }
        if (iPath.isRoot()) {
            String string = Messages.resources_invalidRoot;
            return new ResourceStatus(77, null, string);
        }
        if (!iPath.isAbsolute()) {
            String string = NLS.bind((String)Messages.resources_mustBeAbsolute, (Object)iPath);
            return new ResourceStatus(77, null, string);
        }
        int n2 = iPath.segmentCount();
        if ((n & 4) != 0) {
            if (n2 == 1) {
                return this.validateName(iPath.segment(0), 4);
            }
            if (n == 4) {
                String string = NLS.bind((String)Messages.resources_projectPath, (Object)iPath);
                return new ResourceStatus(77, null, string);
            }
        }
        if ((n & 3) != 0) {
            if (n2 < 2) {
                String string = NLS.bind((String)Messages.resources_resourcePath, (Object)iPath);
                return new ResourceStatus(77, null, string);
            }
            int n3 = n &= 0xFFFFFFFB;
            int n4 = iPath.segmentCount();
            if (bl) {
                return this.validateName(iPath.segment(n4 - 1), n3);
            }
            IStatus iStatus = this.validateName(iPath.segment(0), 4);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            int n5 = 1;
            while (n5 < n4) {
                iStatus = this.validateName(iPath.segment(n5), n3);
                if (!iStatus.isOK()) {
                    return iStatus;
                }
                ++n5;
            }
            return Status.OK_STATUS;
        }
        String string = NLS.bind((String)Messages.resources_invalidPath, (Object)iPath);
        return new ResourceStatus(77, null, string);
    }

    public IStatus validatePath(String string, int n) {
        if (string == null) {
            String string2 = Messages.resources_pathNull;
            return new ResourceStatus(77, null, string2);
        }
        return this.validatePath(Path.fromOSString((String)string), n, false);
    }

    public IStatus validateProjectLocation(IProject iProject, IPath iPath) {
        if (iPath == null) {
            return this.validateProjectLocationURI(iProject, null);
        }
        IPath iPath2 = iProject != null ? iProject.getPathVariableManager().resolvePath(iPath) : this.workspace.getPathVariableManager().resolvePath(iPath);
        if (!iPath2.isAbsolute()) {
            String string = iPath2.segmentCount() > 0 ? NLS.bind((String)Messages.pathvar_undefined, (Object)iPath2.toString(), (Object)iPath2.segment(0)) : Messages.links_noPath;
            return new ResourceStatus(379, null, string);
        }
        return this.validateProjectLocationURI(iProject, URIUtil.toURI((IPath)iPath2));
    }

    public IStatus validateProjectLocationURI(IProject iProject, URI uRI) {
        Object object;
        Object object2;
        IProject[] iProjectArray;
        if (iProject == null && uRI == null) {
            throw new IllegalArgumentException("Either a project or a location must be provided");
        }
        boolean bl = false;
        if (uRI != null) {
            if (URIUtil.equals((URI)uRI, (URI)URIUtil.toURI((IPath)Platform.getLocation().addTrailingSeparator().append(".metadata")))) {
                bl = true;
            }
        } else if (iProject != null && iProject.getName().equals(".metadata")) {
            bl = true;
        }
        if (bl) {
            String string = NLS.bind((String)Messages.resources_invalidPath, (Object)this.toString(URIUtil.toURI((IPath)Platform.getLocation().addTrailingSeparator().append(".metadata"))));
            return new ResourceStatus(77, null, string);
        }
        if (uRI == null) {
            return Status.OK_STATUS;
        }
        URI uRI2 = iProject != null ? iProject.getPathVariableManager().resolveURI(uRI) : this.workspace.getPathVariableManager().resolveURI(uRI);
        IStatus iStatus = this.validateSegments(uRI2);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        iStatus = this.validateAbsolute(uRI2, true);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        try {
            EFS.getFileSystem((String)uRI2.getScheme());
        }
        catch (CoreException coreException) {
            return coreException.getStatus();
        }
        if (uRI2.getScheme().equals("file")) {
            IPath iPath;
            iProjectArray = URIUtil.toPath((URI)uRI2);
            if (FileUtil.isPrefixOf((IPath)iProjectArray, iPath = this.workspace.getRoot().getLocation())) {
                String string = NLS.bind((String)Messages.resources_overlapWorkspace, (Object)this.toString(uRI2), (Object)iPath.toOSString());
                return new ResourceStatus(77, null, string);
            }
            object2 = iProjectArray.removeLastSegments(1);
            if (FileUtil.isPrefixOf((IPath)object2, iPath) && FileUtil.isPrefixOf(iPath, (IPath)object2)) {
                String string = NLS.bind((String)Messages.resources_overlapProject, (Object)this.toString(uRI2), (Object)iProjectArray.lastSegment());
                return new ResourceStatus(77, null, string);
            }
        }
        iProjectArray = this.workspace.getRoot().getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            object2 = iProjectArray[n];
            object = ((Project)object2).internalGetDescription();
            URI uRI3 = object.getLocationURI();
            if (uRI3 != null && !(iProject != null && object2.equals(iProject) ? URIUtil.equals((URI)uRI3, (URI)uRI2) || !FileUtil.isPrefixOf(uRI3, uRI2) : !URIUtil.equals((URI)uRI3, (URI)uRI2))) {
                String string = NLS.bind((String)Messages.resources_overlapProject, (Object)this.toString(uRI2), (Object)object2.getName());
                return new ResourceStatus(77, null, string);
            }
            ++n;
        }
        if (iProject != null && iProject.exists() && iProject.isOpen()) {
            IResource[] iResourceArray = null;
            try {
                iResourceArray = iProject.members();
            }
            catch (CoreException coreException) {}
            if (iResourceArray != null) {
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    if (iResourceArray[n2].isLinked() && (object = iResourceArray[n2].getLocationURI()) != null && FileUtil.isPrefixOf((URI)object, uRI2)) {
                        String string = NLS.bind((String)Messages.links_locationOverlapsLink, (Object)this.toString(uRI2));
                        return new ResourceStatus(235, iProject.getFullPath(), string);
                    }
                    ++n2;
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus validateSegments(URI uRI) {
        if ("file".equals(uRI.getScheme())) {
            Path path = new Path(uRI.getSchemeSpecificPart());
            int n = path.segmentCount();
            int n2 = 0;
            while (n2 < n) {
                IStatus iStatus = this.validateName(path.segment(n2), 4);
                if (!iStatus.isOK()) {
                    return iStatus;
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }
}

