/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Map;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class Marker
extends PlatformObject
implements IMarker {
    protected long id;
    protected IResource resource;

    Marker(IResource iResource, long l) {
        Assert.isLegal((iResource != null ? 1 : 0) != 0);
        this.resource = iResource;
        this.id = l;
    }

    private void checkInfo(MarkerInfo markerInfo) throws CoreException {
        if (markerInfo == null) {
            String string = NLS.bind((String)Messages.resources_markerNotFound, (Object)Long.toString(this.id));
            throw new ResourceException(new ResourceStatus(376, this.resource.getFullPath(), string));
        }
    }

    public void delete() throws CoreException {
        ISchedulingRule iSchedulingRule = this.getWorkspace().getRuleFactory().markerRule(this.resource);
        try {
            this.getWorkspace().prepareOperation(iSchedulingRule, null);
            this.getWorkspace().beginOperation(true);
            this.getWorkspace().getMarkerManager().removeMarker(this.getResource(), this.getId());
        }
        finally {
            this.getWorkspace().endOperation(iSchedulingRule, false, null);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof IMarker)) {
            return false;
        }
        IMarker iMarker = (IMarker)object;
        return this.id == iMarker.getId() && this.resource.equals(iMarker.getResource());
    }

    public boolean exists() {
        return this.getInfo() != null;
    }

    public Object getAttribute(String string) throws CoreException {
        Assert.isNotNull((Object)string);
        MarkerInfo markerInfo = this.getInfo();
        this.checkInfo(markerInfo);
        return markerInfo.getAttribute(string);
    }

    public int getAttribute(String string, int n) {
        Assert.isNotNull((Object)string);
        MarkerInfo markerInfo = this.getInfo();
        if (markerInfo == null) {
            return n;
        }
        Object object = markerInfo.getAttribute(string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    public String getAttribute(String string, String string2) {
        Assert.isNotNull((Object)string);
        MarkerInfo markerInfo = this.getInfo();
        if (markerInfo == null) {
            return string2;
        }
        Object object = markerInfo.getAttribute(string);
        if (object instanceof String) {
            return (String)object;
        }
        return string2;
    }

    public boolean getAttribute(String string, boolean bl) {
        Assert.isNotNull((Object)string);
        MarkerInfo markerInfo = this.getInfo();
        if (markerInfo == null) {
            return bl;
        }
        Object object = markerInfo.getAttribute(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public Map getAttributes() throws CoreException {
        MarkerInfo markerInfo = this.getInfo();
        this.checkInfo(markerInfo);
        return markerInfo.getAttributes();
    }

    public Object[] getAttributes(String[] stringArray) throws CoreException {
        Assert.isNotNull((Object)stringArray);
        MarkerInfo markerInfo = this.getInfo();
        this.checkInfo(markerInfo);
        return markerInfo.getAttributes(stringArray);
    }

    public long getCreationTime() throws CoreException {
        MarkerInfo markerInfo = this.getInfo();
        this.checkInfo(markerInfo);
        return markerInfo.getCreationTime();
    }

    public long getId() {
        return this.id;
    }

    protected MarkerInfo getInfo() {
        return this.getWorkspace().getMarkerManager().findMarkerInfo(this.resource, this.id);
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getType() throws CoreException {
        MarkerInfo markerInfo = this.getInfo();
        this.checkInfo(markerInfo);
        return markerInfo.getType();
    }

    private Workspace getWorkspace() {
        return this.resource == null ? null : (Workspace)this.resource.getWorkspace();
    }

    public int hashCode() {
        return (int)this.id + this.resource.hashCode();
    }

    public boolean isSubtypeOf(String string) throws CoreException {
        return this.getWorkspace().getMarkerManager().isSubtype(this.getType(), string);
    }

    public void setAttribute(String string, int n) throws CoreException {
        this.setAttribute(string, new Integer(n));
    }

    public void setAttribute(String string, Object object) throws CoreException {
        Assert.isNotNull((Object)string);
        Workspace workspace = this.getWorkspace();
        MarkerManager markerManager = workspace.getMarkerManager();
        try {
            workspace.prepareOperation(null, null);
            workspace.beginOperation(true);
            MarkerInfo markerInfo = this.getInfo();
            this.checkInfo(markerInfo);
            boolean bl = !markerManager.hasDelta(this.resource.getFullPath(), this.id);
            MarkerInfo markerInfo2 = bl ? (MarkerInfo)markerInfo.clone() : null;
            markerInfo.setAttribute(string, object);
            if (markerManager.isPersistent(markerInfo)) {
                ((Resource)this.resource).getResourceInfo(false, true).set(4096);
            }
            if (bl) {
                MarkerDelta markerDelta = new MarkerDelta(4, this.resource, markerInfo2);
                markerManager.changedMarkers(this.resource, new MarkerDelta[]{markerDelta});
            }
        }
        finally {
            workspace.endOperation(null, false, null);
        }
    }

    public void setAttribute(String string, boolean bl) throws CoreException {
        this.setAttribute(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray) throws CoreException {
        Assert.isNotNull((Object)stringArray);
        Assert.isNotNull((Object)objectArray);
        Workspace workspace = this.getWorkspace();
        MarkerManager markerManager = workspace.getMarkerManager();
        try {
            workspace.prepareOperation(null, null);
            workspace.beginOperation(true);
            MarkerInfo markerInfo = this.getInfo();
            this.checkInfo(markerInfo);
            boolean bl = !markerManager.hasDelta(this.resource.getFullPath(), this.id);
            MarkerInfo markerInfo2 = bl ? (MarkerInfo)markerInfo.clone() : null;
            markerInfo.setAttributes(stringArray, objectArray);
            if (markerManager.isPersistent(markerInfo)) {
                ((Resource)this.resource).getResourceInfo(false, true).set(4096);
            }
            if (bl) {
                MarkerDelta markerDelta = new MarkerDelta(4, this.resource, markerInfo2);
                markerManager.changedMarkers(this.resource, new MarkerDelta[]{markerDelta});
            }
        }
        finally {
            workspace.endOperation(null, false, null);
        }
    }

    public void setAttributes(Map map) throws CoreException {
        Workspace workspace = this.getWorkspace();
        MarkerManager markerManager = workspace.getMarkerManager();
        try {
            workspace.prepareOperation(null, null);
            workspace.beginOperation(true);
            MarkerInfo markerInfo = this.getInfo();
            this.checkInfo(markerInfo);
            boolean bl = !markerManager.hasDelta(this.resource.getFullPath(), this.id);
            MarkerInfo markerInfo2 = bl ? (MarkerInfo)markerInfo.clone() : null;
            markerInfo.setAttributes(map);
            if (markerManager.isPersistent(markerInfo)) {
                ((Resource)this.resource).getResourceInfo(false, true).set(4096);
            }
            if (bl) {
                MarkerDelta markerDelta = new MarkerDelta(4, this.resource, markerInfo2);
                markerManager.changedMarkers(this.resource, new MarkerDelta[]{markerDelta});
            }
        }
        finally {
            workspace.endOperation(null, false, null);
        }
    }
}

