/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.MarkerDelta;

class MarkerDeltaManager {
    private static final int DEFAULT_SIZE = 10;
    private long[] startIds = new long[10];
    private Map[] batches = new Map[10];
    private int nextFree = 0;

    MarkerDeltaManager() {
    }

    protected Map assembleDeltas(long l) {
        Map map = null;
        int n = 0;
        while (n < this.nextFree) {
            if (this.startIds[n] >= l) {
                map = MarkerDelta.merge(map, this.batches[n]);
            }
            ++n;
        }
        return map;
    }

    protected void resetDeltas(long l) {
        int n = 0;
        while (n < this.nextFree) {
            if (this.startIds[n] >= l) break;
            ++n;
        }
        if (n == 0) {
            return;
        }
        long[] lArray = this.startIds;
        Map[] mapArray = this.batches;
        if (this.startIds.length > 10 && this.nextFree - n < 10) {
            lArray = new long[10];
            mapArray = new Map[10];
        }
        int n2 = this.nextFree - n;
        System.arraycopy(this.startIds, n, lArray, 0, n2);
        System.arraycopy(this.batches, n, mapArray, 0, n2);
        Arrays.fill(this.startIds, n2, this.startIds.length, 0L);
        Arrays.fill(this.batches, n2, this.startIds.length, null);
        this.startIds = lArray;
        this.batches = mapArray;
        this.nextFree = n2;
    }

    protected Map newGeneration(long l) {
        int n = this.startIds.length;
        if (this.nextFree >= n) {
            long[] lArray = new long[n * 2];
            Map[] mapArray = new Map[n * 2];
            System.arraycopy(this.startIds, 0, lArray, 0, n);
            System.arraycopy(this.batches, 0, mapArray, 0, n);
            this.startIds = lArray;
            this.batches = mapArray;
        }
        this.startIds[this.nextFree] = l;
        this.batches[this.nextFree] = new HashMap(11);
        return this.batches[this.nextFree++];
    }
}

