/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerAttributeMap;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class MarkerInfo
implements IMarkerSetElement,
Cloneable,
IStringPoolParticipant {
    protected static final Integer INTEGER_ONE = new Integer(1);
    protected static final Integer INTEGER_TWO = new Integer(2);
    protected static final Integer INTEGER_ZERO = new Integer(0);
    protected static final long UNDEFINED_ID = -1L;
    protected Map attributes = null;
    protected long creationTime = 0L;
    protected long id = -1L;
    protected String type = null;

    protected static Object checkValidAttribute(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            byte[] byArray;
            String string = (String)object;
            if (string.length() < 21000) {
                return object;
            }
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return object;
            }
            if (byArray.length > 65535) {
                String string2 = "Marker property value is too long: " + string.substring(0, 10000);
                Assert.isTrue((boolean)false, (String)string2);
            }
            return object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object instanceof Integer) {
            switch ((Integer)object) {
                case 0: {
                    return INTEGER_ZERO;
                }
                case 1: {
                    return INTEGER_ONE;
                }
                case 2: {
                    return INTEGER_TWO;
                }
            }
            return object;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.resources_wrongMarkerAttributeValueType, (Object)object.getClass().getName()));
    }

    public Object clone() {
        try {
            MarkerInfo markerInfo = (MarkerInfo)super.clone();
            markerInfo.attributes = this.getAttributes(true);
            return markerInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object getAttribute(String string) {
        return this.attributes == null ? null : this.attributes.get(string);
    }

    public Map getAttributes() {
        return this.getAttributes(true);
    }

    public Map getAttributes(boolean bl) {
        if (this.attributes == null) {
            return null;
        }
        return bl ? new MarkerAttributeMap(this.attributes) : this.attributes;
    }

    public Object[] getAttributes(String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            objectArray[n] = this.getAttribute(stringArray[n]);
            ++n;
        }
        return objectArray;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void internalSetAttributes(Map map) {
        this.attributes = map;
    }

    public void setAttribute(String string, Object object) {
        object = MarkerInfo.checkValidAttribute(object);
        if (this.attributes == null) {
            if (object == null) {
                return;
            }
            this.attributes = new MarkerAttributeMap();
            this.attributes.put(string, object);
        } else if (object == null) {
            this.attributes.remove(string);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(string, object);
        }
    }

    public void setAttributes(Map map) {
        if (map == null) {
            this.attributes = null;
        } else {
            this.attributes = new MarkerAttributeMap(map.size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Assert.isTrue((boolean)(k instanceof String));
                Object v = map.get(k);
                this.setAttribute((String)k, MarkerInfo.checkValidAttribute(v));
            }
        }
    }

    public void setAttributes(String[] stringArray, Object[] objectArray) {
        Assert.isTrue((stringArray.length == objectArray.length ? 1 : 0) != 0);
        int n = 0;
        while (n < stringArray.length) {
            this.setAttribute(stringArray[n], objectArray[n]);
            ++n;
        }
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void shareStrings(StringPool stringPool) {
        this.type = stringPool.add(this.type);
        Map map = this.attributes;
        if (map instanceof IStringPoolParticipant) {
            ((IStringPoolParticipant)((Object)map)).shareStrings(stringPool);
        }
    }
}

