/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.MarkerDeltaManager;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.MarkerReader;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.MarkerSnapshotReader;
import org.eclipse.core.internal.resources.MarkerTypeDefinitionCache;
import org.eclipse.core.internal.resources.MarkerWriter;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class MarkerManager
implements IManager {
    private static final MarkerInfo[] NO_MARKER_INFO = new MarkerInfo[0];
    private static final IMarker[] NO_MARKERS = new IMarker[0];
    protected MarkerTypeDefinitionCache cache = new MarkerTypeDefinitionCache();
    private long changeId = 0L;
    protected Map currentDeltas = null;
    protected final MarkerDeltaManager deltaManager = new MarkerDeltaManager();
    protected Workspace workspace;
    protected MarkerWriter writer = new MarkerWriter(this);

    public MarkerManager(Workspace workspace) {
        this.workspace = workspace;
    }

    public void add(IResource iResource, MarkerInfo markerInfo) throws CoreException {
        MarkerSet markerSet;
        Resource resource = (Resource)iResource;
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(resource.getFullPath(), false, false);
        resource.checkExists(resource.getFlags(resourceInfo), false);
        resourceInfo = this.workspace.getResourceInfo(iResource.getFullPath(), false, true);
        if (resourceInfo == null) {
            return;
        }
        if (this.isPersistent(markerInfo)) {
            resourceInfo.set(4096);
        }
        if ((markerSet = resourceInfo.getMarkers(true)) == null) {
            markerSet = new MarkerSet(1);
        }
        this.basicAdd(iResource, markerSet, markerInfo);
        if (!markerSet.isEmpty()) {
            resourceInfo.setMarkers(markerSet);
        }
    }

    private void basicAdd(IResource iResource, MarkerSet markerSet, MarkerInfo markerInfo) throws CoreException {
        if (markerInfo.getId() != -1L) {
            String string = Messages.resources_changeInAdd;
            throw new ResourceException(new ResourceStatus(566, iResource.getFullPath(), string));
        }
        markerInfo.setId(this.workspace.nextMarkerId());
        markerSet.add(markerInfo);
        IMarkerSetElement[] iMarkerSetElementArray = new IMarkerSetElement[]{new MarkerDelta(1, iResource, markerInfo)};
        this.changedMarkers(iResource, iMarkerSetElementArray);
    }

    protected MarkerInfo[] basicFindMatching(MarkerSet markerSet, String string, boolean bl) {
        int n = markerSet.size();
        if (n <= 0) {
            return NO_MARKER_INFO;
        }
        ArrayList<MarkerInfo> arrayList = new ArrayList<MarkerInfo>(n);
        IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
        int n2 = 0;
        while (n2 < iMarkerSetElementArray.length) {
            MarkerInfo markerInfo = (MarkerInfo)iMarkerSetElementArray[n2];
            if (string == null) {
                arrayList.add(markerInfo);
            } else if (bl) {
                if (this.cache.isSubtype(markerInfo.getType(), string)) {
                    arrayList.add(markerInfo);
                }
            } else if (markerInfo.getType().equals(string)) {
                arrayList.add(markerInfo);
            }
            ++n2;
        }
        n = arrayList.size();
        if (n <= 0) {
            return NO_MARKER_INFO;
        }
        return arrayList.toArray(new MarkerInfo[n]);
    }

    protected int basicFindMaxSeverity(MarkerSet markerSet, String string, boolean bl) {
        int n = -1;
        int n2 = markerSet.size();
        if (n2 <= 0) {
            return n;
        }
        IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
        int n3 = 0;
        while (n3 < iMarkerSetElementArray.length) {
            MarkerInfo markerInfo = (MarkerInfo)iMarkerSetElementArray[n3];
            if (string == null) {
                n = Math.max(n, this.getSeverity(markerInfo));
            } else if (bl) {
                if (this.cache.isSubtype(markerInfo.getType(), string)) {
                    n = Math.max(n, this.getSeverity(markerInfo));
                }
            } else if (markerInfo.getType().equals(string)) {
                n = Math.max(n, this.getSeverity(markerInfo));
            }
            if (n >= 2) break;
            ++n3;
        }
        return n;
    }

    private int getSeverity(MarkerInfo markerInfo) {
        Object object = markerInfo.getAttribute("severity");
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n;
        }
        return -1;
    }

    protected void basicRemoveMarkers(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, String string, boolean bl) {
        IMarkerSetElement[] iMarkerSetElementArray;
        IPath iPath;
        MarkerSet markerSet = resourceInfo.getMarkers(false);
        if (markerSet == null) {
            return;
        }
        if (string == null) {
            iPath = iPathRequestor.requestPath();
            resourceInfo = this.workspace.getResourceInfo(iPath, false, true);
            resourceInfo.setMarkers(null);
            iMarkerSetElementArray = markerSet.elements();
        } else {
            iMarkerSetElementArray = this.basicFindMatching(markerSet, string, bl);
            if (iMarkerSetElementArray.length == 0) {
                return;
            }
            iPath = iPathRequestor.requestPath();
            resourceInfo = this.workspace.getResourceInfo(iPath, false, true);
            markerSet = resourceInfo.getMarkers(true);
            markerSet.removeAll(iMarkerSetElementArray);
            resourceInfo.setMarkers(markerSet.size() == 0 ? null : markerSet);
        }
        resourceInfo.set(4096);
        IMarkerSetElement[] iMarkerSetElementArray2 = new IMarkerSetElement[iMarkerSetElementArray.length];
        IResource iResource = this.workspace.getRoot().findMember(iPath);
        int n = 0;
        while (n < iMarkerSetElementArray.length) {
            iMarkerSetElementArray2[n] = new MarkerDelta(2, iResource, (MarkerInfo)iMarkerSetElementArray[n]);
            ++n;
        }
        this.changedMarkers(iResource, iMarkerSetElementArray2);
    }

    protected void buildMarkers(IMarkerSetElement[] iMarkerSetElementArray, IPath iPath, int n, ArrayList arrayList) {
        if (iMarkerSetElementArray.length == 0) {
            return;
        }
        Resource resource = this.workspace.newResource(iPath, n);
        arrayList.ensureCapacity(arrayList.size() + iMarkerSetElementArray.length);
        int n2 = 0;
        while (n2 < iMarkerSetElementArray.length) {
            arrayList.add(new Marker(resource, ((MarkerInfo)iMarkerSetElementArray[n2]).getId()));
            ++n2;
        }
    }

    protected void changedMarkers(IResource iResource, IMarkerSetElement[] iMarkerSetElementArray) {
        IPath iPath;
        MarkerSet markerSet;
        MarkerSet markerSet2;
        if (iMarkerSetElementArray == null || iMarkerSetElementArray.length == 0) {
            return;
        }
        ++this.changeId;
        if (this.currentDeltas == null) {
            this.currentDeltas = this.deltaManager.newGeneration(this.changeId);
        }
        if ((markerSet2 = MarkerDelta.merge(markerSet = (MarkerSet)this.currentDeltas.get(iPath = iResource.getFullPath()), iMarkerSetElementArray)).size() == 0) {
            this.currentDeltas.remove(iPath);
        } else {
            this.currentDeltas.put(iPath, markerSet2);
        }
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, false, true);
        if (resourceInfo != null) {
            resourceInfo.incrementMarkerGenerationCount();
        }
    }

    public IMarker findMarker(IResource iResource, long l) {
        MarkerInfo markerInfo = this.findMarkerInfo(iResource, l);
        return markerInfo == null ? null : new Marker(iResource, markerInfo.getId());
    }

    public MarkerInfo findMarkerInfo(IResource iResource, long l) {
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iResource.getFullPath(), false, false);
        if (resourceInfo == null) {
            return null;
        }
        MarkerSet markerSet = resourceInfo.getMarkers(false);
        if (markerSet == null) {
            return null;
        }
        return (MarkerInfo)markerSet.get(l);
    }

    public IMarker[] findMarkers(IResource iResource, String string, boolean bl, int n) {
        ArrayList arrayList = new ArrayList();
        this.doFindMarkers(iResource, arrayList, string, bl, n);
        if (arrayList.size() == 0) {
            return NO_MARKERS;
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    public void doFindMarkers(IResource iResource, ArrayList arrayList, String string, boolean bl, int n) {
        if (n == 2 && iResource.getType() != 1) {
            this.visitorFindMarkers(iResource.getFullPath(), arrayList, string, bl);
        } else {
            this.recursiveFindMarkers(iResource.getFullPath(), arrayList, string, bl, n);
        }
    }

    public int findMaxProblemSeverity(IResource iResource, String string, boolean bl, int n) {
        if (n == 2 && iResource.getType() != 1) {
            return this.visitorFindMaxSeverity(iResource.getFullPath(), string, bl);
        }
        return this.recursiveFindMaxSeverity(iResource.getFullPath(), string, bl, n);
    }

    public long getChangeId() {
        return this.changeId;
    }

    public Map getMarkerDeltas(long l) {
        return this.deltaManager.assembleDeltas(l);
    }

    boolean hasDelta(IPath iPath, long l) {
        if (this.currentDeltas == null) {
            return false;
        }
        MarkerSet markerSet = (MarkerSet)this.currentDeltas.get(iPath);
        if (markerSet == null) {
            return false;
        }
        return markerSet.get(l) != null;
    }

    public boolean isPersistent(MarkerInfo markerInfo) {
        if (!this.cache.isPersistent(markerInfo.getType())) {
            return false;
        }
        Object object = markerInfo.getAttribute("transient");
        return object == null || !(object instanceof Boolean) || (Boolean)object == false;
    }

    public boolean isSubtype(String string, String string2) {
        return this.cache.isSubtype(string, string2);
    }

    public void moved(final IResource iResource, IResource iResource2, int n) throws CoreException {
        final int n2 = iResource2.getFullPath().segmentCount();
        IResourceVisitor iResourceVisitor = new IResourceVisitor(){

            public boolean visit(IResource iResource2) {
                Resource resource = (Resource)iResource2;
                ResourceInfo resourceInfo = resource.getResourceInfo(false, true);
                MarkerSet markerSet = resourceInfo.getMarkers(false);
                if (markerSet == null) {
                    return true;
                }
                resourceInfo.set(4096);
                IMarkerSetElement[] iMarkerSetElementArray = new IMarkerSetElement[markerSet.size()];
                IMarkerSetElement[] iMarkerSetElementArray2 = new IMarkerSetElement[markerSet.size()];
                IPath iPath = iResource2.getFullPath().removeFirstSegments(n2);
                iPath = iResource.getFullPath().append(iPath);
                Resource resource2 = MarkerManager.this.workspace.newResource(iPath, iResource2.getType());
                IMarkerSetElement[] iMarkerSetElementArray3 = markerSet.elements();
                int n = 0;
                while (n < iMarkerSetElementArray3.length) {
                    MarkerInfo markerInfo = (MarkerInfo)iMarkerSetElementArray3[n];
                    MarkerDelta markerDelta = new MarkerDelta(1, iResource2, markerInfo);
                    iMarkerSetElementArray2[n] = markerDelta;
                    markerDelta = new MarkerDelta(2, resource2, markerInfo);
                    iMarkerSetElementArray[n] = markerDelta;
                    ++n;
                }
                MarkerManager.this.changedMarkers(iResource2, iMarkerSetElementArray2);
                MarkerManager.this.changedMarkers(resource2, iMarkerSetElementArray);
                return true;
            }
        };
        iResource2.accept(iResourceVisitor, n, 10);
    }

    private void recursiveFindMarkers(IPath iPath, ArrayList arrayList, String string, boolean bl, int n) {
        IMarkerSetElement[] iMarkerSetElementArray;
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, false, false);
        if (resourceInfo == null) {
            return;
        }
        MarkerSet markerSet = resourceInfo.getMarkers(false);
        if (markerSet != null) {
            iMarkerSetElementArray = string == null ? markerSet.elements() : this.basicFindMatching(markerSet, string, bl);
            this.buildMarkers(iMarkerSetElementArray, iPath, resourceInfo.getType(), arrayList);
        }
        if (n == 0 || resourceInfo.getType() == 1) {
            return;
        }
        if (n == 1) {
            n = 0;
        }
        iMarkerSetElementArray = this.workspace.getElementTree().getChildren(iPath);
        int n2 = 0;
        while (n2 < iMarkerSetElementArray.length) {
            this.recursiveFindMarkers((IPath)iMarkerSetElementArray[n2], arrayList, string, bl, n);
            ++n2;
        }
    }

    private int recursiveFindMaxSeverity(IPath iPath, String string, boolean bl, int n) {
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, false, false);
        if (resourceInfo == null) {
            return -1;
        }
        MarkerSet markerSet = resourceInfo.getMarkers(false);
        int n2 = -1;
        if (markerSet != null && (n2 = this.basicFindMaxSeverity(markerSet, string, bl)) >= 2) {
            return n2;
        }
        if (n == 0 || resourceInfo.getType() == 1) {
            return n2;
        }
        if (n == 1) {
            n = 0;
        }
        IPath[] iPathArray = this.workspace.getElementTree().getChildren(iPath);
        int n3 = 0;
        while (n3 < iPathArray.length) {
            if ((n2 = Math.max(n2, this.recursiveFindMaxSeverity(iPathArray[n3], string, bl, n))) >= 2) break;
            ++n3;
        }
        return n2;
    }

    private void recursiveRemoveMarkers(final IPath iPath, String string, boolean bl, int n) {
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, false, false);
        if (resourceInfo == null) {
            return;
        }
        IPathRequestor iPathRequestor = new IPathRequestor(){

            public String requestName() {
                return iPath.lastSegment();
            }

            public IPath requestPath() {
                return iPath;
            }
        };
        this.basicRemoveMarkers(resourceInfo, iPathRequestor, string, bl);
        if (n == 0 || resourceInfo.getType() == 1) {
            return;
        }
        if (n == 1) {
            n = 0;
        }
        IPath[] iPathArray = this.workspace.getElementTree().getChildren(iPath);
        int n2 = 0;
        while (n2 < iPathArray.length) {
            this.recursiveRemoveMarkers(iPathArray[n2], string, bl, n);
            ++n2;
        }
    }

    public void removeMarker(IResource iResource, long l) {
        MarkerInfo markerInfo = this.findMarkerInfo(iResource, l);
        if (markerInfo == null) {
            return;
        }
        ResourceInfo resourceInfo = ((Workspace)iResource.getWorkspace()).getResourceInfo(iResource.getFullPath(), false, true);
        MarkerSet markerSet = resourceInfo.getMarkers(true);
        int n = markerSet.size();
        markerSet.remove(markerInfo);
        resourceInfo.setMarkers(markerSet.size() == 0 ? null : markerSet);
        if (markerSet.size() != n) {
            if (this.isPersistent(markerInfo)) {
                resourceInfo.set(4096);
            }
            IMarkerSetElement[] iMarkerSetElementArray = new IMarkerSetElement[]{new MarkerDelta(2, iResource, markerInfo)};
            this.changedMarkers(iResource, iMarkerSetElementArray);
        }
    }

    public void removeMarkers(IResource iResource, int n) {
        this.removeMarkers(iResource, null, false, n);
    }

    public void removeMarkers(IResource iResource, String string, boolean bl, int n) {
        if (n == 2 && iResource.getType() != 1) {
            this.visitorRemoveMarkers(iResource.getFullPath(), string, bl);
        } else {
            this.recursiveRemoveMarkers(iResource.getFullPath(), string, bl, n);
        }
    }

    public void resetMarkerDeltas(long l) {
        this.currentDeltas = null;
        this.deltaManager.resetDeltas(l);
    }

    public void restore(IResource iResource, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.restoreFromSave(iResource, bl);
        this.restoreFromSnap(iResource);
    }

    protected void restoreFromSave(IResource iResource, boolean bl) throws CoreException {
        IPath iPath = this.workspace.getMetaArea().getMarkersLocationFor(iResource);
        IPath iPath2 = this.workspace.getMetaArea().getBackupLocationFor(iPath);
        File file = new File(iPath.toOSString());
        File file2 = new File(iPath2.toOSString());
        if (!file.exists() && !file2.exists()) {
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new SafeFileInputStream(iPath.toOSString(), iPath2.toOSString()));
            try {
                MarkerReader markerReader = new MarkerReader(this.workspace);
                markerReader.read(dataInputStream, bl);
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Messages.resources_readMeta, (Object)iPath);
            throw new ResourceException(567, iPath, string, exception);
        }
    }

    protected void restoreFromSnap(IResource iResource) {
        IPath iPath = this.workspace.getMetaArea().getMarkersSnapshotLocationFor(iResource);
        if (!iPath.toFile().exists()) {
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new SafeChunkyInputStream(iPath.toFile()));
            try {
                try {
                    MarkerSnapshotReader markerSnapshotReader = new MarkerSnapshotReader(this.workspace);
                    while (true) {
                        markerSnapshotReader.read(dataInputStream);
                    }
                }
                catch (EOFException eOFException) {
                    dataInputStream.close();
                }
            }
            catch (Throwable throwable) {
                dataInputStream.close();
                throw throwable;
            }
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Messages.resources_readMeta, (Object)iPath);
            Policy.log(new ResourceStatus(567, iPath, string, exception));
        }
    }

    public void save(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream, List list) throws IOException {
        this.writer.save(resourceInfo, iPathRequestor, dataOutputStream, list);
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
    }

    public void snap(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream) throws IOException {
        this.writer.snap(resourceInfo, iPathRequestor, dataOutputStream);
    }

    public void startup(IProgressMonitor iProgressMonitor) {
    }

    private void visitorFindMarkers(IPath iPath, final ArrayList arrayList, final String string, final boolean bl) {
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                ResourceInfo resourceInfo = (ResourceInfo)object;
                if (resourceInfo == null) {
                    return false;
                }
                MarkerSet markerSet = resourceInfo.getMarkers(false);
                if (markerSet != null) {
                    IMarkerSetElement[] iMarkerSetElementArray = string == null ? markerSet.elements() : MarkerManager.this.basicFindMatching(markerSet, string, bl);
                    MarkerManager.this.buildMarkers(iMarkerSetElementArray, iPathRequestor.requestPath(), resourceInfo.getType(), arrayList);
                }
                return true;
            }
        };
        new ElementTreeIterator(this.workspace.getElementTree(), iPath).iterate(iElementContentVisitor);
    }

    private int visitorFindMaxSeverity(IPath iPath, String string, boolean bl) {
        class MaxSeverityVisitor
        implements IElementContentVisitor {
            int max;
            final /* synthetic */ MarkerManager this$0;
            private final /* synthetic */ String val$type;
            private final /* synthetic */ boolean val$includeSubtypes;

            MaxSeverityVisitor(MarkerManager markerManager, String string, boolean bl) {
                this.this$0 = markerManager;
                this.val$type = string;
                this.val$includeSubtypes = bl;
                this.max = -1;
            }

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                if (this.max >= 2) {
                    return false;
                }
                ResourceInfo resourceInfo = (ResourceInfo)object;
                if (resourceInfo == null) {
                    return false;
                }
                MarkerSet markerSet = resourceInfo.getMarkers(false);
                if (markerSet != null) {
                    this.max = Math.max(this.max, this.this$0.basicFindMaxSeverity(markerSet, this.val$type, this.val$includeSubtypes));
                }
                return this.max < 2;
            }
        }
        MaxSeverityVisitor maxSeverityVisitor = new MaxSeverityVisitor(this, string, bl);
        new ElementTreeIterator(this.workspace.getElementTree(), iPath).iterate(maxSeverityVisitor);
        return maxSeverityVisitor.max;
    }

    private void visitorRemoveMarkers(IPath iPath, final String string, final boolean bl) {
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                ResourceInfo resourceInfo = (ResourceInfo)object;
                if (resourceInfo == null) {
                    return false;
                }
                MarkerManager.this.basicRemoveMarkers(resourceInfo, iPathRequestor, string, bl);
                return true;
            }
        };
        new ElementTreeIterator(this.workspace.getElementTree(), iPath).iterate(iElementContentVisitor);
    }
}

