/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerAttributeMap;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerReader;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MarkerReader_1
extends MarkerReader {
    public static final int INDEX = 1;
    public static final int QNAME = 2;
    public static final int ATTRIBUTE_NULL = -1;
    public static final int ATTRIBUTE_BOOLEAN = 0;
    public static final int ATTRIBUTE_INTEGER = 1;
    public static final int ATTRIBUTE_STRING = 2;

    public MarkerReader_1(Workspace workspace) {
        super(workspace);
    }

    public void read(DataInputStream dataInputStream, boolean bl) throws IOException, CoreException {
        try {
            ArrayList arrayList = new ArrayList(5);
            while (true) {
                Path path = new Path(dataInputStream.readUTF());
                int n = dataInputStream.readInt();
                MarkerSet markerSet = new MarkerSet(n);
                int n2 = 0;
                while (n2 < n) {
                    markerSet.add(this.readMarkerInfo(dataInputStream, arrayList));
                    ++n2;
                }
                ResourceInfo resourceInfo = this.workspace.getResourceInfo((IPath)path, false, false);
                if (resourceInfo == null) continue;
                resourceInfo.setMarkers(markerSet);
                if (!bl) continue;
                Resource resource = this.workspace.newResource((IPath)path, resourceInfo.getType());
                IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements;
                ArrayList<MarkerDelta> arrayList2 = new ArrayList<MarkerDelta>(iMarkerSetElementArray.length);
                int n3 = 0;
                while (n3 < iMarkerSetElementArray.length) {
                    if (iMarkerSetElementArray[n3] != null) {
                        arrayList2.add(new MarkerDelta(1, resource, (MarkerInfo)iMarkerSetElementArray[n3]));
                    }
                    ++n3;
                }
                this.workspace.getMarkerManager().changedMarkers(resource, arrayList2.toArray(new IMarkerSetElement[arrayList2.size()]));
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private Map readAttributes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        MarkerAttributeMap markerAttributeMap = new MarkerAttributeMap(n);
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            int n3 = dataInputStream.readInt();
            Object object = null;
            switch (n3) {
                case 1: {
                    object = new Integer(dataInputStream.readInt());
                    break;
                }
                case 0: {
                    object = dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 2: {
                    object = dataInputStream.readUTF();
                    break;
                }
            }
            if (object != null) {
                markerAttributeMap.put(string, object);
            }
            ++n2;
        }
        return markerAttributeMap.isEmpty() ? null : markerAttributeMap;
    }

    private MarkerInfo readMarkerInfo(DataInputStream dataInputStream, List list) throws IOException, CoreException {
        MarkerInfo markerInfo = new MarkerInfo();
        markerInfo.setId(dataInputStream.readLong());
        int n = dataInputStream.readInt();
        switch (n) {
            case 2: {
                String string = dataInputStream.readUTF();
                markerInfo.setType(string);
                list.add(string);
                break;
            }
            case 1: {
                markerInfo.setType((String)list.get(dataInputStream.readInt()));
                break;
            }
            default: {
                String string = Messages.resources_readMarkers;
                throw new ResourceException(567, null, string, null);
            }
        }
        markerInfo.internalSetAttributes(this.readAttributes(dataInputStream));
        return markerInfo;
    }
}

