/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.StringPool;

public class MarkerSet
implements Cloneable,
IStringPoolParticipant {
    protected static final int MINIMUM_SIZE = 5;
    protected int elementCount = 0;
    protected IMarkerSetElement[] elements;

    public MarkerSet() {
        this(5);
    }

    public MarkerSet(int n) {
        this.elements = new IMarkerSetElement[Math.max(5, n * 2)];
    }

    public void add(IMarkerSetElement iMarkerSetElement) {
        int n;
        if (iMarkerSetElement == null) {
            return;
        }
        int n2 = n = this.hashFor(iMarkerSetElement.getId()) % this.elements.length;
        while (n2 < this.elements.length) {
            if (this.elements[n2] == null) {
                this.elements[n2] = iMarkerSetElement;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            if (this.elements[n2] == null) {
                this.elements[n2] = iMarkerSetElement;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++n2;
        }
        this.expand();
        this.add(iMarkerSetElement);
    }

    public void addAll(IMarkerSetElement[] iMarkerSetElementArray) {
        int n = 0;
        while (n < iMarkerSetElementArray.length) {
            this.add(iMarkerSetElementArray[n]);
            ++n;
        }
    }

    protected Object clone() {
        try {
            MarkerSet markerSet = (MarkerSet)super.clone();
            markerSet.elements = (IMarkerSetElement[])this.elements.clone();
            return markerSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(long l) {
        return this.get(l) != null;
    }

    public IMarkerSetElement[] elements() {
        IMarkerSetElement[] iMarkerSetElementArray = new IMarkerSetElement[this.elementCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.length) {
            IMarkerSetElement iMarkerSetElement = this.elements[n2];
            if (iMarkerSetElement != null) {
                iMarkerSetElementArray[n++] = iMarkerSetElement;
            }
            ++n2;
        }
        return iMarkerSetElementArray;
    }

    protected void expand() {
        IMarkerSetElement[] iMarkerSetElementArray = new IMarkerSetElement[this.elements.length * 2];
        int n = iMarkerSetElementArray.length - 1;
        int n2 = 0;
        while (n2 < this.elements.length) {
            IMarkerSetElement iMarkerSetElement = this.elements[n2];
            if (iMarkerSetElement != null) {
                int n3 = this.hashFor(iMarkerSetElement.getId()) % iMarkerSetElementArray.length;
                while (iMarkerSetElementArray[n3] != null) {
                    if (++n3 <= n) continue;
                    n3 = 0;
                }
                iMarkerSetElementArray[n3] = iMarkerSetElement;
            }
            ++n2;
        }
        this.elements = iMarkerSetElementArray;
    }

    public IMarkerSetElement get(long l) {
        IMarkerSetElement iMarkerSetElement;
        int n;
        if (this.elementCount == 0) {
            return null;
        }
        int n2 = n = this.hashFor(l) % this.elements.length;
        while (n2 < this.elements.length) {
            iMarkerSetElement = this.elements[n2];
            if (iMarkerSetElement == null) {
                return null;
            }
            if (iMarkerSetElement.getId() == l) {
                return iMarkerSetElement;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            iMarkerSetElement = this.elements[n2];
            if (iMarkerSetElement == null) {
                return null;
            }
            if (iMarkerSetElement.getId() == l) {
                return iMarkerSetElement;
            }
            ++n2;
        }
        return null;
    }

    private int hashFor(long l) {
        return Math.abs((int)l);
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    protected void rehashTo(int n) {
        int n2 = n;
        int n3 = n + 1;
        if (n3 >= this.elements.length) {
            n3 = 0;
        }
        IMarkerSetElement iMarkerSetElement = this.elements[n3];
        while (iMarkerSetElement != null) {
            boolean bl;
            int n4 = this.hashFor(iMarkerSetElement.getId()) % this.elements.length;
            if (n3 < n2) {
                bl = n4 <= n2 && n4 > n3;
            } else {
                boolean bl2 = bl = n4 <= n2 || n4 > n3;
            }
            if (bl) {
                this.elements[n2] = iMarkerSetElement;
                n2 = n3;
            }
            if (++n3 >= this.elements.length) {
                n3 = 0;
            }
            iMarkerSetElement = this.elements[n3];
        }
        this.elements[n2] = null;
    }

    public void remove(long l) {
        IMarkerSetElement iMarkerSetElement;
        int n;
        int n2 = n = this.hashFor(l) % this.elements.length;
        while (n2 < this.elements.length) {
            iMarkerSetElement = this.elements[n2];
            if (iMarkerSetElement == null) {
                return;
            }
            if (iMarkerSetElement.getId() == l) {
                this.rehashTo(n2);
                --this.elementCount;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            iMarkerSetElement = this.elements[n2];
            if (iMarkerSetElement == null) {
                return;
            }
            if (iMarkerSetElement.getId() == l) {
                this.rehashTo(n2);
                --this.elementCount;
            }
            ++n2;
        }
    }

    public void remove(IMarkerSetElement iMarkerSetElement) {
        this.remove(iMarkerSetElement.getId());
    }

    public void removeAll(IMarkerSetElement[] iMarkerSetElementArray) {
        int n = 0;
        while (n < iMarkerSetElementArray.length) {
            this.remove(iMarkerSetElementArray[n]);
            ++n;
        }
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }

    public void shareStrings(StringPool stringPool) {
        IMarkerSetElement[] iMarkerSetElementArray = this.elements;
        if (iMarkerSetElementArray == null) {
            return;
        }
        int n = 0;
        while (n < iMarkerSetElementArray.length) {
            IMarkerSetElement iMarkerSetElement = iMarkerSetElementArray[n];
            if (iMarkerSetElement instanceof String) {
                iMarkerSetElementArray[n] = stringPool.add((String)((Object)iMarkerSetElement));
            }
            if (iMarkerSetElement instanceof IStringPoolParticipant) {
                ((IStringPoolParticipant)((Object)iMarkerSetElement)).shareStrings(stringPool);
            }
            ++n;
        }
    }
}

