/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.MarkerAttributeMap;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.MarkerSnapshotReader;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MarkerSnapshotReader_1
extends MarkerSnapshotReader {
    public static final byte INDEX = 1;
    public static final byte QNAME = 2;
    public static final byte ATTRIBUTE_NULL = 0;
    public static final byte ATTRIBUTE_BOOLEAN = 1;
    public static final byte ATTRIBUTE_INTEGER = 2;
    public static final byte ATTRIBUTE_STRING = 3;

    public MarkerSnapshotReader_1(Workspace workspace) {
        super(workspace);
    }

    public void read(DataInputStream dataInputStream) throws IOException, CoreException {
        Path path = new Path(dataInputStream.readUTF());
        int n = dataInputStream.readInt();
        MarkerSet markerSet = new MarkerSet(n);
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            markerSet.add(this.readMarkerInfo(dataInputStream, arrayList));
            ++n2;
        }
        ResourceInfo resourceInfo = this.workspace.getResourceInfo((IPath)path, false, false);
        if (resourceInfo == null) {
            return;
        }
        resourceInfo.setMarkers(markerSet);
        resourceInfo.clear(4096);
    }

    private Map readAttributes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        if (n == 0) {
            return null;
        }
        MarkerAttributeMap markerAttributeMap = new MarkerAttributeMap(n);
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            byte by = dataInputStream.readByte();
            Object object = null;
            switch (by) {
                case 2: {
                    object = new Integer(dataInputStream.readInt());
                    break;
                }
                case 1: {
                    object = dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 3: {
                    object = dataInputStream.readUTF();
                    break;
                }
            }
            if (object != null) {
                markerAttributeMap.put(string, object);
            }
            ++n2;
        }
        return markerAttributeMap.isEmpty() ? null : markerAttributeMap;
    }

    private MarkerInfo readMarkerInfo(DataInputStream dataInputStream, List list) throws IOException, CoreException {
        MarkerInfo markerInfo = new MarkerInfo();
        markerInfo.setId(dataInputStream.readLong());
        byte by = dataInputStream.readByte();
        switch (by) {
            case 2: {
                String string = dataInputStream.readUTF();
                markerInfo.setType(string);
                list.add(string);
                break;
            }
            case 1: {
                markerInfo.setType((String)list.get(dataInputStream.readInt()));
                break;
            }
            default: {
                String string = Messages.resources_readMarkers;
                throw new ResourceException(567, null, string, null);
            }
        }
        markerInfo.internalSetAttributes(this.readAttributes(dataInputStream));
        return markerInfo;
    }
}

