/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MarkerTypeDefinitionCache {
    protected HashMap definitions;

    public MarkerTypeDefinitionCache() {
        this.loadDefinitions();
        HashSet hashSet = new HashSet(this.definitions.keySet());
        Iterator iterator = this.definitions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!hashSet.contains(string)) continue;
            this.computeSuperTypes(string, hashSet);
        }
    }

    private Set computeSuperTypes(String string, Set set) {
        MarkerTypeDefinition markerTypeDefinition = (MarkerTypeDefinition)this.definitions.get(string);
        if (markerTypeDefinition == null || markerTypeDefinition.superTypes == null) {
            set.remove(string);
            return null;
        }
        HashSet hashSet = new HashSet(markerTypeDefinition.superTypes);
        Iterator iterator = markerTypeDefinition.superTypes.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Set set2 = null;
            if (set.contains(string2)) {
                set2 = this.computeSuperTypes(string2, set);
            } else {
                MarkerTypeDefinition markerTypeDefinition2 = (MarkerTypeDefinition)this.definitions.get(string2);
                if (markerTypeDefinition2 != null) {
                    set2 = markerTypeDefinition2.superTypes;
                }
            }
            if (set2 == null) continue;
            hashSet.addAll(set2);
        }
        markerTypeDefinition.superTypes = hashSet;
        set.remove(string);
        return hashSet;
    }

    public boolean isPersistent(String string) {
        MarkerTypeDefinition markerTypeDefinition = (MarkerTypeDefinition)this.definitions.get(string);
        return markerTypeDefinition != null && markerTypeDefinition.isPersistent;
    }

    public boolean isSubtype(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        MarkerTypeDefinition markerTypeDefinition = (MarkerTypeDefinition)this.definitions.get(string);
        return markerTypeDefinition != null && markerTypeDefinition.superTypes != null && markerTypeDefinition.superTypes.contains(string2);
    }

    private void loadDefinitions() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        this.definitions = new HashMap(iExtensionArray.length);
        int n = 0;
        while (n < iExtensionArray.length) {
            String string = iExtensionArray[n].getUniqueIdentifier();
            if (string != null) {
                this.definitions.put(string.intern(), new MarkerTypeDefinition(iExtensionArray[n]));
            } else {
                Policy.log(2, "Missing marker id from plugin: " + iExtensionArray[n].getContributor().getName(), null);
            }
            ++n;
        }
    }

    static class MarkerTypeDefinition {
        boolean isPersistent = false;
        Set superTypes;

        MarkerTypeDefinition(IExtension iExtension) {
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string2 = iConfigurationElement.getName();
                if (string2.equalsIgnoreCase("super") && (string = iConfigurationElement.getAttribute("type")) != null) {
                    if (this.superTypes == null) {
                        this.superTypes = new HashSet(8);
                    }
                    this.superTypes.add(string.intern());
                }
                if (string2.equalsIgnoreCase("persistent") && (string = iConfigurationElement.getAttribute("value")) != null) {
                    this.isPersistent = Boolean.valueOf(string);
                }
                if (string2.equalsIgnoreCase("transient") && (string = iConfigurationElement.getAttribute("value")) != null) {
                    this.isPersistent = Boolean.valueOf(string) == false;
                }
                ++n;
            }
        }
    }
}

