/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.watson.IPathRequestor;

public class MarkerWriter {
    protected MarkerManager manager;
    public static final int MARKERS_SAVE_VERSION = 3;
    public static final int MARKERS_SNAP_VERSION = 2;
    public static final byte INDEX = 1;
    public static final byte QNAME = 2;
    public static final byte ATTRIBUTE_NULL = 0;
    public static final byte ATTRIBUTE_BOOLEAN = 1;
    public static final byte ATTRIBUTE_INTEGER = 2;
    public static final byte ATTRIBUTE_STRING = 3;

    public MarkerWriter(MarkerManager markerManager) {
        this.manager = markerManager;
    }

    private Object[] filterMarkers(IMarkerSetElement[] iMarkerSetElementArray) {
        Object[] objectArray = new Object[2];
        boolean[] blArray = new boolean[iMarkerSetElementArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < iMarkerSetElementArray.length) {
            MarkerInfo markerInfo = (MarkerInfo)iMarkerSetElementArray[n2];
            if (this.manager.isPersistent(markerInfo)) {
                blArray[n2] = true;
                ++n;
            }
            ++n2;
        }
        objectArray[0] = new Integer(n);
        objectArray[1] = blArray;
        return objectArray;
    }

    public void save(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream, List list) throws IOException {
        if (resourceInfo.isSet(8)) {
            return;
        }
        MarkerSet markerSet = resourceInfo.getMarkers(false);
        if (markerSet == null) {
            return;
        }
        IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
        Object[] objectArray = this.filterMarkers(iMarkerSetElementArray);
        int n = (Integer)objectArray[0];
        if (n == 0) {
            return;
        }
        if (dataOutputStream.size() == 0) {
            dataOutputStream.writeInt(3);
        }
        boolean[] blArray = (boolean[])objectArray[1];
        dataOutputStream.writeUTF(iPathRequestor.requestPath().toString());
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < iMarkerSetElementArray.length) {
            if (blArray[n2]) {
                this.write((MarkerInfo)iMarkerSetElementArray[n2], dataOutputStream, list);
            }
            ++n2;
        }
    }

    public void snap(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream) throws IOException {
        if (resourceInfo.isSet(8)) {
            return;
        }
        if (!resourceInfo.isSet(4096)) {
            return;
        }
        MarkerSet markerSet = resourceInfo.getMarkers(false);
        if (markerSet == null) {
            return;
        }
        IMarkerSetElement[] iMarkerSetElementArray = markerSet.elements();
        Object[] objectArray = this.filterMarkers(iMarkerSetElementArray);
        int n = (Integer)objectArray[0];
        dataOutputStream.writeInt(2);
        boolean[] blArray = (boolean[])objectArray[1];
        dataOutputStream.writeUTF(iPathRequestor.requestPath().toString());
        dataOutputStream.writeInt(n);
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < iMarkerSetElementArray.length) {
            if (blArray[n2]) {
                this.write((MarkerInfo)iMarkerSetElementArray[n2], dataOutputStream, arrayList);
            }
            ++n2;
        }
        resourceInfo.clear(4096);
    }

    private void write(Map map, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            dataOutputStream.writeUTF(string);
            Object v = map.get(string);
            if (v instanceof Integer) {
                dataOutputStream.writeByte(2);
                dataOutputStream.writeInt((Integer)v);
                continue;
            }
            if (v instanceof Boolean) {
                dataOutputStream.writeByte(1);
                dataOutputStream.writeBoolean((Boolean)v);
                continue;
            }
            if (v instanceof String) {
                dataOutputStream.writeByte(3);
                dataOutputStream.writeUTF((String)v);
                continue;
            }
            dataOutputStream.writeByte(0);
        }
    }

    private void write(MarkerInfo markerInfo, DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeLong(markerInfo.getId());
        String string = markerInfo.getType();
        int n = list.indexOf(string);
        if (n == -1) {
            dataOutputStream.writeByte(2);
            dataOutputStream.writeUTF(string);
            list.add(string);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(n);
        }
        if (markerInfo.getAttributes(false) == null) {
            dataOutputStream.writeShort(0);
        } else {
            this.write(markerInfo.getAttributes(false), dataOutputStream);
        }
        dataOutputStream.writeLong(markerInfo.getCreationTime());
    }
}

