/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.IModelObjectConstants;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ModelObjectWriter
implements IModelObjectConstants {
    private static String triggerString(BuildCommand buildCommand) {
        StringBuffer stringBuffer = new StringBuffer();
        if (buildCommand.isBuilding(9)) {
            stringBuffer.append("auto").append(',');
        }
        if (buildCommand.isBuilding(15)) {
            stringBuffer.append("clean").append(',');
        }
        if (buildCommand.isBuilding(6)) {
            stringBuffer.append("full").append(',');
        }
        if (buildCommand.isBuilding(10)) {
            stringBuffer.append("incremental").append(',');
        }
        return stringBuffer.toString();
    }

    protected String[] getReferencedProjects(ProjectDescription projectDescription) {
        IProject[] iProjectArray = projectDescription.getReferencedProjects();
        String[] stringArray = new String[iProjectArray.length];
        int n = 0;
        while (n < iProjectArray.length) {
            stringArray[n] = iProjectArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    protected void write(BuildCommand buildCommand, XMLWriter xMLWriter) {
        xMLWriter.startTag("buildCommand", null);
        if (buildCommand != null) {
            xMLWriter.printSimpleTag("name", buildCommand.getName());
            if (this.shouldWriteTriggers(buildCommand)) {
                xMLWriter.printSimpleTag("triggers", ModelObjectWriter.triggerString(buildCommand));
            }
            this.write("arguments", buildCommand.getArguments(false), xMLWriter);
        }
        xMLWriter.endTag("buildCommand");
    }

    private boolean shouldWriteTriggers(BuildCommand buildCommand) {
        if (!buildCommand.isConfigurable()) {
            return false;
        }
        return !buildCommand.isBuilding(9) || !buildCommand.isBuilding(15) || !buildCommand.isBuilding(6) || !buildCommand.isBuilding(10);
    }

    protected void write(LinkDescription linkDescription, XMLWriter xMLWriter) {
        xMLWriter.startTag("link", null);
        if (linkDescription != null) {
            xMLWriter.printSimpleTag("name", linkDescription.getProjectRelativePath());
            xMLWriter.printSimpleTag("type", Integer.toString(linkDescription.getType()));
            this.writeLocation(linkDescription.getLocationURI(), xMLWriter);
        }
        xMLWriter.endTag("link");
    }

    protected void write(FilterDescription filterDescription, XMLWriter xMLWriter) {
        xMLWriter.startTag("filter", null);
        if (filterDescription != null) {
            xMLWriter.printSimpleTag("name", filterDescription.getProjectRelativePath());
            xMLWriter.printSimpleTag("type", Integer.toString(filterDescription.getType()));
            xMLWriter.printSimpleTag("id", filterDescription.getFilterID());
            if (filterDescription.getArguments() != null) {
                xMLWriter.printSimpleTag("arguments", filterDescription.getArguments());
            }
        }
        xMLWriter.endTag("filter");
    }

    protected void write(VariableDescription variableDescription, XMLWriter xMLWriter) {
        xMLWriter.startTag("variable", null);
        if (variableDescription != null) {
            xMLWriter.printSimpleTag("name", variableDescription.getName());
            xMLWriter.printSimpleTag("value", variableDescription.getValue());
        }
        xMLWriter.endTag("variable");
    }

    private void writeLocation(URI uRI, XMLWriter xMLWriter) {
        if ("file".equals(uRI.getScheme())) {
            xMLWriter.printSimpleTag("location", FileUtil.toPath(uRI).toPortableString());
        } else {
            xMLWriter.printSimpleTag("locationURI", uRI.toASCIIString());
        }
    }

    public void write(Object object, IPath iPath, IPath iPath2) throws IOException {
        SafeFileOutputStream safeFileOutputStream = null;
        String string = iPath2 == null ? null : iPath2.toOSString();
        try {
            safeFileOutputStream = new SafeFileOutputStream(iPath.toOSString(), string);
            this.write(object, safeFileOutputStream);
        }
        finally {
            if (safeFileOutputStream != null) {
                safeFileOutputStream.close();
            }
        }
    }

    public void write(Object object, OutputStream outputStream) throws IOException {
        try {
            XMLWriter xMLWriter = new XMLWriter(outputStream);
            this.write(object, xMLWriter);
            xMLWriter.flush();
            xMLWriter.close();
        }
        finally {
            outputStream.close();
        }
    }

    protected void write(Object object, XMLWriter xMLWriter) throws IOException {
        if (object instanceof BuildCommand) {
            this.write((BuildCommand)object, xMLWriter);
            return;
        }
        if (object instanceof ProjectDescription) {
            this.write((ProjectDescription)object, xMLWriter);
            return;
        }
        if (object instanceof WorkspaceDescription) {
            this.write((WorkspaceDescription)object, xMLWriter);
            return;
        }
        if (object instanceof LinkDescription) {
            this.write((LinkDescription)object, xMLWriter);
            return;
        }
        if (object instanceof FilterDescription) {
            this.write((FilterDescription)object, xMLWriter);
            return;
        }
        if (object instanceof VariableDescription) {
            this.write((VariableDescription)object, xMLWriter);
            return;
        }
        xMLWriter.printTabulation();
        xMLWriter.println(object.toString());
    }

    protected void write(ProjectDescription projectDescription, XMLWriter xMLWriter) throws IOException {
        xMLWriter.startTag("projectDescription", null);
        if (projectDescription != null) {
            Object object;
            Cloneable cloneable;
            Cloneable cloneable2;
            xMLWriter.printSimpleTag("name", projectDescription.getName());
            String string = projectDescription.getComment();
            xMLWriter.printSimpleTag("comment", string == null ? "" : string);
            this.write("projects", "project", this.getReferencedProjects(projectDescription), xMLWriter);
            this.write("buildSpec", Arrays.asList(projectDescription.getBuildSpec(false)), xMLWriter);
            this.write("natures", "nature", projectDescription.getNatureIds(false), xMLWriter);
            HashMap hashMap = projectDescription.getLinks();
            if (hashMap != null) {
                cloneable2 = new ArrayList(hashMap.values());
                Collections.sort(cloneable2);
                this.write("linkedResources", (Collection)((Object)cloneable2), xMLWriter);
            }
            if ((cloneable2 = projectDescription.getFilters()) != null) {
                cloneable = new ArrayList();
                object = ((HashMap)cloneable2).values().iterator();
                while (object.hasNext()) {
                    List list = (List)object.next();
                    cloneable.addAll(list);
                }
                Collections.sort(cloneable);
                this.write("filteredResources", (Collection)((Object)cloneable), xMLWriter);
            }
            if ((cloneable = projectDescription.getVariables()) != null) {
                object = new ArrayList(((HashMap)cloneable).values());
                Collections.sort(object);
                this.write("variableList", (Collection)object, xMLWriter);
            }
        }
        xMLWriter.endTag("projectDescription");
    }

    protected void write(String string, Collection collection, XMLWriter xMLWriter) throws IOException {
        xMLWriter.startTag(string, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.write(iterator.next(), xMLWriter);
        }
        xMLWriter.endTag(string);
    }

    protected void write(String string, Map map, XMLWriter xMLWriter) {
        xMLWriter.startTag(string, null);
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            xMLWriter.startTag("dictionary", null);
            xMLWriter.printSimpleTag("key", string2);
            xMLWriter.printSimpleTag("value", v);
            xMLWriter.endTag("dictionary");
        }
        xMLWriter.endTag(string);
    }

    protected void write(String string, String string2, String[] stringArray, XMLWriter xMLWriter) {
        xMLWriter.startTag(string, null);
        int n = 0;
        while (n < stringArray.length) {
            xMLWriter.printSimpleTag(string2, stringArray[n]);
            ++n;
        }
        xMLWriter.endTag(string);
    }

    protected void write(WorkspaceDescription workspaceDescription, XMLWriter xMLWriter) {
        xMLWriter.startTag("workspaceDescription", null);
        if (workspaceDescription != null) {
            xMLWriter.printSimpleTag("name", workspaceDescription.getName());
            xMLWriter.printSimpleTag("autobuild", workspaceDescription.isAutoBuilding() ? "1" : "0");
            xMLWriter.printSimpleTag("snapshotInterval", new Long(workspaceDescription.getSnapshotInterval()));
            xMLWriter.printSimpleTag("fileStateLongevity", new Long(workspaceDescription.getFileStateLongevity()));
            xMLWriter.printSimpleTag("maxFileStateSize", new Long(workspaceDescription.getMaxFileStateSize()));
            xMLWriter.printSimpleTag("maxFileStates", new Integer(workspaceDescription.getMaxFileStates()));
            String[] stringArray = workspaceDescription.getBuildOrder(false);
            if (stringArray != null) {
                this.write("buildOrder", "project", stringArray, xMLWriter);
            }
        }
        xMLWriter.endTag("workspaceDescription");
    }
}

