/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectNatureDescriptor;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class NatureManager
implements ILifecycleListener,
IManager {
    protected Map descriptors;
    protected Map natureEnablements;
    protected Map buildersToNatures = null;
    private static final byte WHITE = 0;
    private static final byte GREY = 1;
    private static final byte BLACK = 2;

    protected NatureManager() {
    }

    protected String[] computeNatureEnablements(Project project) {
        Object object;
        Object object2;
        Object object3;
        ProjectDescription projectDescription = project.internalGetDescription();
        if (projectDescription == null) {
            return new String[0];
        }
        String[] stringArray = projectDescription.getNatureIds();
        int n = stringArray.length;
        if (n == 0) {
            return stringArray;
        }
        HashSet<Object> hashSet = new HashSet<Object>(n * 2);
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>(n);
        int n2 = 0;
        while (n2 < n) {
            object3 = stringArray[n2];
            object2 = (ProjectNatureDescriptor)this.getNatureDescriptor((String)object3);
            if (object2 != null) {
                if (!((ProjectNatureDescriptor)object2).hasCycle) {
                    hashSet.add(object3);
                }
                object = ((ProjectNatureDescriptor)object2).getNatureSetIds();
                int n3 = 0;
                while (n3 < ((String[])object).length) {
                    String string = object[n3];
                    ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>(5);
                        hashMap.put(string, arrayList);
                    }
                    arrayList.add(object3);
                    ++n3;
                }
            }
            ++n2;
        }
        String[] stringArray2 = hashMap.values().iterator();
        while (stringArray2.hasNext()) {
            object3 = (ArrayList)stringArray2.next();
            if (((ArrayList)object3).size() <= 1) continue;
            hashSet.removeAll((Collection<?>)object3);
        }
        stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        stringArray2 = this.sortNatureSet(stringArray2);
        int n4 = 0;
        while (n4 < stringArray2.length) {
            object2 = stringArray2[n4];
            object = this.getNatureDescriptor((String)object2);
            String[] stringArray3 = object.getRequiredNatureIds();
            int n5 = 0;
            while (n5 < stringArray3.length) {
                if (!hashSet.contains(stringArray3[n5])) {
                    hashSet.remove(object2);
                    break;
                }
                ++n5;
            }
            ++n4;
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public IProjectNatureDescriptor getNatureDescriptor(String string) {
        this.lazyInitialize();
        return (IProjectNatureDescriptor)this.descriptors.get(string);
    }

    public IProjectNatureDescriptor[] getNatureDescriptors() {
        this.lazyInitialize();
        Collection collection = this.descriptors.values();
        return collection.toArray(new IProjectNatureDescriptor[collection.size()]);
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.kind) {
            case 1: 
            case 2: 
            case 16: 
            case 32: 
            case 64: {
                this.flushEnablements((IProject)lifecycleEvent.resource);
            }
        }
    }

    protected void configureNature(final Project project, final String string, final MultiStatus multiStatus) {
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void run() throws Exception {
                IProjectNature iProjectNature = NatureManager.this.createNature(project, string);
                iProjectNature.configure();
                ProjectInfo projectInfo = (ProjectInfo)project.getResourceInfo(false, true);
                projectInfo.setNature(string, iProjectNature);
            }

            public void handleException(Throwable throwable) {
                if (throwable instanceof CoreException) {
                    multiStatus.add(((CoreException)throwable).getStatus());
                } else {
                    multiStatus.add((IStatus)new ResourceStatus(566, project.getFullPath(), NLS.bind((String)Messages.resources_errorNature, (Object)string), throwable));
                }
            }
        };
        if (Policy.DEBUG_NATURES) {
            System.out.println("Configuring nature: " + string + " on project: " + project.getName());
        }
        SafeRunner.run((ISafeRunnable)iSafeRunnable);
    }

    public void configureNatures(Project project, ProjectDescription projectDescription, ProjectDescription projectDescription2, MultiStatus multiStatus) {
        int n;
        HashSet<String> hashSet;
        HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(projectDescription.getNatureIds(false)));
        if (hashSet2.equals(hashSet = new HashSet<String>(Arrays.asList(projectDescription2.getNatureIds(false))))) {
            return;
        }
        HashSet hashSet3 = (HashSet)hashSet2.clone();
        HashSet hashSet4 = (HashSet)hashSet.clone();
        hashSet4.removeAll(hashSet2);
        hashSet3.removeAll(hashSet);
        IStatus iStatus = this.validateAdditions(hashSet, hashSet4, project);
        if (!iStatus.isOK()) {
            multiStatus.merge(iStatus);
            return;
        }
        iStatus = this.validateRemovals(hashSet, hashSet3);
        if (!iStatus.isOK()) {
            multiStatus.merge(iStatus);
            return;
        }
        projectDescription.setNatureIds(projectDescription2.getNatureIds(true));
        this.flushEnablements(project);
        String[] stringArray = null;
        if (hashSet3.size() > 0) {
            stringArray = this.sortNatureSet(hashSet3.toArray(new String[hashSet3.size()]));
            n = stringArray.length;
            while (--n >= 0) {
                this.deconfigureNature(project, stringArray[n], multiStatus);
            }
        }
        if (hashSet4.size() > 0) {
            stringArray = this.sortNatureSet(hashSet4.toArray(new String[hashSet4.size()]));
            n = 0;
            while (n < stringArray.length) {
                this.configureNature(project, stringArray[n], multiStatus);
                ++n;
            }
        }
    }

    protected IProjectNature createNature(Project project, String string) throws CoreException {
        IExtension iExtension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "natures", string);
        if (iExtension == null) {
            String string2 = NLS.bind((String)Messages.resources_natureExtension, (Object)string);
            throw new ResourceException(2, project.getFullPath(), string2, null);
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        if (iConfigurationElementArray.length < 1) {
            String string3 = NLS.bind((String)Messages.resources_natureClass, (Object)string);
            throw new ResourceException(2, project.getFullPath(), string3, null);
        }
        IConfigurationElement iConfigurationElement = null;
        int n = 0;
        while (iConfigurationElement == null && n < iConfigurationElementArray.length) {
            if ("runtime".equalsIgnoreCase(iConfigurationElementArray[n].getName())) {
                iConfigurationElement = iConfigurationElementArray[n];
            }
            ++n;
        }
        if (iConfigurationElement == null) {
            String string4 = NLS.bind((String)Messages.resources_natureFormat, (Object)string);
            throw new ResourceException(2, project.getFullPath(), string4, null);
        }
        try {
            IProjectNature iProjectNature = (IProjectNature)iConfigurationElement.createExecutableExtension("run");
            iProjectNature.setProject(project);
            return iProjectNature;
        }
        catch (ClassCastException classCastException) {
            String string5 = NLS.bind((String)Messages.resources_natureImplement, (Object)string);
            throw new ResourceException(2, project.getFullPath(), string5, classCastException);
        }
    }

    protected void deconfigureNature(final Project project, final String string, final MultiStatus multiStatus) {
        final ProjectInfo projectInfo = (ProjectInfo)project.getResourceInfo(false, true);
        IProjectNature iProjectNature = projectInfo.getNature(string);
        if (iProjectNature == null) {
            try {
                iProjectNature = this.createNature(project, string);
            }
            catch (CoreException coreException) {
                return;
            }
        }
        final IProjectNature iProjectNature2 = iProjectNature;
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void run() throws Exception {
                iProjectNature2.deconfigure();
                projectInfo.setNature(string, null);
            }

            public void handleException(Throwable throwable) {
                if (throwable instanceof CoreException) {
                    multiStatus.add(((CoreException)throwable).getStatus());
                } else {
                    multiStatus.add((IStatus)new ResourceStatus(566, project.getFullPath(), NLS.bind((String)Messages.resources_natureDeconfig, (Object)string), throwable));
                }
            }
        };
        if (Policy.DEBUG_NATURES) {
            System.out.println("Deconfiguring nature: " + string + " on project: " + project.getName());
        }
        SafeRunner.run((ISafeRunnable)iSafeRunnable);
    }

    protected void detectCycles() {
        Collection collection = this.descriptors.values();
        ProjectNatureDescriptor[] projectNatureDescriptorArray = collection.toArray(new ProjectNatureDescriptor[collection.size()]);
        int n = 0;
        while (n < projectNatureDescriptorArray.length) {
            if (projectNatureDescriptorArray[n].colour == 0) {
                this.hasCycles(projectNatureDescriptorArray[n]);
            }
            ++n;
        }
    }

    protected IStatus failure(String string) {
        return new ResourceStatus(35, string);
    }

    public String findNatureForBuilder(String string) {
        if (this.buildersToNatures == null) {
            this.buildersToNatures = new HashMap(10);
            IProjectNatureDescriptor[] iProjectNatureDescriptorArray = this.getNatureDescriptors();
            int n = 0;
            while (n < iProjectNatureDescriptorArray.length) {
                String string2 = iProjectNatureDescriptorArray[n].getNatureId();
                String[] stringArray = ((ProjectNatureDescriptor)iProjectNatureDescriptorArray[n]).getBuilderIds();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.buildersToNatures.put(stringArray[n2], string2);
                    ++n2;
                }
                ++n;
            }
        }
        return (String)this.buildersToNatures.get(string);
    }

    protected void flushEnablements(IProject iProject) {
        if (this.natureEnablements != null) {
            this.natureEnablements.remove(iProject);
            if (this.natureEnablements.size() == 0) {
                this.natureEnablements = null;
            }
        }
    }

    protected String[] getEnabledNatures(Project project) {
        String[] stringArray;
        if (this.natureEnablements != null && (stringArray = (String[])this.natureEnablements.get(project)) != null) {
            return stringArray;
        }
        stringArray = this.computeNatureEnablements(project);
        this.setEnabledNatures(project, stringArray);
        return stringArray;
    }

    protected boolean hasCycles(ProjectNatureDescriptor projectNatureDescriptor) {
        if (projectNatureDescriptor.colour == 2) {
            return projectNatureDescriptor.hasCycle;
        }
        if (projectNatureDescriptor.colour == 1) {
            projectNatureDescriptor.hasCycle = true;
            projectNatureDescriptor.colour = (byte)2;
            return true;
        }
        projectNatureDescriptor.colour = 1;
        String[] stringArray = projectNatureDescriptor.getRequiredNatureIds();
        int n = 0;
        while (n < stringArray.length) {
            ProjectNatureDescriptor projectNatureDescriptor2 = (ProjectNatureDescriptor)this.getNatureDescriptor(stringArray[n]);
            if (projectNatureDescriptor2 != null && this.hasCycles(projectNatureDescriptor2)) {
                projectNatureDescriptor.hasCycle = true;
                projectNatureDescriptor.colour = (byte)2;
                return true;
            }
            ++n;
        }
        projectNatureDescriptor.hasCycle = false;
        projectNatureDescriptor.colour = (byte)2;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasLinks(IProject iProject) {
        try {
            IResource[] iResourceArray = iProject.members();
            int n = 0;
            while (true) {
                if (n >= iResourceArray.length) {
                    return false;
                }
                if (iResourceArray[n].isLinked()) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            Policy.log(coreException.getStatus());
        }
        return false;
    }

    protected String hasSetOverlap(IProjectNatureDescriptor iProjectNatureDescriptor, IProjectNatureDescriptor iProjectNatureDescriptor2) {
        if (iProjectNatureDescriptor == null || iProjectNatureDescriptor2 == null) {
            return null;
        }
        String[] stringArray = iProjectNatureDescriptor.getNatureSetIds();
        String[] stringArray2 = iProjectNatureDescriptor2.getNatureSetIds();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray[n].equals(stringArray2[n2])) {
                    return stringArray[n];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    protected void insert(ArrayList arrayList, Set set, String string) {
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        IProjectNatureDescriptor iProjectNatureDescriptor = this.getNatureDescriptor(string);
        if (iProjectNatureDescriptor != null) {
            String[] stringArray = iProjectNatureDescriptor.getRequiredNatureIds();
            int n = 0;
            while (n < stringArray.length) {
                this.insert(arrayList, set, stringArray[n]);
                ++n;
            }
        }
        arrayList.add(string);
    }

    public boolean isNatureEnabled(Project project, String string) {
        String[] stringArray = this.getEnabledNatures(project);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void lazyInitialize() {
        if (this.descriptors != null) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "natures");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        this.descriptors = new HashMap(iExtensionArray.length * 2 + 1);
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            ProjectNatureDescriptor projectNatureDescriptor = null;
            try {
                projectNatureDescriptor = new ProjectNatureDescriptor(iExtensionArray[n]);
            }
            catch (CoreException coreException) {
                Policy.log(coreException.getStatus());
            }
            if (projectNatureDescriptor != null) {
                this.descriptors.put(projectNatureDescriptor.getNatureId(), projectNatureDescriptor);
            }
            ++n;
        }
        this.detectCycles();
    }

    protected void setEnabledNatures(IProject iProject, String[] stringArray) {
        if (this.natureEnablements == null) {
            this.natureEnablements = Collections.synchronizedMap(new HashMap(20));
        }
        this.natureEnablements.put(iProject, stringArray);
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
    }

    public String[] sortNatureSet(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            return stringArray;
        }
        ArrayList arrayList = new ArrayList(n);
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            this.insert(arrayList, hashSet, stringArray[n2]);
            ++n2;
        }
        hashSet.clear();
        hashSet.addAll(Arrays.asList(stringArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashSet.contains(e)) continue;
            iterator.remove();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void startup(IProgressMonitor iProgressMonitor) {
        ((Workspace)ResourcesPlugin.getWorkspace()).addLifecycleListener(this);
    }

    protected IStatus validateAdditions(HashSet hashSet, HashSet hashSet2, IProject iProject) {
        Boolean bl = null;
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IProjectNatureDescriptor iProjectNatureDescriptor = this.getNatureDescriptor(string);
            if (iProjectNatureDescriptor == null) {
                return this.failure(NLS.bind((String)Messages.natures_missingNature, (Object)string));
            }
            if (((ProjectNatureDescriptor)iProjectNatureDescriptor).hasCycle) {
                return this.failure(NLS.bind((String)Messages.natures_hasCycle, (Object)string));
            }
            String[] stringArray = iProjectNatureDescriptor.getRequiredNatureIds();
            int n = 0;
            while (n < stringArray.length) {
                if (!hashSet.contains(stringArray[n])) {
                    return this.failure(NLS.bind((String)Messages.natures_missingPrerequisite, (Object)string, (Object)stringArray[n]));
                }
                ++n;
            }
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string2;
                String string3 = (String)iterator2.next();
                if (string3.equals(string) || (string2 = this.hasSetOverlap(iProjectNatureDescriptor, this.getNatureDescriptor(string3))) == null) continue;
                return this.failure(NLS.bind((String)Messages.natures_multipleSetMembers, (Object)string2));
            }
            if (iProjectNatureDescriptor.isLinkingAllowed()) continue;
            if (bl == null) {
                Boolean bl2 = bl = this.hasLinks(iProject) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!bl.booleanValue()) continue;
            return this.failure(NLS.bind((String)Messages.links_vetoNature, (Object)iProject.getName(), (Object)string));
        }
        return Status.OK_STATUS;
    }

    public IStatus validateLinkCreation(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            IProjectNatureDescriptor iProjectNatureDescriptor = this.getNatureDescriptor(stringArray[n]);
            if (iProjectNatureDescriptor != null && !iProjectNatureDescriptor.isLinkingAllowed()) {
                String string = NLS.bind((String)Messages.links_natureVeto, (Object)iProjectNatureDescriptor.getLabel());
                return new ResourceStatus(378, string);
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateRemovals(HashSet hashSet, HashSet hashSet2) {
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IProjectNatureDescriptor iProjectNatureDescriptor = this.getNatureDescriptor(string);
            if (iProjectNatureDescriptor == null) continue;
            String[] stringArray = iProjectNatureDescriptor.getRequiredNatureIds();
            int n = 0;
            while (n < stringArray.length) {
                if (hashSet2.contains(stringArray[n])) {
                    return this.failure(NLS.bind((String)Messages.natures_invalidRemoval, (Object)stringArray[n], (Object)string));
                }
                ++n;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validateNatureSet(String[] stringArray) {
        String[] stringArray2;
        Object object;
        int n = stringArray.length;
        if (n == 0) {
            return Status.OK_STATUS;
        }
        String string = Messages.natures_invalidSet;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 35, string, null);
        HashSet<Object> hashSet = new HashSet<Object>(n * 2);
        HashSet<String> hashSet2 = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            stringArray2 = (String[])this.getNatureDescriptor((String)object);
            if (stringArray2 == null) {
                multiStatus.add(this.failure(NLS.bind((String)Messages.natures_missingNature, (Object)object)));
            } else {
                if (stringArray2.hasCycle) {
                    multiStatus.add(this.failure(NLS.bind((String)Messages.natures_hasCycle, (Object)object)));
                }
                if (!hashSet.add(object)) {
                    multiStatus.add(this.failure(NLS.bind((String)Messages.natures_duplicateNature, (Object)object)));
                }
                String[] stringArray3 = stringArray2.getNatureSetIds();
                int n3 = 0;
                while (n3 < stringArray3.length) {
                    if (!hashSet2.add(stringArray3[n3])) {
                        multiStatus.add(this.failure(NLS.bind((String)Messages.natures_multipleSetMembers, (Object)stringArray3[n3])));
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            object = this.getNatureDescriptor(stringArray[n2]);
            if (object != null) {
                stringArray2 = object.getRequiredNatureIds();
                int n4 = 0;
                while (n4 < stringArray2.length) {
                    if (!hashSet.contains(stringArray2[n4])) {
                        multiStatus.add(this.failure(NLS.bind((String)Messages.natures_missingPrerequisite, (Object)stringArray[n2], (Object)stringArray2[n4])));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return multiStatus.isOK() ? Status.OK_STATUS : multiStatus;
    }
}

