/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;

public abstract class OS {
    private static final String INSTALLED_PLATFORM = Platform.getOS();
    public static final char[] INVALID_RESOURCE_CHARACTERS;
    public static final String[] INVALID_RESOURCE_NAMES;

    static {
        if (INSTALLED_PLATFORM.equals("win32")) {
            INVALID_RESOURCE_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
            INVALID_RESOURCE_NAMES = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
            Arrays.sort(INVALID_RESOURCE_NAMES);
        } else {
            char[] cArray = new char[2];
            cArray[0] = 47;
            INVALID_RESOURCE_CHARACTERS = cArray;
            INVALID_RESOURCE_NAMES = new String[0];
        }
    }

    public static boolean isNameValid(String string) {
        if (string.equals(".") || string.equals("..")) {
            return false;
        }
        if (INSTALLED_PLATFORM.equals("win32")) {
            int n = string.length();
            if (n == 0) {
                return false;
            }
            char c = string.charAt(n - 1);
            if (c == '.') {
                return false;
            }
            if (Character.isWhitespace(c)) {
                return false;
            }
            int n2 = string.indexOf(46);
            String string2 = string = n2 == -1 ? string : string.substring(0, n2);
        }
        return Arrays.binarySearch(INVALID_RESOURCE_NAMES, string.toLowerCase()) < 0;
    }
}

