/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.PathVariableChangeEvent;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.PathVariableUtil;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class PathVariableManager
implements IPathVariableManager,
IManager {
    static final String VARIABLE_PREFIX = "pathvariable.";
    private Set listeners = Collections.synchronizedSet(new HashSet());
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();

    public void addChangeListener(IPathVariableChangeListener iPathVariableChangeListener) {
        this.listeners.add(iPathVariableChangeListener);
    }

    private void checkIsValidName(String string) throws CoreException {
        IStatus iStatus = this.validateName(string);
        if (!iStatus.isOK()) {
            throw new CoreException(iStatus);
        }
    }

    private void checkIsValidValue(IPath iPath) throws CoreException {
        IStatus iStatus = this.validateValue(iPath);
        if (!iStatus.isOK()) {
            throw new CoreException(iStatus);
        }
    }

    private void fireVariableChangeEvent(String string, IPath iPath, int n) {
        if (this.listeners.size() == 0) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        final PathVariableChangeEvent pathVariableChangeEvent = new PathVariableChangeEvent(this, string, iPath, n);
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IPathVariableChangeListener iPathVariableChangeListener = (IPathVariableChangeListener)objectArray[n2];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() throws Exception {
                    iPathVariableChangeListener.pathVariableChanged(pathVariableChangeEvent);
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n2;
        }
    }

    private String getKeyForName(String string) {
        return VARIABLE_PREFIX + string;
    }

    public String[] getPathVariableNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray = this.preferences.propertyNames();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if (stringArray[n].startsWith(VARIABLE_PREFIX) && this.validateName(string = stringArray[n].substring(VARIABLE_PREFIX.length())).isOK() && this.validateValue(this.getValue(string)).isOK()) {
                linkedList.add(string);
            }
            ++n;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public IPath getValue(String string) {
        String string2 = this.getKeyForName(string);
        String string3 = this.preferences.getString(string2);
        return string3.length() == 0 ? null : Path.fromPortableString((String)string3);
    }

    public boolean isDefined(String string) {
        return this.getValue(string) != null;
    }

    public void removeChangeListener(IPathVariableChangeListener iPathVariableChangeListener) {
        this.listeners.remove(iPathVariableChangeListener);
    }

    public IPath resolvePath(IPath iPath) {
        if (iPath == null || iPath.segmentCount() == 0 || iPath.isAbsolute() || iPath.getDevice() != null) {
            return iPath;
        }
        IPath iPath2 = this.getValue(iPath.segment(0));
        return iPath2 == null ? iPath : iPath2.append(iPath.removeFirstSegments(1));
    }

    public URI resolveURI(URI uRI) {
        IPath iPath;
        if (uRI == null || uRI.isAbsolute()) {
            return uRI;
        }
        Path path = new Path(uRI.getSchemeSpecificPart());
        return path == (iPath = this.resolvePath((IPath)path)) ? uRI : URIUtil.toURI((IPath)iPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String string, IPath iPath) throws CoreException {
        int n;
        this.checkIsValidName(string);
        if (iPath != null && iPath.isAbsolute()) {
            iPath = FileUtil.canonicalPath(iPath);
        }
        this.checkIsValidValue(iPath);
        PathVariableManager pathVariableManager = this;
        synchronized (pathVariableManager) {
            boolean bl;
            IPath iPath2 = this.getValue(string);
            boolean bl2 = bl = iPath2 != null;
            if (!bl && iPath == null) {
                return;
            }
            if (bl && iPath2.equals((Object)iPath)) {
                return;
            }
            if (iPath == null) {
                this.preferences.setToDefault(this.getKeyForName(string));
                n = 3;
            } else {
                this.preferences.setValue(this.getKeyForName(string), iPath.toPortableString());
                n = bl ? 1 : 2;
            }
        }
        this.fireVariableChangeEvent(string, iPath, n);
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
    }

    public void startup(IProgressMonitor iProgressMonitor) {
    }

    public IStatus validateName(String string) {
        String string2 = null;
        if (string.length() == 0) {
            string2 = Messages.pathvar_length;
            return new ResourceStatus(77, null, string2);
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            string2 = NLS.bind((String)Messages.pathvar_beginLetter, (Object)String.valueOf(c));
            return new ResourceStatus(77, null, string2);
        }
        int n = 1;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (Character.isWhitespace(c2)) {
                return new ResourceStatus(77, null, Messages.pathvar_whitespace);
            }
            if (!Character.isLetter(c2) && !Character.isDigit(c2) && c2 != '_') {
                string2 = NLS.bind((String)Messages.pathvar_invalidChar, (Object)String.valueOf(c2));
                return new ResourceStatus(77, null, string2);
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateValue(IPath iPath) {
        if (!(iPath == null || iPath.isValidPath(iPath.toString()) && iPath.isAbsolute())) {
            String string = Messages.pathvar_invalidValue;
            return new ResourceStatus(77, null, string);
        }
        return Status.OK_STATUS;
    }

    public IPath convertToRelative(IPath iPath, boolean bl, String string) throws CoreException {
        return PathVariableUtil.convertToRelative(this, iPath, false, string);
    }
}

