/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.projectVariables.ProjectLocationProjectVariable;
import org.eclipse.core.internal.resources.projectVariables.WorkspaceLocationProjectVariable;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PathVariableUtil {
    public static String getUniqueVariableName(String string, IPathVariableManager iPathVariableManager) {
        char c;
        int n = 1;
        int n2 = string.indexOf(45);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (!Character.isLetter(c = (string = string.trim().toUpperCase()).charAt(0)) && c != '_') {
            string = String.valueOf('A') + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if ((Character.isLetter(c2) || Character.isDigit(c2) || c2 == '_') && !Character.isWhitespace(c2)) {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        String string2 = string = stringBuffer.toString();
        while (iPathVariableManager.isDefined(string2)) {
            string2 = String.valueOf(string) + n;
            ++n;
        }
        return string2;
    }

    public static IPath convertToPathRelativeMacro(IPathVariableManager iPathVariableManager, IPath iPath, boolean bl, String string) throws CoreException {
        return PathVariableUtil.convertToRelative(iPathVariableManager, iPath, bl, string, true, true);
    }

    public static IPath convertToRelative(IPathVariableManager iPathVariableManager, IPath iPath, boolean bl, String string) throws CoreException {
        return PathVariableUtil.convertToRelative(iPathVariableManager, iPath, bl, string, true, false);
    }

    private static IPath convertToRelative(IPathVariableManager iPathVariableManager, IPath iPath, boolean bl, String string, boolean bl2, boolean bl3) throws CoreException {
        int n;
        IPath iPath2;
        if (string != null && iPathVariableManager.isDefined(string)) {
            return PathVariableUtil.wrapInProperFormat(PathVariableUtil.makeRelativeToVariable(iPathVariableManager, iPath, bl, string, bl3), bl3);
        }
        IPath iPath3 = PathVariableUtil.convertToProperCase(iPath);
        IPath iPath4 = null;
        int n2 = -1;
        String[] stringArray = iPathVariableManager.getPathVariableNames();
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string2 = stringArray[n3];
            if (!(bl2 && string2.equals(WorkspaceLocationProjectVariable.NAME) || string2.equals("PARENT"))) {
                iPath2 = iPathVariableManager.getValue(string2);
                if ((iPath2 = PathVariableUtil.convertToProperCase(iPathVariableManager.resolvePath(iPath2))).isPrefixOf(iPath3) && (n = iPath2.segmentCount()) > n2) {
                    n2 = n;
                    iPath4 = PathVariableUtil.makeRelativeToVariable(iPathVariableManager, iPath, bl, string2, bl3);
                }
            }
            ++n3;
        }
        if (iPath4 != null) {
            return PathVariableUtil.wrapInProperFormat(iPath4, bl3);
        }
        if (bl) {
            n3 = iPath.segmentCount();
            int n4 = 0;
            while (n4 <= n3) {
                iPath2 = iPath3.removeLastSegments(n4);
                n = Integer.MAX_VALUE;
                int n5 = 0;
                while (n5 < stringArray.length) {
                    String string3 = stringArray[n5];
                    if (!(bl2 && string3.equals(WorkspaceLocationProjectVariable.NAME) || string3.equals("PARENT"))) {
                        int n6;
                        IPath iPath5 = iPathVariableManager.getValue(string3);
                        if (iPath2.isPrefixOf(iPath5 = PathVariableUtil.convertToProperCase(iPathVariableManager.resolvePath(iPath5))) && (n6 = iPath5.segmentCount() - n3) < n) {
                            n = n6;
                            iPath4 = PathVariableUtil.makeRelativeToVariable(iPathVariableManager, iPath, bl, string3, bl3);
                        }
                    }
                    ++n5;
                }
                if (iPath4 != null) {
                    return PathVariableUtil.wrapInProperFormat(iPath4, bl3);
                }
                ++n4;
            }
            if (n3 == 0) {
                String string4 = ProjectLocationProjectVariable.NAME;
                iPath2 = iPathVariableManager.getValue(string4);
                if (iPath.isPrefixOf(iPath2 = PathVariableUtil.convertToProperCase(iPathVariableManager.resolvePath(iPath2)))) {
                    iPath4 = PathVariableUtil.makeRelativeToVariable(iPathVariableManager, iPath, bl, string4, bl3);
                }
                if (iPath4 != null) {
                    return PathVariableUtil.wrapInProperFormat(iPath4, bl3);
                }
            }
        }
        if (bl2) {
            return PathVariableUtil.convertToRelative(iPathVariableManager, iPath, bl, string, false, bl3);
        }
        return iPath;
    }

    private static IPath wrapInProperFormat(IPath iPath, boolean bl) {
        if (bl) {
            iPath = PathVariableUtil.buildVariableMacro(iPath);
        }
        return iPath;
    }

    private static IPath makeRelativeToVariable(IPathVariableManager iPathVariableManager, IPath iPath, boolean bl, String string, boolean bl2) throws CoreException {
        int n;
        IPath iPath2 = PathVariableUtil.convertToProperCase(iPath);
        IPath iPath3 = iPathVariableManager.getValue(string);
        iPath3 = PathVariableUtil.convertToProperCase(iPathVariableManager.resolvePath(iPath3));
        int n2 = iPath3.segmentCount();
        if (iPath3.isPrefixOf(iPath2)) {
            IPath iPath4 = Path.fromOSString((String)string);
            int n3 = n2;
            while (n3 < iPath.segmentCount()) {
                iPath4 = iPath4.append(iPath.segment(n3));
                ++n3;
            }
            return iPath4;
        }
        if (bl && (n = iPath2.matchingFirstSegments(iPath3)) >= 0) {
            Object object;
            String string2;
            String string3 = PathVariableUtil.buildParentPathVariable(string, n2 - n, bl2);
            if (bl2) {
                string2 = string3;
            } else {
                string2 = PathVariableUtil.getExistingVariable(string3, iPathVariableManager);
                if (string2 == null) {
                    object = n > 0 ? iPath.segment(n - 1) : iPath.getDevice();
                    if (object == null) {
                        object = "ROOT";
                    }
                    string2 = PathVariableUtil.getUniqueVariableName((String)object, iPathVariableManager);
                    iPathVariableManager.setValue(string2, Path.fromOSString((String)string3));
                }
            }
            object = Path.fromOSString((String)string2);
            int n4 = n;
            while (n4 < iPath.segmentCount()) {
                object = object.append(iPath.segment(n4));
                ++n4;
            }
            return object;
        }
        return iPath;
    }

    private static String getExistingVariable(String string, IPathVariableManager iPathVariableManager) {
        String[] stringArray = iPathVariableManager.getPathVariableNames();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            IPath iPath = iPathVariableManager.getValue(string2);
            if (iPath.toOSString().equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    private static IPath convertToProperCase(IPath iPath) {
        if (Platform.getOS().equals("win32")) {
            return Path.fromPortableString((String)iPath.toPortableString().toLowerCase());
        }
        return iPath;
    }

    private static String buildParentPathVariable(String string, int n, boolean bl) {
        String string2 = "PARENT-" + n + "-" + string;
        if (!bl) {
            string2 = "${" + string2 + "}";
        }
        return string2;
    }

    public static IPath buildVariableMacro(IPath iPath) {
        String string = iPath.segment(0);
        string = "${" + string + "}";
        return Path.fromOSString((String)string).append(iPath.removeFirstSegments(1));
    }
}

