/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class PlatformURLResourceConnection
extends PlatformURLConnection {
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_URL_STRING = "platform:/resource/";
    private static URL rootURL;
    static /* synthetic */ Class class$0;

    public PlatformURLResourceConnection(URL uRL) {
        super(uRL);
    }

    protected boolean allowCaching() {
        return false;
    }

    protected URL resolve() throws IOException {
        String string = this.url.getFile().trim();
        IPath iPath = new Path(string = URLDecoder.decode(string, "UTF-8")).makeRelative();
        if (!iPath.segment(0).equals(RESOURCE)) {
            throw new IOException(NLS.bind((String)Messages.url_badVariant, (Object)this.url));
        }
        int n = iPath.segmentCount();
        if (n == 1) {
            return rootURL;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iPath.segment(1));
        if (!iProject.exists()) {
            String string2 = NLS.bind((String)Messages.url_couldNotResolve, (Object)iProject.getName(), (Object)this.url.toExternalForm());
            throw new IOException(string2);
        }
        IPath iPath2 = null;
        if (n == 2) {
            iPath2 = iProject.getLocation();
        } else {
            iPath = iPath.removeFirstSegments(2);
            iPath2 = iProject.getFile(iPath).getLocation();
        }
        return new URL("file", "", iPath2.toString());
    }

    public static void startup(IPath iPath) {
        if (rootURL != null) {
            return;
        }
        try {
            rootURL = iPath.toFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.resources.PlatformURLResourceConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register((String)RESOURCE, (Class)clazz);
    }
}

