/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectPathVariableManager;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class Project
extends Container
implements IProject {
    protected ProjectPathVariableManager pathVariableManager = new ProjectPathVariableManager(this);

    protected Project(IPath iPath, Workspace workspace) {
        super(iPath, workspace);
    }

    protected void assertCreateRequirements(IProjectDescription iProjectDescription) throws CoreException {
        String string;
        IFileStore iFileStore;
        IFileInfo iFileInfo;
        this.checkDoesNotExist();
        this.checkDescription(this, iProjectDescription, false);
        URI uRI = iProjectDescription.getLocationURI();
        if (uRI != null) {
            return;
        }
        if (!Workspace.caseSensitive && (iFileInfo = (iFileStore = this.getStore()).fetchInfo()).exists() && (string = this.getLocalManager().getLocalName(iFileStore)) != null && !iFileStore.getName().equals(string)) {
            String string2 = NLS.bind((String)Messages.resources_existsLocalDifferentCase, (Object)new Path(iFileStore.toString()).removeLastSegments(1).append(string).toOSString());
            throw new ResourceException(275, this.getFullPath(), string2, null);
        }
    }

    protected MultiStatus basicSetDescription(ProjectDescription projectDescription, int n) {
        String string = Messages.resources_projectDesc;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 568, string, null);
        ProjectDescription projectDescription2 = this.internalGetDescription();
        projectDescription2.setComment(projectDescription.getComment());
        projectDescription2.setBuildSpec(projectDescription.getBuildSpec(true));
        boolean bl = false;
        Object[] objectArray = projectDescription2.getReferencedProjects();
        Object[] objectArray2 = projectDescription.getReferencedProjects();
        if (!Arrays.equals(objectArray, objectArray2)) {
            projectDescription2.setReferencedProjects((IProject[])objectArray2);
            bl = true;
        }
        if (!Arrays.equals(objectArray = projectDescription2.getDynamicReferences(), objectArray2 = projectDescription.getDynamicReferences())) {
            projectDescription2.setDynamicReferences((IProject[])objectArray2);
            bl = true;
        }
        if (bl) {
            this.workspace.flushBuildOrder();
        }
        if ((n & 0x40) == 0) {
            this.workspace.getNatureManager().configureNatures(this, projectDescription2, projectDescription, multiStatus);
        } else {
            projectDescription2.setNatureIds(projectDescription.getNatureIds(false));
        }
        return multiStatus;
    }

    public void build(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.internalBuild(n, null, null, iProgressMonitor);
    }

    public void build(int n, String string, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)string);
        this.internalBuild(n, string, map, iProgressMonitor);
    }

    public void checkAccessible(int n) throws CoreException {
        super.checkAccessible(n);
        if (!this.isOpen(n)) {
            String string = NLS.bind((String)Messages.resources_mustBeOpen, (Object)this.getFullPath());
            throw new ResourceException(372, this.getFullPath(), string, null);
        }
    }

    protected void checkDescription(IProject iProject, IProjectDescription iProjectDescription, boolean bl) throws CoreException {
        URI uRI = iProjectDescription.getLocationURI();
        String string = Messages.resources_invalidProjDesc;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 77, string, null);
        multiStatus.merge(this.workspace.validateName(iProjectDescription.getName(), 4));
        if (bl) {
            URI uRI2 = this.internalGetDescription().getLocationURI();
            if (uRI2 == null || !uRI2.equals(uRI)) {
                multiStatus.merge(this.workspace.validateProjectLocationURI(iProject, uRI));
            }
        } else {
            multiStatus.merge(this.workspace.validateProjectLocationURI(iProject, uRI));
        }
        if (!multiStatus.isOK()) {
            throw new ResourceException((IStatus)multiStatus);
        }
    }

    public void close(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_closing_1, (Object)this.getName());
            iProgressMonitor.beginTask(string, 100);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                ResourceInfo resourceInfo = this.getResourceInfo(false, false);
                int n = this.getFlags(resourceInfo);
                this.checkExists(n, true);
                iProgressMonitor.subTask(string);
                if (!this.isOpen(n)) {
                    return;
                }
                try {
                    this.workspace.beginOperation(true);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(1, this));
                    this.workspace.flushBuildOrder();
                    IProgressMonitor iProgressMonitor2 = Policy.subMonitorFor(iProgressMonitor, Policy.opWork / 2, 2);
                    IStatus iStatus = this.workspace.getSaveManager().save(3, this, iProgressMonitor2);
                    this.internalClose();
                    iProgressMonitor.worked(Policy.opWork / 2);
                    if (iStatus != null && !iStatus.isOK()) {
                        throw new ResourceException(iStatus);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void copy(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        if (iPath.segmentCount() == 1) {
            String string = iPath.segment(0);
            IProjectDescription iProjectDescription = this.getDescription();
            iProjectDescription.setName(string);
            iProjectDescription.setLocation(null);
            this.internalCopy(iProjectDescription, n, iProgressMonitor);
        } else {
            this.checkCopyRequirements(iPath, 4, n);
        }
    }

    public void copy(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iProjectDescription);
        this.internalCopy(iProjectDescription, n, iProgressMonitor);
    }

    protected void copyMetaArea(IProject iProject, IProject iProject2, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileStore iFileStore = EFS.getFileSystem((String)"file").getStore(this.workspace.getMetaArea().locationFor(iProject));
        IFileStore iFileStore2 = EFS.getFileSystem((String)"file").getStore(this.workspace.getMetaArea().locationFor(iProject2));
        iFileStore.copy(iFileStore2, 0, iProgressMonitor);
    }

    public void create(IProgressMonitor iProgressMonitor) throws CoreException {
        this.create(null, iProgressMonitor);
    }

    public void create(IProjectDescription iProjectDescription, IProgressMonitor iProgressMonitor) throws CoreException {
        this.create(iProjectDescription, 0, iProgressMonitor);
    }

    public void create(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask(Messages.resources_create, 100);
            this.checkValidPath(this.path, 4, false);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    boolean bl;
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    if (iProjectDescription == null) {
                        iProjectDescription = new ProjectDescription();
                        iProjectDescription.setName(this.getName());
                    }
                    this.assertCreateRequirements(iProjectDescription);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(8, this));
                    this.workspace.beginOperation(true);
                    this.workspace.createResource((IResource)this, n);
                    this.workspace.getMetaArea().create(this);
                    ProjectInfo projectInfo = (ProjectInfo)this.getResourceInfo(false, true);
                    ProjectDescription projectDescription = (ProjectDescription)((ProjectDescription)iProjectDescription).clone();
                    projectDescription.setLocationURI(FileUtil.canonicalURI(iProjectDescription.getLocationURI()));
                    projectDescription.setName(this.getName());
                    this.internalSetDescription(projectDescription, false);
                    boolean bl2 = bl = this.getLocalManager().hasSavedDescription(this);
                    if (!bl) {
                        bl2 = this.getLocalManager().hasSavedContent(this);
                    }
                    try {
                        if (bl) {
                            this.updateDescription();
                            this.workspace.getMetaArea().writePrivateDescription(this);
                        } else {
                            this.writeDescription(1);
                        }
                    }
                    catch (CoreException coreException) {
                        this.workspace.deleteResource(this);
                        throw coreException;
                    }
                    projectInfo.clearModificationStamp();
                    if (bl2) {
                        projectInfo.set(0x100000);
                    }
                    this.workspace.getSaveManager().requestSnapshot();
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void delete(boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl2 ? 1 : 0;
        this.delete(n |= bl ? 4 : 8, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.delete(n, iProgressMonitor);
    }

    public void deleteResource(boolean bl, MultiStatus multiStatus) throws CoreException {
        super.deleteResource(bl, multiStatus);
        this.workspace.getMetaArea().delete(this);
        this.clearHistory(null);
    }

    protected void fixupAfterMoveSource() throws CoreException {
        this.workspace.deleteResource(this);
        ProjectPreferences.deleted(this);
    }

    public IContentTypeMatcher getContentTypeMatcher() throws CoreException {
        return this.workspace.getContentDescriptionManager().getContentTypeMatcher(this);
    }

    public String getDefaultCharset(boolean bl) {
        if (!this.exists()) {
            return bl ? ResourcesPlugin.getEncoding() : null;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), bl);
    }

    public IProjectDescription getDescription() throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(resourceInfo));
        ProjectDescription projectDescription = ((ProjectInfo)resourceInfo).getDescription();
        if (projectDescription == null) {
            this.checkAccessible(-1);
        }
        return (IProjectDescription)projectDescription.clone();
    }

    public IProjectNature getNature(String string) throws CoreException {
        ProjectInfo projectInfo = (ProjectInfo)this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(projectInfo));
        IProjectNature iProjectNature = projectInfo.getNature(string);
        if (iProjectNature == null) {
            if (!this.hasNature(string)) {
                return null;
            }
            iProjectNature = this.workspace.getNatureManager().createNature(this, string);
            projectInfo.setNature(string, iProjectNature);
        }
        return iProjectNature;
    }

    public IContainer getParent() {
        return this.workspace.getRoot();
    }

    public IPath getPluginWorkingLocation(IPluginDescriptor iPluginDescriptor) {
        if (iPluginDescriptor == null) {
            return null;
        }
        return this.getWorkingLocation(iPluginDescriptor.getUniqueIdentifier());
    }

    public IProject getProject() {
        return this;
    }

    public IPath getProjectRelativePath() {
        return Path.EMPTY;
    }

    public IPath getRawLocation() {
        ProjectDescription projectDescription = this.internalGetDescription();
        return projectDescription == null ? null : projectDescription.getLocation();
    }

    public URI getRawLocationURI() {
        ProjectDescription projectDescription = this.internalGetDescription();
        return projectDescription == null ? null : projectDescription.getLocationURI();
    }

    public IProject[] getReferencedProjects() throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(resourceInfo));
        ProjectDescription projectDescription = ((ProjectInfo)resourceInfo).getDescription();
        if (projectDescription == null) {
            this.checkAccessible(-1);
        }
        return projectDescription.getAllReferences(true);
    }

    public IProject[] getReferencingProjects() {
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        ArrayList<IProject> arrayList = new ArrayList<IProject>(iProjectArray.length);
        int n = 0;
        while (n < iProjectArray.length) {
            ProjectDescription projectDescription;
            Project project = (Project)iProjectArray[n];
            if (project.isAccessible() && (projectDescription = project.internalGetDescription()) != null) {
                IProject[] iProjectArray2 = projectDescription.getAllReferences(false);
                int n2 = 0;
                while (n2 < iProjectArray2.length) {
                    if (iProjectArray2[n2].equals(this)) {
                        arrayList.add(iProjectArray[n]);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    public int getType() {
        return 4;
    }

    public IPath getWorkingLocation(String string) {
        if (string == null || !this.exists()) {
            return null;
        }
        IPath iPath = this.workspace.getMetaArea().getWorkingLocation(this, string);
        iPath.toFile().mkdirs();
        return iPath;
    }

    public boolean hasNature(String string) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        ProjectDescription projectDescription = this.internalGetDescription();
        if (projectDescription == null) {
            this.checkAccessible(-1);
        }
        return projectDescription.hasNature(string);
    }

    protected void internalBuild(final int n, final String string, final Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor = Policy.monitorFor(iProgressMonitor);
                IWorkspaceRoot iWorkspaceRoot = Project.this.workspace.getRoot();
                try {
                    ResourceInfo resourceInfo;
                    iProgressMonitor.beginTask("", Policy.opWork);
                    try {
                        Project.this.workspace.prepareOperation(iWorkspaceRoot, iProgressMonitor);
                        resourceInfo = Project.this.getResourceInfo(false, false);
                        int n2 = Project.this.getFlags(resourceInfo);
                        if (!Project.this.exists(n2, true) || !Project.this.isOpen(n2)) {
                            return;
                        }
                        Project.this.workspace.beginOperation(true);
                        Project.this.workspace.aboutToBuild(Project.this, n);
                    }
                    finally {
                        Project.this.workspace.endOperation(iWorkspaceRoot, false, iProgressMonitor);
                    }
                    resourceInfo = Project.this.workspace.getBuildManager().getRule(Project.this, n, string, map);
                    try {
                        Project.this.workspace.prepareOperation((ISchedulingRule)resourceInfo, iProgressMonitor);
                        Project.this.workspace.beginOperation(true);
                        IStatus iStatus = Project.this.workspace.getBuildManager().build(Project.this, n, string, map, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                        if (!iStatus.isOK()) {
                            throw new ResourceException(iStatus);
                        }
                    }
                    finally {
                        Project.this.workspace.endOperation((ISchedulingRule)resourceInfo, false, iProgressMonitor);
                        try {
                            Project.this.workspace.prepareOperation(iWorkspaceRoot, iProgressMonitor);
                            Project.this.workspace.beginOperation(true);
                            Project.this.workspace.broadcastBuildEvent(Project.this, 16, n);
                            if (Project.this.workspace.getElementTree().isImmutable()) {
                                Project.this.workspace.newWorkingTree();
                            }
                        }
                        finally {
                            Project.this.workspace.endOperation(iWorkspaceRoot, false, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
                        }
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        }, iProgressMonitor);
    }

    protected void internalClose() throws CoreException {
        this.workspace.flushBuildOrder();
        this.getMarkerManager().removeMarkers(this, 2);
        IResource[] iResourceArray = this.members(11);
        int n = 0;
        while (n < iResourceArray.length) {
            Resource resource = (Resource)iResourceArray[n];
            this.workspace.deleteResource(resource);
            ++n;
        }
        ResourceInfo resourceInfo = this.getResourceInfo(false, true);
        resourceInfo.clear(1);
        resourceInfo.clearSessionProperties();
        resourceInfo.clearModificationStamp();
        resourceInfo.setSyncInfo(null);
    }

    protected void internalCopy(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_copying, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            String string2 = iProjectDescription.getName();
            IPath iPath = new Path(string2).makeAbsolute();
            Project project = (Project)this.workspace.getRoot().getProject(string2);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().copyRule(this, project);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.assertCopyRequirements(iPath, 4, n);
                    this.checkDescription(project, iProjectDescription, false);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(4, this, project, n));
                    this.workspace.beginOperation(true);
                    this.getLocalManager().refresh(this, 2, true, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 20 / 100));
                    this.getPropertyManager().closePropertyStore(this);
                    this.getLocalManager().getHistoryStore().closeHistoryStore(this);
                    this.copyMetaArea(this, project, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 5 / 100));
                    this.internalCopyProjectOnly(project, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 5 / 100));
                    project.internalSetDescription(iProjectDescription, false);
                    project.getStore().mkdir(0, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 5 / 100));
                    string = Messages.resources_copyProblem;
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, string, null);
                    IResource[] iResourceArray = this.members(10);
                    int n2 = iResourceArray.length;
                    int n3 = n2 > 1 ? Policy.opWork * 50 / 100 / (n2 - 1) : 0;
                    int n4 = 0;
                    while (n4 < n2) {
                        IResource iResource = iResourceArray[n4];
                        if (!this.isProjectDescriptionFile(iResource)) {
                            try {
                                iResource.copy(iPath.append(iResource.getName()), n, Policy.subMonitorFor(iProgressMonitor, n3));
                            }
                            catch (CoreException coreException) {
                                multiStatus.merge(coreException.getStatus());
                            }
                        }
                        ++n4;
                    }
                    try {
                        project.writeDescription(1);
                    }
                    catch (CoreException coreException) {
                        try {
                            project.delete((n & 1) != 0, null);
                        }
                        catch (CoreException coreException2) {}
                        throw coreException;
                    }
                    iProgressMonitor.worked(Policy.opWork * 5 / 100);
                    iProgressMonitor.subTask(Messages.resources_updating);
                    this.getLocalManager().refresh(project, 2, true, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 10 / 100));
                    if (!multiStatus.isOK()) {
                        throw new ResourceException((IStatus)multiStatus);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void internalCopyProjectOnly(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        this.getPropertyManager().closePropertyStore(this);
        this.getLocalManager().getHistoryStore().closeHistoryStore(this);
        this.workspace.copyTree(this, iResource.getFullPath(), 0, 0, false);
        this.getPropertyManager().copy(this, iResource, 0);
        ProjectInfo projectInfo = (ProjectInfo)((Resource)iResource).getResourceInfo(false, true);
        projectInfo.description = null;
        projectInfo.natures = null;
        projectInfo.setMarkers(null);
        projectInfo.clearSessionProperties();
    }

    public ProjectDescription internalGetDescription() {
        ProjectInfo projectInfo = (ProjectInfo)this.getResourceInfo(false, false);
        if (projectInfo == null) {
            return null;
        }
        return projectInfo.getDescription();
    }

    void internalSetDescription(IProjectDescription iProjectDescription, boolean bl) {
        ProjectInfo projectInfo = (ProjectInfo)this.getResourceInfo(false, true);
        projectInfo.setDescription((ProjectDescription)iProjectDescription);
        this.getLocalManager().setLocation(this, projectInfo, iProjectDescription.getLocationURI());
        if (bl) {
            projectInfo.incrementContentId();
            if (projectInfo.getModificationStamp() != -1L) {
                this.workspace.updateModificationStamp(projectInfo);
            }
        }
    }

    public void internalSetLocal(boolean bl, int n) throws CoreException {
        if (n == 0) {
            return;
        }
        if (n == 1) {
            n = 0;
        }
        IResource[] iResourceArray = this.getChildren(0);
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            ((Resource)iResourceArray[n2]).internalSetLocal(bl, n);
            ++n2;
        }
    }

    public boolean isAccessible() {
        return this.isOpen();
    }

    public boolean isDerived(int n) {
        return false;
    }

    public boolean isLinked(int n) {
        return false;
    }

    public boolean isGroup() {
        return false;
    }

    public boolean isTeamPrivateMember(int n) {
        return false;
    }

    public boolean isLocal(int n) {
        return this.isLocal(-1, n);
    }

    public boolean isLocal(int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        if (n2 == 1) {
            n2 = 0;
        }
        IResource[] iResourceArray = this.getChildren(0);
        int n3 = 0;
        while (n3 < iResourceArray.length) {
            if (!iResourceArray[n3].isLocal(n2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isNatureEnabled(String string) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        return this.workspace.getNatureManager().isNatureEnabled(this, string);
    }

    public boolean isOpen() {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        return this.isOpen(this.getFlags(resourceInfo));
    }

    public boolean isOpen(int n) {
        return n != -1 && ResourceInfo.isSet(n, 1);
    }

    protected boolean isProjectDescriptionFile(IResource iResource) {
        return iResource.getType() == 1 && iResource.getFullPath().segmentCount() == 2 && iResource.getName().equals(".project");
    }

    public void move(IProjectDescription iProjectDescription, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iProjectDescription);
        this.move(iProjectDescription, bl ? 1 : 0, iProgressMonitor);
    }

    public void move(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iProjectDescription);
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_moving, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            IProject iProject = this.workspace.getRoot().getProject(iProjectDescription.getName());
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().moveRule(this, iProject);
            try {
                try {
                    IPath iPath;
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    if (!this.getName().equals(iProjectDescription.getName())) {
                        iPath = Path.ROOT.append(iProjectDescription.getName());
                        this.assertMoveRequirements(iPath, 4, n);
                    }
                    this.checkDescription(iProject, iProjectDescription, true);
                    this.workspace.beginOperation(true);
                    string = Messages.resources_moveProblem;
                    iPath = new MultiStatus("org.eclipse.core.resources", 4, string, null);
                    WorkManager workManager = this.workspace.getWorkManager();
                    ResourceTree resourceTree = new ResourceTree(this.getLocalManager(), workManager.getLock(), (MultiStatus)iPath, n);
                    IMoveDeleteHook iMoveDeleteHook = this.workspace.getMoveDeleteHook();
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(64, this, iProject, n));
                    int n2 = 0;
                    try {
                        n2 = workManager.beginUnprotected();
                        if (!iMoveDeleteHook.moveProject(resourceTree, this, iProjectDescription, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork / 2))) {
                            resourceTree.standardMoveProject(this, iProjectDescription, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork / 2));
                        }
                    }
                    finally {
                        workManager.endUnprotected(n2);
                    }
                    resourceTree.makeInvalid();
                    if (!resourceTree.getStatus().isOK()) {
                        throw new ResourceException(resourceTree.getStatus());
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void open(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_opening_1, (Object)this.getName());
            iProgressMonitor.beginTask(string, 100);
            iProgressMonitor.subTask(string);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                ProjectInfo projectInfo = (ProjectInfo)this.getResourceInfo(false, false);
                int n2 = this.getFlags(projectInfo);
                this.checkExists(n2, true);
                if (this.isOpen(n2)) {
                    return;
                }
                try {
                    this.workspace.beginOperation(true);
                    this.workspace.flushBuildOrder();
                    projectInfo = (ProjectInfo)this.getResourceInfo(false, true);
                    projectInfo.set(1);
                    boolean bl = projectInfo.isSet(0x100000);
                    if (bl) {
                        projectInfo.clear(0x100000);
                    }
                    boolean bl2 = projectInfo.isSet(16);
                    boolean bl3 = false;
                    if (bl2) {
                        bl3 = this.workspace.getSaveManager().restore(this, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 20 / 100));
                    } else {
                        projectInfo.set(16);
                        IStatus iStatus = this.reconcileLinksAndGroups(projectInfo.getDescription());
                        if (!iStatus.isOK()) {
                            throw new CoreException(iStatus);
                        }
                        this.workspace.updateModificationStamp(projectInfo);
                        iProgressMonitor.worked(Policy.opWork * 20 / 100);
                    }
                    this.startup();
                    if (!bl2 && bl || !bl3) {
                        if ((n & 0x80) != 0) {
                            this.workspace.refreshManager.refresh(this);
                            iProgressMonitor.worked(Policy.opWork * 80 / 100);
                        } else {
                            this.refreshLocal(2, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 80 / 100));
                        }
                    }
                    this.workspace.getAliasManager().updateAliases(this, this.getStore(), 2, iProgressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void open(IProgressMonitor iProgressMonitor) throws CoreException {
        this.open(0, iProgressMonitor);
    }

    public IStatus reconcileLinksAndGroups(ProjectDescription projectDescription) {
        Object object;
        Object object2;
        Object object3;
        Iterator<Object> iterator;
        Cloneable cloneable;
        String string = Messages.links_errorLinkReconcile;
        HashMap hashMap = projectDescription.getLinks();
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 76, string, null);
        ProjectDescription projectDescription2 = this.internalGetDescription();
        if (projectDescription2 != null && (cloneable = projectDescription2.getLinks()) != null) {
            iterator = ((HashMap)cloneable).values().iterator();
            while (iterator.hasNext()) {
                object3 = (LinkDescription)iterator.next();
                object2 = (Resource)this.findMember(((LinkDescription)object3).getProjectRelativePath());
                if (object2 == null || !((Resource)object2).isLinked()) continue;
                object = null;
                if (hashMap != null) {
                    object = (LinkDescription)hashMap.get(((LinkDescription)object3).getProjectRelativePath());
                }
                if (object != null && ((LinkDescription)object).getLocationURI().equals(((Resource)object2).getRawLocationURI()) && ((LinkDescription)object).getType() == ((Resource)object2).getType()) continue;
                try {
                    ((Resource)object2).delete(0, null);
                    ((Resource)object2).refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    multiStatus.merge(coreException.getStatus());
                }
            }
        }
        if (hashMap == null) {
            return multiStatus;
        }
        cloneable = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((LinkDescription)object).getProjectRelativePath().segmentCount();
                if (n2 != (n = ((LinkDescription)object2).getProjectRelativePath().segmentCount())) {
                    return n2 - n;
                }
                if (object.equals(object2)) {
                    return 0;
                }
                return -1;
            }
        });
        if (hashMap != null) {
            ((TreeSet)cloneable).addAll(hashMap.values());
        }
        iterator = ((TreeSet)cloneable).iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = (LinkDescription)object3;
            try {
                object = this.workspace.newResource(this.getFullPath().append(((LinkDescription)object2).getProjectRelativePath()), ((LinkDescription)object2).getType());
                IContainer iContainer = ((Resource)object).getParent();
                if (iContainer != null && !iContainer.exists() && iContainer.getType() == 2) {
                    ((Folder)iContainer).ensureExists(Policy.monitorFor(null));
                }
                if (((Resource)object).exists() && ((Resource)object).isLinked()) continue;
                if (((LinkDescription)object2).isGroup()) {
                    ((Folder)object).createGroup(272, null);
                    continue;
                }
                ((Resource)object).createLink(((LinkDescription)object2).getLocationURI(), 272, null);
            }
            catch (CoreException coreException) {
                multiStatus.merge(coreException.getStatus());
            }
        }
        return multiStatus;
    }

    public void setDescription(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask(Messages.resources_setDesc, 100);
            IWorkspaceRoot iWorkspaceRoot = null;
            iWorkspaceRoot = (n & 0x40) != 0 ? this.workspace.getRuleFactory().modifyRule(this) : this.workspace.getRoot();
            try {
                this.workspace.prepareOperation(iWorkspaceRoot, iProgressMonitor);
                ResourceInfo resourceInfo = this.getResourceInfo(false, false);
                this.checkAccessible(this.getFlags(resourceInfo));
                ProjectDescription projectDescription = this.internalGetDescription();
                ProjectDescription projectDescription2 = (ProjectDescription)iProjectDescription;
                boolean bl = projectDescription.hasPublicChanges(projectDescription2);
                boolean bl2 = projectDescription.hasPrivateChanges(projectDescription2);
                if (!bl && !bl2) {
                    return;
                }
                this.checkDescription(this, projectDescription2, false);
                boolean bl3 = true;
                if ((n & 1) == 0 && (bl3 = this.getLocalManager().hasSavedDescription(this)) && !this.getLocalManager().isDescriptionSynchronized(this)) {
                    String string = NLS.bind((String)Messages.resources_projectDescSync, (Object)this.getName());
                    throw new ResourceException(274, this.getFullPath(), string, null);
                }
                if (!bl3) {
                    bl3 = this.workspace.getMetaArea().hasSavedProject(this);
                }
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                this.workspace.beginOperation(true);
                MultiStatus multiStatus = this.basicSetDescription(projectDescription2, n);
                if (bl3 && !multiStatus.isOK()) {
                    throw new CoreException((IStatus)multiStatus);
                }
                this.writeDescription(projectDescription, n, bl, bl2);
                resourceInfo = this.getResourceInfo(false, true);
                resourceInfo.incrementContentId();
                this.workspace.updateModificationStamp(resourceInfo);
                if (!bl3) {
                    String string = NLS.bind((String)Messages.resources_missingProjectMetaRepaired, (Object)this.getName());
                    multiStatus.merge((IStatus)new ResourceStatus(234, this.getFullPath(), string));
                }
                if (!multiStatus.isOK()) {
                    throw new CoreException((IStatus)multiStatus);
                }
            }
            finally {
                this.workspace.endOperation(iWorkspaceRoot, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void setDescription(IProjectDescription iProjectDescription, IProgressMonitor iProgressMonitor) throws CoreException {
        this.setDescription(iProjectDescription, 2, iProgressMonitor);
    }

    protected void startup() throws CoreException {
        if (!this.isOpen()) {
            return;
        }
        this.workspace.broadcastEvent(LifecycleEvent.newEvent(32, this));
    }

    public void touch(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_touch, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                    this.workspace.beginOperation(true);
                    super.touch(Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void updateDescription() throws CoreException {
        if (ProjectDescription.isWriting) {
            return;
        }
        ProjectDescription.isReading = true;
        try {
            this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
            ProjectDescription projectDescription = this.getLocalManager().read(this, false);
            IStatus iStatus = null;
            if (this.isOpen()) {
                iStatus = this.reconcileLinksAndGroups(projectDescription);
            }
            this.internalSetDescription(projectDescription, true);
            if (iStatus != null && !iStatus.isOK()) {
                throw new CoreException(iStatus);
            }
        }
        finally {
            ProjectDescription.isReading = false;
        }
    }

    public void writeDescription(int n) throws CoreException {
        this.writeDescription(this.internalGetDescription(), n, true, true);
    }

    public void writeDescription(IProjectDescription iProjectDescription, int n, boolean bl, boolean bl2) throws CoreException {
        if (ProjectDescription.isReading) {
            return;
        }
        ProjectDescription.isWriting = true;
        try {
            this.getLocalManager().internalWrite(this, iProjectDescription, n, bl, bl2);
        }
        finally {
            ProjectDescription.isWriting = false;
        }
    }

    public IPathVariableManager getPathVariableManager() {
        return this.pathVariableManager;
    }

    public IPath getVariableRelativePathLocation(IPath iPath) {
        try {
            IPath iPath2 = this.getPathVariableManager().convertToRelative(iPath, false, null);
            if (!iPath2.equals((Object)iPath)) {
                return iPath2;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

