/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectNatureDescriptor;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Cache;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectContentTypes {
    private static final String CONTENT_TYPE_PREF_NODE = "content-types";
    static final InstanceScope INSTANCE_SCOPE = new InstanceScope();
    private static final String PREF_LOCAL_CONTENT_TYPE_SETTINGS = "enabled";
    private static final Preferences PROJECT_SCOPE = Platform.getPreferencesService().getRootNode().node("project");
    private Cache contentTypesPerProject;
    private Workspace workspace;

    static boolean usesContentTypePreferences(String string) {
        Preferences preferences;
        block7: {
            block6: {
                block5: {
                    try {
                        preferences = PROJECT_SCOPE;
                        if (preferences.nodeExists(string)) break block5;
                        return false;
                    }
                    catch (BackingStoreException backingStoreException) {
                        return false;
                    }
                }
                preferences = preferences.node(string);
                if (preferences.nodeExists("org.eclipse.core.runtime")) break block6;
                return false;
            }
            preferences = preferences.node("org.eclipse.core.runtime");
            if (preferences.nodeExists(CONTENT_TYPE_PREF_NODE)) break block7;
            return false;
        }
        preferences = preferences.node(CONTENT_TYPE_PREF_NODE);
        return preferences.getBoolean(PREF_LOCAL_CONTENT_TYPE_SETTINGS, false);
    }

    public ProjectContentTypes(Workspace workspace) {
        this.workspace = workspace;
        this.contentTypesPerProject = new Cache(5, 30, 0.4);
    }

    private Set collectAssociatedContentTypes(Project project) {
        String[] stringArray = this.workspace.getNatureManager().getEnabledNatures(project);
        if (stringArray.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            ProjectNatureDescriptor projectNatureDescriptor = (ProjectNatureDescriptor)this.workspace.getNatureDescriptor(stringArray[n]);
            if (projectNatureDescriptor != null) {
                String[] stringArray2 = projectNatureDescriptor.getContentTypeIds();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    hashSet.add(stringArray2[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet;
    }

    public void contentTypePreferencesChanged(IProject iProject) {
        ProjectInfo projectInfo = (ProjectInfo)((Project)iProject).getResourceInfo(false, false);
        if (projectInfo != null) {
            projectInfo.setMatcher(null);
        }
    }

    private IContentTypeMatcher createMatcher(Project project) {
        ProjectContentTypeSelectionPolicy projectContentTypeSelectionPolicy = new ProjectContentTypeSelectionPolicy(project);
        return Platform.getContentTypeManager().getMatcher((IContentTypeManager.ISelectionPolicy)projectContentTypeSelectionPolicy, (IScopeContext)projectContentTypeSelectionPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getAssociatedContentTypes(Project project) {
        ResourceInfo resourceInfo = project.getResourceInfo(false, false);
        if (resourceInfo == null) {
            return null;
        }
        String string = project.getName();
        Cache cache = this.contentTypesPerProject;
        synchronized (cache) {
            Cache.Entry entry = this.contentTypesPerProject.getEntry(string);
            if (entry != null && entry.getTimestamp() == (long)resourceInfo.getContentId()) {
                return (Set)entry.getCached();
            }
            Set set = this.collectAssociatedContentTypes(project);
            if (entry == null) {
                entry = this.contentTypesPerProject.addEntry(string, set, resourceInfo.getContentId());
            } else {
                entry.setTimestamp(resourceInfo.getContentId());
                entry.setCached(set);
            }
            return set;
        }
    }

    public IContentTypeMatcher getMatcherFor(Project project) throws CoreException {
        IContentTypeMatcher iContentTypeMatcher;
        ProjectInfo projectInfo = (ProjectInfo)project.getResourceInfo(false, false);
        if (projectInfo == null) {
            project.checkAccessible(project.getFlags(projectInfo));
        }
        if ((iContentTypeMatcher = projectInfo.getMatcher()) != null) {
            return iContentTypeMatcher;
        }
        iContentTypeMatcher = this.createMatcher(project);
        projectInfo.setMatcher(iContentTypeMatcher);
        return iContentTypeMatcher;
    }

    final IContentType[] select(Project project, IContentType[] iContentTypeArray, boolean bl, boolean bl2) {
        if (iContentTypeArray.length < 2) {
            return iContentTypeArray;
        }
        Set set = this.getAssociatedContentTypes(project);
        if (set == null || set.isEmpty()) {
            return iContentTypeArray;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < iContentTypeArray.length) {
            if (set.contains(iContentTypeArray[n2].getId())) {
                if (n < n2) {
                    IContentType iContentType = iContentTypeArray[n2];
                    int n3 = n2;
                    while (n3 > n) {
                        iContentTypeArray[n3] = iContentTypeArray[n3 - 1];
                        --n3;
                    }
                    iContentTypeArray[n] = iContentType;
                }
                ++n;
            }
            ++n2;
        }
        return iContentTypeArray;
    }

    private class ProjectContentTypeSelectionPolicy
    implements IContentTypeManager.ISelectionPolicy,
    IScopeContext {
        private Project project;
        private IScopeContext projectScope;

        public ProjectContentTypeSelectionPolicy(Project project) {
            this.project = project;
            this.projectScope = new ProjectScope(project);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IScopeContext)) {
                return false;
            }
            IScopeContext iScopeContext = (IScopeContext)object;
            if (!this.getName().equals(iScopeContext.getName())) {
                return false;
            }
            IPath iPath = this.getLocation();
            return iPath == null ? iScopeContext.getLocation() == null : iPath.equals((Object)iScopeContext.getLocation());
        }

        private IScopeContext getDelegate() {
            if (!ProjectContentTypes.usesContentTypePreferences(this.project.getName())) {
                return INSTANCE_SCOPE;
            }
            return this.projectScope;
        }

        public IPath getLocation() {
            return this.getDelegate().getLocation();
        }

        public String getName() {
            return this.getDelegate().getName();
        }

        public IEclipsePreferences getNode(String string) {
            return this.getDelegate().getNode(string);
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public IContentType[] select(IContentType[] iContentTypeArray, boolean bl, boolean bl2) {
            return ProjectContentTypes.this.select(this.project, iContentTypeArray, bl, bl2);
        }
    }
}

