/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class ProjectDescription
extends ModelObject
implements IProjectDescription {
    private static final ICommand[] EMPTY_COMMAND_ARRAY = new ICommand[0];
    private static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static boolean isReading = false;
    protected static boolean isWriting = false;
    protected ICommand[] buildSpec = EMPTY_COMMAND_ARRAY;
    protected IProject[] cachedRefs = null;
    protected String comment = "";
    protected IProject[] dynamicRefs = EMPTY_PROJECT_ARRAY;
    protected HashMap linkDescriptions = null;
    protected HashMap filterDescriptions = null;
    protected HashMap variableDescriptions = null;
    protected URI location = null;
    protected String[] natures = EMPTY_STRING_ARRAY;
    protected IProject[] staticRefs = EMPTY_PROJECT_ARRAY;

    public Object clone() {
        ProjectDescription projectDescription = (ProjectDescription)super.clone();
        projectDescription.linkDescriptions = null;
        projectDescription.filterDescriptions = null;
        if (this.variableDescriptions != null) {
            projectDescription.variableDescriptions = (HashMap)this.variableDescriptions.clone();
        }
        projectDescription.buildSpec = this.getBuildSpec(true);
        return projectDescription;
    }

    private IProject[] copyAndRemoveDuplicates(IProject[] iProjectArray) {
        IProject[] iProjectArray2 = new IProject[iProjectArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            block4: {
                IProject iProject = iProjectArray[n2];
                int n3 = 0;
                while (n3 < n) {
                    if (!iProject.equals(iProjectArray2[n3])) {
                        ++n3;
                        continue;
                    }
                    break block4;
                }
                iProjectArray2[n++] = iProject;
            }
            ++n2;
        }
        if (n < iProjectArray.length) {
            IProject[] iProjectArray3 = new IProject[n];
            System.arraycopy(iProjectArray2, 0, iProjectArray3, 0, n);
            return iProjectArray3;
        }
        return iProjectArray2;
    }

    public IProject[] getAllReferences(boolean bl) {
        if (this.cachedRefs == null) {
            IProject[] iProjectArray = this.getReferencedProjects(false);
            IProject[] iProjectArray2 = this.getDynamicReferences(false);
            if (iProjectArray2.length == 0) {
                this.cachedRefs = iProjectArray;
            } else if (iProjectArray.length == 0) {
                this.cachedRefs = iProjectArray2;
            } else {
                IProject[] iProjectArray3 = new IProject[iProjectArray2.length + iProjectArray.length];
                System.arraycopy(iProjectArray, 0, iProjectArray3, 0, iProjectArray.length);
                System.arraycopy(iProjectArray2, 0, iProjectArray3, iProjectArray.length, iProjectArray2.length);
                this.cachedRefs = this.copyAndRemoveDuplicates(iProjectArray3);
            }
        }
        return bl ? (IProject[])this.cachedRefs.clone() : this.cachedRefs;
    }

    public ICommand[] getBuildSpec() {
        return this.getBuildSpec(true);
    }

    public ICommand[] getBuildSpec(boolean bl) {
        ICommand[] iCommandArray = this.buildSpec;
        if (iCommandArray == null) {
            return EMPTY_COMMAND_ARRAY;
        }
        if (!bl) {
            return iCommandArray;
        }
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length];
        int n = 0;
        while (n < iCommandArray2.length) {
            iCommandArray2[n] = (ICommand)((BuildCommand)iCommandArray[n]).clone();
            ++n;
        }
        return iCommandArray2;
    }

    public String getComment() {
        return this.comment;
    }

    public IProject[] getDynamicReferences() {
        return this.getDynamicReferences(true);
    }

    public IProject[] getDynamicReferences(boolean bl) {
        if (this.dynamicRefs == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        return bl ? (IProject[])this.dynamicRefs.clone() : this.dynamicRefs;
    }

    public URI getLinkLocationURI(IPath iPath) {
        if (this.linkDescriptions == null) {
            return null;
        }
        LinkDescription linkDescription = (LinkDescription)this.linkDescriptions.get(iPath);
        return linkDescription == null ? null : linkDescription.getLocationURI();
    }

    public synchronized LinkedList getFilter(IPath iPath) {
        if (this.filterDescriptions == null) {
            return null;
        }
        LinkedList linkedList = (LinkedList)this.filterDescriptions.get(iPath);
        return linkedList;
    }

    public HashMap getLinks() {
        return this.linkDescriptions;
    }

    public HashMap getFilters() {
        return this.filterDescriptions;
    }

    public HashMap getVariables() {
        return this.variableDescriptions;
    }

    public IPath getLocation() {
        if (this.location == null) {
            return null;
        }
        return FileUtil.toPath(this.location);
    }

    public URI getLocationURI() {
        return this.location;
    }

    public String[] getNatureIds() {
        return this.getNatureIds(true);
    }

    public String[] getNatureIds(boolean bl) {
        if (this.natures == null) {
            return EMPTY_STRING_ARRAY;
        }
        return bl ? (String[])this.natures.clone() : this.natures;
    }

    public IProject[] getReferencedProjects() {
        return this.getReferencedProjects(true);
    }

    public IProject[] getReferencedProjects(boolean bl) {
        if (this.staticRefs == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        return bl ? (IProject[])this.staticRefs.clone() : this.staticRefs;
    }

    public boolean hasNature(String string) {
        String[] stringArray = this.getNatureIds(false);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasPrivateChanges(ProjectDescription projectDescription) {
        if (!Arrays.equals(this.dynamicRefs, projectDescription.getDynamicReferences(false))) {
            return true;
        }
        IPath iPath = projectDescription.getLocation();
        if (this.location == null) {
            return iPath != null;
        }
        return !this.location.equals(iPath);
    }

    public boolean hasPublicChanges(ProjectDescription projectDescription) {
        if (!this.getName().equals(projectDescription.getName())) {
            return true;
        }
        if (!this.comment.equals(projectDescription.getComment())) {
            return true;
        }
        if (!Arrays.equals(this.buildSpec, projectDescription.getBuildSpec(false))) {
            return true;
        }
        if (!Arrays.equals(this.staticRefs, projectDescription.getReferencedProjects(false))) {
            return true;
        }
        if (!Arrays.equals(this.natures, projectDescription.getNatureIds(false))) {
            return true;
        }
        HashMap hashMap = projectDescription.getFilters();
        if (this.filterDescriptions == null && hashMap != null) {
            return hashMap != null;
        }
        if (this.filterDescriptions != null && !this.filterDescriptions.equals(hashMap)) {
            return true;
        }
        HashMap hashMap2 = projectDescription.getVariables();
        if (this.variableDescriptions == null && hashMap2 != null) {
            return true;
        }
        if (this.variableDescriptions != null && !this.variableDescriptions.equals(hashMap2)) {
            return true;
        }
        HashMap hashMap3 = projectDescription.getLinks();
        if (this.linkDescriptions == null) {
            return hashMap3 != null;
        }
        return !this.linkDescriptions.equals(hashMap3);
    }

    public ICommand newCommand() {
        return new BuildCommand();
    }

    public void setBuildSpec(ICommand[] iCommandArray) {
        Assert.isLegal((iCommandArray != null ? 1 : 0) != 0);
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length];
        int n = 0;
        while (n < iCommandArray2.length) {
            iCommandArray2[n] = (ICommand)((BuildCommand)iCommandArray[n]).clone();
            int n2 = 0;
            while (n2 < this.buildSpec.length) {
                if (iCommandArray2[n].equals(this.buildSpec[n2])) {
                    ((BuildCommand)iCommandArray2[n]).setBuilder(((BuildCommand)this.buildSpec[n2]).getBuilder());
                    break;
                }
                ++n2;
            }
            ++n;
        }
        this.buildSpec = iCommandArray2;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDynamicReferences(IProject[] iProjectArray) {
        Assert.isLegal((iProjectArray != null ? 1 : 0) != 0);
        this.dynamicRefs = this.copyAndRemoveDuplicates(iProjectArray);
        this.cachedRefs = null;
    }

    public void setLinkDescriptions(HashMap hashMap) {
        this.linkDescriptions = hashMap;
    }

    public void setFilterDescriptions(HashMap hashMap) {
        this.filterDescriptions = hashMap;
    }

    public void setVariableDescriptions(HashMap hashMap) {
        this.variableDescriptions = hashMap;
    }

    public boolean setLinkLocation(IPath iPath, LinkDescription linkDescription) {
        HashMap<Object, LinkDescription> hashMap = this.linkDescriptions;
        if (linkDescription != null) {
            LinkDescription linkDescription2 = (hashMap = hashMap == null ? new HashMap<IPath, LinkDescription>(10) : (HashMap)hashMap.clone()).put(iPath, linkDescription);
            if (linkDescription2 != null && linkDescription.equals(linkDescription2)) {
                return false;
            }
            this.linkDescriptions = hashMap;
        } else {
            if (hashMap == null) {
                return false;
            }
            HashMap hashMap2 = (HashMap)hashMap.clone();
            Object v = hashMap2.remove(iPath);
            if (v == null) {
                return false;
            }
            this.linkDescriptions = hashMap2.size() == 0 ? null : hashMap2;
        }
        return true;
    }

    public synchronized void addFilter(IPath iPath, FilterDescription filterDescription) {
        LinkedList<FilterDescription> linkedList;
        Assert.isNotNull((Object)filterDescription);
        if (this.filterDescriptions == null) {
            this.filterDescriptions = new HashMap(10);
        }
        if ((linkedList = (LinkedList<FilterDescription>)this.filterDescriptions.get(iPath)) == null) {
            linkedList = new LinkedList<FilterDescription>();
            this.filterDescriptions.put(iPath, linkedList);
        }
        linkedList.add(filterDescription);
    }

    public synchronized void removeFilter(IPath iPath, FilterDescription filterDescription) {
        LinkedList linkedList;
        if (this.filterDescriptions != null && (linkedList = (LinkedList)this.filterDescriptions.get(iPath)) != null) {
            linkedList.remove(filterDescription);
            if (linkedList.size() == 0) {
                this.filterDescriptions.remove(iPath);
                if (this.filterDescriptions.size() == 0) {
                    this.filterDescriptions = null;
                }
            }
        }
    }

    public boolean setVariableDescription(String string, VariableDescription variableDescription) {
        HashMap<String, VariableDescription> hashMap = this.variableDescriptions;
        if (variableDescription != null) {
            VariableDescription variableDescription2 = (hashMap = hashMap == null ? new HashMap<String, VariableDescription>(10) : (HashMap)hashMap.clone()).put(string, variableDescription);
            if (variableDescription2 != null && variableDescription.equals(variableDescription2)) {
                return false;
            }
            this.variableDescriptions = hashMap;
        } else {
            if (hashMap == null) {
                return false;
            }
            HashMap hashMap2 = (HashMap)hashMap.clone();
            Object v = hashMap2.remove(string);
            if (v == null) {
                return false;
            }
            this.variableDescriptions = hashMap2.size() == 0 ? null : hashMap2;
        }
        return true;
    }

    public synchronized boolean setFilters(IPath iPath, LinkedList linkedList) {
        if (linkedList != null) {
            LinkedList linkedList2;
            if (this.filterDescriptions == null) {
                this.filterDescriptions = new HashMap(10);
            }
            if ((linkedList2 = this.filterDescriptions.put(iPath, linkedList)) != null && linkedList.equals(linkedList2)) {
                return false;
            }
        } else {
            if (this.filterDescriptions == null) {
                return false;
            }
            Object v = this.filterDescriptions.remove(iPath);
            if (v == null) {
                return false;
            }
            if (this.filterDescriptions.size() == 0) {
                this.filterDescriptions = null;
            }
        }
        return true;
    }

    public void setLocation(IPath iPath) {
        this.location = iPath == null ? null : URIUtil.toURI((IPath)iPath);
    }

    public void setLocationURI(URI uRI) {
        this.location = uRI;
    }

    public void setName(String string) {
        super.setName(string);
    }

    public void setNatureIds(String[] stringArray) {
        this.natures = (String[])stringArray.clone();
    }

    public void setReferencedProjects(IProject[] iProjectArray) {
        Assert.isLegal((iProjectArray != null ? 1 : 0) != 0);
        this.staticRefs = this.copyAndRemoveDuplicates(iProjectArray);
        this.cachedRefs = null;
    }

    public URI getGroupLocationURI(IPath iPath) {
        return LinkDescription.GROUP_LOCATION;
    }
}

