/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.IModelObjectConstants;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectDescriptionReader
extends DefaultHandler
implements IModelObjectConstants {
    protected static final int S_BUILD_COMMAND = 0;
    protected static final int S_BUILD_COMMAND_ARGUMENTS = 1;
    protected static final int S_BUILD_COMMAND_NAME = 2;
    protected static final int S_BUILD_COMMAND_TRIGGERS = 3;
    protected static final int S_BUILD_SPEC = 4;
    protected static final int S_DICTIONARY = 5;
    protected static final int S_DICTIONARY_KEY = 6;
    protected static final int S_DICTIONARY_VALUE = 7;
    protected static final int S_INITIAL = 8;
    protected static final int S_LINK = 9;
    protected static final int S_LINK_LOCATION = 10;
    protected static final int S_LINK_LOCATION_URI = 11;
    protected static final int S_LINK_PATH = 12;
    protected static final int S_LINK_TYPE = 13;
    protected static final int S_LINKED_RESOURCES = 14;
    protected static final int S_NATURE_NAME = 15;
    protected static final int S_NATURES = 16;
    protected static final int S_PROJECT_COMMENT = 17;
    protected static final int S_PROJECT_DESC = 18;
    protected static final int S_PROJECT_NAME = 19;
    protected static final int S_PROJECTS = 20;
    protected static final int S_REFERENCED_PROJECT_NAME = 21;
    protected static final int S_FILTER = 22;
    protected static final int S_FILTER_ID = 23;
    protected static final int S_FILTER_ARGUMENTS = 24;
    protected static final int S_FILTER_PATH = 25;
    protected static final int S_FILTER_TYPE = 26;
    protected static final int S_FILTERED_RESOURCES = 27;
    protected static final int S_VARIABLE_LIST = 31;
    protected static final int S_VARIABLE = 32;
    protected static final int S_VARIABLE_NAME = 33;
    protected static final int S_VARIABLE_VALUE = 34;
    private static SAXParserFactory singletonParserFactory;
    private static SAXParser singletonParser;
    protected final StringBuffer charBuffer = new StringBuffer();
    protected Stack objectStack;
    protected MultiStatus problems;
    private final IProject project;
    ProjectDescription projectDescription = null;
    protected int state = 8;

    private static synchronized SAXParser createParser() throws ParserConfigurationException, SAXException {
        if (!ProjectDescriptionReader.isWorkspaceLocked()) {
            return ProjectDescriptionReader.createParserFactory().newSAXParser();
        }
        if (singletonParser == null) {
            singletonParser = ProjectDescriptionReader.createParserFactory().newSAXParser();
        }
        return singletonParser;
    }

    private static synchronized SAXParserFactory createParserFactory() throws ParserConfigurationException {
        if (singletonParserFactory == null) {
            singletonParserFactory = SAXParserFactory.newInstance();
            singletonParserFactory.setNamespaceAware(true);
            try {
                singletonParserFactory.setFeature("http://xml.org/sax/features/string-interning", true);
            }
            catch (SAXException sAXException) {}
        }
        return singletonParserFactory;
    }

    private static boolean isWorkspaceLocked() {
        try {
            return ((Workspace)ResourcesPlugin.getWorkspace()).getWorkManager().isLockAlreadyAcquired();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public ProjectDescriptionReader() {
        this.project = null;
    }

    public ProjectDescriptionReader(IProject iProject) {
        this.project = iProject;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.charBuffer.append(cArray, n, n2);
    }

    private void endBuildCommandElement(String string) {
        if (string.equals("buildCommand")) {
            BuildCommand buildCommand = (BuildCommand)this.objectStack.pop();
            ArrayList arrayList = (ArrayList)this.objectStack.peek();
            arrayList.add(buildCommand);
            this.state = 4;
        }
    }

    private void endBuildSpecElement(String string) {
        if (string.equals("buildSpec")) {
            ArrayList arrayList = (ArrayList)this.objectStack.pop();
            this.state = 18;
            if (arrayList.isEmpty()) {
                return;
            }
            ICommand[] iCommandArray = arrayList.toArray(new ICommand[arrayList.size()]);
            this.projectDescription.setBuildSpec(iCommandArray);
        }
    }

    private void endBuildTriggersElement(String string) {
        if (string.equals("triggers")) {
            this.state = 0;
            BuildCommand buildCommand = (BuildCommand)this.objectStack.peek();
            buildCommand.setConfigurable(true);
            buildCommand.setBuilding(9, false);
            buildCommand.setBuilding(15, false);
            buildCommand.setBuilding(6, false);
            buildCommand.setBuilding(10, false);
            StringTokenizer stringTokenizer = new StringTokenizer(this.charBuffer.toString(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.toLowerCase().equals("auto")) {
                    buildCommand.setBuilding(9, true);
                    continue;
                }
                if (string2.toLowerCase().equals("clean")) {
                    buildCommand.setBuilding(15, true);
                    continue;
                }
                if (string2.toLowerCase().equals("full")) {
                    buildCommand.setBuilding(6, true);
                    continue;
                }
                if (!string2.toLowerCase().equals("incremental")) continue;
                buildCommand.setBuilding(10, true);
            }
        }
    }

    private void endDictionary(String string) {
        if (string.equals("dictionary")) {
            String string2 = (String)this.objectStack.pop();
            String string3 = (String)this.objectStack.pop();
            ((HashMap)this.objectStack.peek()).put(string3, string2);
            this.state = 1;
        }
    }

    private void endDictionaryKey(String string) {
        if (string.equals("key")) {
            String string2 = (String)this.objectStack.pop();
            String string3 = (String)this.objectStack.pop();
            String string4 = this.charBuffer.toString();
            if (string3 != null && string3.length() != 0) {
                this.parseProblem(NLS.bind((String)Messages.projRead_whichKey, (Object)string3, (Object)string4));
                this.objectStack.push(string3);
            } else {
                this.objectStack.push(string4);
            }
            this.objectStack.push(string2);
            this.state = 5;
        }
    }

    private void endDictionaryValue(String string) {
        if (string.equals("value")) {
            String string2 = this.charBuffer.toString();
            String string3 = (String)this.objectStack.pop();
            if (string3 != null && string3.length() != 0) {
                this.parseProblem(NLS.bind((String)Messages.projRead_whichValue, (Object)string3, (Object)string2));
                this.objectStack.push(string3);
            } else {
                this.objectStack.push(string2);
            }
            this.state = 5;
        }
    }

    public void endElement(String string, String string2, String string3) {
        switch (this.state) {
            case 18: {
                break;
            }
            case 19: {
                if (!string2.equals("name")) break;
                this.projectDescription.setName(this.charBuffer.toString().trim());
                this.state = 18;
                break;
            }
            case 20: {
                if (!string2.equals("projects")) break;
                this.endProjectsElement(string2);
                this.state = 18;
                break;
            }
            case 5: {
                this.endDictionary(string2);
                break;
            }
            case 1: {
                if (!string2.equals("arguments")) break;
                HashMap hashMap = (HashMap)this.objectStack.pop();
                this.state = 0;
                if (hashMap.isEmpty()) break;
                ((BuildCommand)this.objectStack.peek()).setArguments(hashMap);
                break;
            }
            case 0: {
                this.endBuildCommandElement(string2);
                break;
            }
            case 4: {
                this.endBuildSpecElement(string2);
                break;
            }
            case 3: {
                this.endBuildTriggersElement(string2);
                break;
            }
            case 16: {
                this.endNaturesElement(string2);
                break;
            }
            case 9: {
                this.endLinkElement(string2);
                break;
            }
            case 14: {
                this.endLinkedResourcesElement(string2);
                break;
            }
            case 32: {
                this.endVariableElement(string2);
                break;
            }
            case 22: {
                this.endFilterElement(string2);
                break;
            }
            case 27: {
                this.endFilteredResourcesElement(string2);
                break;
            }
            case 31: {
                this.endVariableListElement(string2);
                break;
            }
            case 17: {
                if (!string2.equals("comment")) break;
                this.projectDescription.setComment(this.charBuffer.toString());
                this.state = 18;
                break;
            }
            case 21: {
                if (!string2.equals("project")) break;
                ((ArrayList)this.objectStack.peek()).add(this.charBuffer.toString().trim());
                this.state = 20;
                break;
            }
            case 2: {
                if (!string2.equals("name")) break;
                ((BuildCommand)this.objectStack.peek()).setName(this.charBuffer.toString().trim());
                this.state = 0;
                break;
            }
            case 6: {
                this.endDictionaryKey(string2);
                break;
            }
            case 7: {
                this.endDictionaryValue(string2);
                break;
            }
            case 15: {
                if (!string2.equals("nature")) break;
                ((ArrayList)this.objectStack.peek()).add(this.charBuffer.toString().trim());
                this.state = 16;
                break;
            }
            case 12: {
                this.endLinkPath(string2);
                break;
            }
            case 13: {
                this.endLinkType(string2);
                break;
            }
            case 10: {
                this.endLinkLocation(string2);
                break;
            }
            case 11: {
                this.endLinkLocationURI(string2);
                break;
            }
            case 25: {
                this.endFilterPath(string2);
                break;
            }
            case 26: {
                this.endFilterType(string2);
                break;
            }
            case 23: {
                this.endFilterID(string2);
                break;
            }
            case 24: {
                this.endFilterArguments(string2);
                break;
            }
            case 33: {
                this.endVariableName(string2);
                break;
            }
            case 34: {
                this.endVariableValue(string2);
            }
        }
        this.charBuffer.setLength(0);
    }

    private void endLinkedResourcesElement(String string) {
        if (string.equals("linkedResources")) {
            HashMap hashMap = (HashMap)this.objectStack.pop();
            this.state = 18;
            if (hashMap.isEmpty()) {
                return;
            }
            this.projectDescription.setLinkDescriptions(hashMap);
        }
    }

    private void endFilteredResourcesElement(String string) {
        if (string.equals("filteredResources")) {
            HashMap hashMap = (HashMap)this.objectStack.pop();
            this.state = 18;
            if (hashMap.isEmpty()) {
                return;
            }
            this.projectDescription.setFilterDescriptions(hashMap);
        }
    }

    private void endVariableListElement(String string) {
        if (string.equals("variableList")) {
            HashMap hashMap = (HashMap)this.objectStack.pop();
            this.state = 18;
            if (hashMap.isEmpty()) {
                return;
            }
            this.projectDescription.setVariableDescriptions(hashMap);
        }
    }

    private void endLinkElement(String string) {
        if (string.equals("link")) {
            this.state = 14;
            LinkDescription linkDescription = (LinkDescription)this.objectStack.pop();
            IPath iPath = linkDescription.getProjectRelativePath();
            int n = linkDescription.getType();
            URI uRI = linkDescription.getLocationURI();
            if (uRI == null) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badLinkLocation, (Object)iPath, (Object)Integer.toString(n)));
                return;
            }
            if (iPath == null || iPath.segmentCount() == 0) {
                this.parseProblem(NLS.bind((String)Messages.projRead_emptyLinkName, (Object)Integer.toString(n), (Object)uRI));
                return;
            }
            if (n == -1) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badLinkType, (Object)iPath, (Object)uRI));
                return;
            }
            ((HashMap)this.objectStack.peek()).put(linkDescription.getProjectRelativePath(), linkDescription);
        }
    }

    private void endFilterElement(String string) {
        if (string.equals("filter")) {
            this.state = 27;
            FilterDescription filterDescription = (FilterDescription)this.objectStack.pop();
            IPath iPath = filterDescription.getProjectRelativePath();
            int n = filterDescription.getType();
            String string2 = filterDescription.getFilterID();
            if (string2 == null) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badFilterID, (Object)iPath, (Object)Integer.toString(n)));
                return;
            }
            if (iPath == null) {
                this.parseProblem(NLS.bind((String)Messages.projRead_emptyFilterName, (Object)Integer.toString(n), (Object)string2));
                return;
            }
            if (n == -1) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badFilterType, (Object)iPath, (Object)string2));
                return;
            }
            HashMap hashMap = (HashMap)this.objectStack.peek();
            LinkedList<FilterDescription> linkedList = (LinkedList<FilterDescription>)hashMap.get(filterDescription.getProjectRelativePath());
            if (linkedList == null) {
                linkedList = new LinkedList<FilterDescription>();
                hashMap.put(filterDescription.getProjectRelativePath(), linkedList);
            }
            linkedList.add(filterDescription);
        }
    }

    private void endVariableElement(String string) {
        if (string.equals("variable")) {
            this.state = 31;
            VariableDescription variableDescription = (VariableDescription)this.objectStack.pop();
            if (variableDescription.getName().length() == 0) {
                this.parseProblem(NLS.bind((String)Messages.projRead_emptyVariableName, (Object)this.project.getName()));
                return;
            }
            ((HashMap)this.objectStack.peek()).put(variableDescription.getName(), variableDescription);
        }
    }

    private void endLinkLocation(String string) {
        if (string.equals("location")) {
            String string2 = this.charBuffer.toString().trim();
            URI uRI = ((LinkDescription)this.objectStack.peek()).getLocationURI();
            if (uRI != null) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badLocation, (Object)uRI, (Object)string2));
            } else {
                ((LinkDescription)this.objectStack.peek()).setLocationURI(URIUtil.toURI((IPath)Path.fromPortableString((String)string2)));
            }
            this.state = 9;
        }
    }

    private void endLinkLocationURI(String string) {
        if (string.equals("locationURI")) {
            String string2 = this.charBuffer.toString().trim();
            URI uRI = ((LinkDescription)this.objectStack.peek()).getLocationURI();
            if (uRI != null) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badLocation, (Object)uRI, (Object)string2));
            } else {
                try {
                    ((LinkDescription)this.objectStack.peek()).setLocationURI(new URI(string2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    String string3 = Messages.projRead_failureReadingProjectDesc;
                    this.problems.add((IStatus)new Status(2, "org.eclipse.core.resources", 567, string3, (Throwable)uRISyntaxException));
                }
            }
            this.state = 9;
        }
    }

    private void endLinkPath(String string) {
        if (string.equals("name")) {
            Path path = new Path(this.charBuffer.toString());
            IPath iPath = ((LinkDescription)this.objectStack.peek()).getProjectRelativePath();
            if (iPath.segmentCount() != 0) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badLinkName, (Object)iPath, (Object)path));
            } else {
                ((LinkDescription)this.objectStack.peek()).setPath((IPath)path);
            }
            this.state = 9;
        }
    }

    private void endFilterID(String string) {
        if (string.equals("id")) {
            String string2 = this.charBuffer.toString().trim();
            String string3 = ((FilterDescription)this.objectStack.peek()).getFilterID();
            if (string3 != null) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badID, (Object)string3, (Object)string2));
            } else {
                ((FilterDescription)this.objectStack.peek()).setFilterID(string2);
            }
            this.state = 22;
        }
    }

    private void endFilterArguments(String string) {
        if (string.equals("arguments")) {
            String string2 = this.charBuffer.toString();
            String string3 = ((FilterDescription)this.objectStack.peek()).getArguments();
            if (string3 != null) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badArguments, (Object)string3, (Object)string2));
            } else {
                ((FilterDescription)this.objectStack.peek()).setArguments(string2);
            }
            this.state = 22;
        }
    }

    private void endFilterPath(String string) {
        if (string.equals("name")) {
            Path path = new Path(this.charBuffer.toString());
            IPath iPath = ((FilterDescription)this.objectStack.peek()).getProjectRelativePath();
            if (iPath.segmentCount() != 0) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badFilterName, (Object)iPath, (Object)path));
            } else {
                ((FilterDescription)this.objectStack.peek()).setPath((IPath)path);
            }
            this.state = 22;
        }
    }

    private void endFilterType(String string) {
        if (string.equals("type")) {
            int n = -1;
            try {
                n = Integer.parseInt(this.charBuffer.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.log(numberFormatException);
            }
            int n2 = ((FilterDescription)this.objectStack.peek()).getType();
            if (n2 != -1) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badFilterType2, (Object)Integer.toString(n2), (Object)Integer.toString(n)));
            } else {
                ((FilterDescription)this.objectStack.peek()).setType(n);
            }
            this.state = 22;
        }
    }

    private void endVariableName(String string) {
        if (string.equals("name")) {
            String string2 = this.charBuffer.toString();
            ((VariableDescription)this.objectStack.peek()).setName(string2);
            this.state = 32;
        }
    }

    private void endVariableValue(String string) {
        if (string.equals("value")) {
            String string2 = this.charBuffer.toString();
            ((VariableDescription)this.objectStack.peek()).setValue(string2);
            this.state = 32;
        }
    }

    private void endLinkType(String string) {
        if (string.equals("type")) {
            int n = 1;
            try {
                n = Integer.parseInt(this.charBuffer.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.log(numberFormatException);
            }
            int n2 = ((LinkDescription)this.objectStack.peek()).getType();
            if (n2 != -1) {
                this.parseProblem(NLS.bind((String)Messages.projRead_badLinkType2, (Object)Integer.toString(n2), (Object)Integer.toString(n)));
            } else {
                ((LinkDescription)this.objectStack.peek()).setType(n);
            }
            this.state = 9;
        }
    }

    private void endNaturesElement(String string) {
        if (string.equals("natures")) {
            ArrayList arrayList = (ArrayList)this.objectStack.pop();
            this.state = 18;
            if (arrayList.size() == 0) {
                return;
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            this.projectDescription.setNatureIds(stringArray);
        }
    }

    private void endProjectsElement(String string) {
        ArrayList arrayList = (ArrayList)this.objectStack.pop();
        if (arrayList.size() == 0) {
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = new IProject[arrayList.size()];
        int n = 0;
        while (n < iProjectArray.length) {
            iProjectArray[n] = iWorkspaceRoot.getProject((String)arrayList.get(n));
            ++n;
        }
        this.projectDescription.setReferencedProjects(iProjectArray);
    }

    public void error(SAXParseException sAXParseException) {
        this.log(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        if (this.project != null) {
            string = NLS.bind((String)Messages.resources_readMeta, (Object)this.project.getName());
        }
        this.problems.add((IStatus)new Status(4, "org.eclipse.core.resources", 567, string == null ? "" : string, (Throwable)sAXParseException));
        throw sAXParseException;
    }

    protected void log(Exception exception) {
        String string = exception.getMessage();
        if (this.project != null) {
            string = NLS.bind((String)Messages.resources_readMeta, (Object)this.project.getName());
        }
        this.problems.add((IStatus)new Status(2, "org.eclipse.core.resources", 567, string == null ? "" : string, (Throwable)exception));
    }

    private void parseProblem(String string) {
        this.problems.add((IStatus)new Status(2, "org.eclipse.core.resources", 567, string, null));
    }

    private void parseProjectDescription(String string) {
        if (string.equals("name")) {
            this.state = 19;
            return;
        }
        if (string.equals("comment")) {
            this.state = 17;
            return;
        }
        if (string.equals("projects")) {
            this.state = 20;
            this.objectStack.push(new ArrayList());
            return;
        }
        if (string.equals("buildSpec")) {
            this.state = 4;
            this.objectStack.push(new ArrayList());
            return;
        }
        if (string.equals("natures")) {
            this.state = 16;
            this.objectStack.push(new ArrayList());
            return;
        }
        if (string.equals("linkedResources")) {
            this.objectStack.push(new HashMap());
            this.state = 14;
            return;
        }
        if (string.equals("filteredResources")) {
            this.objectStack.push(new HashMap());
            this.state = 27;
            return;
        }
        if (string.equals("variableList")) {
            this.objectStack.push(new HashMap());
            this.state = 31;
            return;
        }
    }

    public ProjectDescription read(InputSource inputSource) {
        this.problems = new MultiStatus("org.eclipse.core.resources", 567, Messages.projRead_failureReadingProjectDesc, null);
        this.objectStack = new Stack();
        this.state = 8;
        try {
            ProjectDescriptionReader.createParser().parse(inputSource, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log(parserConfigurationException);
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
        catch (SAXException sAXException) {
            this.log(sAXException);
        }
        switch (this.problems.getSeverity()) {
            case 4: {
                Policy.log((IStatus)this.problems);
                return null;
            }
            case 1: 
            case 2: {
                Policy.log((IStatus)this.problems);
            }
        }
        return this.projectDescription;
    }

    public ProjectDescription read(IPath iPath) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(iPath.toFile()));
            ProjectDescription projectDescription = this.read(new InputSource(bufferedInputStream));
            return projectDescription;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public ProjectDescription read(IPath iPath, IPath iPath2) throws IOException {
        SafeFileInputStream safeFileInputStream = new SafeFileInputStream(iPath.toOSString(), iPath2.toOSString());
        try {
            ProjectDescription projectDescription = this.read(new InputSource(safeFileInputStream));
            return projectDescription;
        }
        finally {
            safeFileInputStream.close();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.charBuffer.setLength(0);
        switch (this.state) {
            case 8: {
                if (string2.equals("projectDescription")) {
                    this.state = 18;
                    this.projectDescription = new ProjectDescription();
                    break;
                }
                throw new SAXException(NLS.bind((String)Messages.projRead_notProjectDescription, (Object)string2));
            }
            case 18: {
                this.parseProjectDescription(string2);
                break;
            }
            case 20: {
                if (!string2.equals("project")) break;
                this.state = 21;
                break;
            }
            case 4: {
                if (!string2.equals("buildCommand")) break;
                this.state = 0;
                this.objectStack.push(new BuildCommand());
                break;
            }
            case 0: {
                if (string2.equals("name")) {
                    this.state = 2;
                    break;
                }
                if (string2.equals("triggers")) {
                    this.state = 3;
                    break;
                }
                if (!string2.equals("arguments")) break;
                this.state = 1;
                this.objectStack.push(new HashMap());
                break;
            }
            case 1: {
                if (!string2.equals("dictionary")) break;
                this.state = 5;
                this.objectStack.push(new String());
                this.objectStack.push(new String());
                break;
            }
            case 5: {
                if (string2.equals("key")) {
                    this.state = 6;
                    break;
                }
                if (!string2.equals("value")) break;
                this.state = 7;
                break;
            }
            case 16: {
                if (!string2.equals("nature")) break;
                this.state = 15;
                break;
            }
            case 14: {
                if (!string2.equals("link")) break;
                this.state = 9;
                this.objectStack.push(new LinkDescription());
                break;
            }
            case 31: {
                if (!string2.equals("variable")) break;
                this.state = 32;
                this.objectStack.push(new VariableDescription());
                break;
            }
            case 9: {
                if (string2.equals("name")) {
                    this.state = 12;
                    break;
                }
                if (string2.equals("type")) {
                    this.state = 13;
                    break;
                }
                if (string2.equals("location")) {
                    this.state = 10;
                    break;
                }
                if (!string2.equals("locationURI")) break;
                this.state = 11;
                break;
            }
            case 27: {
                if (!string2.equals("filter")) break;
                this.state = 22;
                this.objectStack.push(new FilterDescription());
                break;
            }
            case 22: {
                if (string2.equals("name")) {
                    this.state = 25;
                    break;
                }
                if (string2.equals("type")) {
                    this.state = 26;
                    break;
                }
                if (string2.equals("id")) {
                    this.state = 23;
                    break;
                }
                if (!string2.equals("arguments")) break;
                this.state = 24;
                break;
            }
            case 32: {
                if (string2.equals("name")) {
                    this.state = 33;
                    break;
                }
                if (!string2.equals("value")) break;
                this.state = 34;
            }
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.log(sAXParseException);
    }
}

