/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashMap;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.content.IContentTypeMatcher;

public class ProjectInfo
extends ResourceInfo {
    protected ProjectDescription description = null;
    protected HashMap natures = null;
    protected Object propertyStore = null;
    protected IContentTypeMatcher matcher = null;

    public synchronized void fixupAfterMove() {
        this.natures = null;
        this.propertyStore = null;
        if (this.description != null) {
            ICommand[] iCommandArray = this.description.getBuildSpec(false);
            int n = 0;
            while (n < iCommandArray.length) {
                ((BuildCommand)iCommandArray[n]).setBuilder(null);
                ++n;
            }
        }
    }

    public ProjectDescription getDescription() {
        return this.description;
    }

    public IContentTypeMatcher getMatcher() {
        return this.matcher;
    }

    public IProjectNature getNature(String string) {
        HashMap hashMap = this.natures;
        if (hashMap == null) {
            return null;
        }
        return (IProjectNature)hashMap.get(string);
    }

    public Object getPropertyStore() {
        return this.propertyStore;
    }

    public void setDescription(ProjectDescription projectDescription) {
        if (this.description != null) {
            ICommand[] iCommandArray = this.description.buildSpec;
            ICommand[] iCommandArray2 = projectDescription.buildSpec;
            projectDescription.buildSpec = iCommandArray;
            projectDescription.setBuildSpec(iCommandArray2);
        }
        this.description = projectDescription;
    }

    public void setMatcher(IContentTypeMatcher iContentTypeMatcher) {
        this.matcher = iContentTypeMatcher;
    }

    public synchronized void setNature(String string, IProjectNature iProjectNature) {
        if (iProjectNature == null) {
            if (this.natures == null) {
                return;
            }
            HashMap hashMap = (HashMap)this.natures.clone();
            hashMap.remove(string);
            this.natures = hashMap.isEmpty() ? null : hashMap;
        } else {
            HashMap hashMap = this.natures;
            hashMap = hashMap == null ? new HashMap(5) : (HashMap)this.natures.clone();
            hashMap.put(string, iProjectNature);
            this.natures = hashMap;
        }
    }

    public void setPropertyStore(Object object) {
        this.propertyStore = object;
    }
}

