/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectNatureDescriptor
implements IProjectNatureDescriptor {
    protected String id;
    protected String label;
    protected String[] requiredNatures;
    protected String[] natureSets;
    protected String[] builderIds;
    protected String[] contentTypeIds;
    protected boolean allowLinking = true;
    protected boolean hasCycle = false;
    protected byte colour = 0;

    protected ProjectNatureDescriptor(IExtension iExtension) throws CoreException {
        this.readExtension(iExtension);
    }

    protected void fail() throws CoreException {
        this.fail(NLS.bind((String)Messages.natures_invalidDefinition, (Object)this.id));
    }

    protected void fail(String string) throws CoreException {
        throw new ResourceException((IStatus)new Status(4, "org.eclipse.core.resources", 1, string, null));
    }

    public String[] getBuilderIds() {
        return this.builderIds;
    }

    public String[] getContentTypeIds() {
        return this.contentTypeIds;
    }

    public String getNatureId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getRequiredNatureIds() {
        return this.requiredNatures;
    }

    public String[] getNatureSetIds() {
        return this.natureSets;
    }

    public boolean isLinkingAllowed() {
        return this.allowLinking;
    }

    protected void readExtension(IExtension iExtension) throws CoreException {
        this.id = iExtension.getUniqueIdentifier();
        if (this.id == null) {
            this.fail(Messages.natures_missingIdentifier);
        }
        this.label = iExtension.getLabel();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        ArrayList<String> arrayList3 = new ArrayList<String>(n);
        ArrayList<String> arrayList4 = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string2 = iConfigurationElement.getName();
            if (string2.equalsIgnoreCase("requires-nature")) {
                string = iConfigurationElement.getAttribute("id");
                if (string == null) {
                    this.fail();
                }
                arrayList.add(string);
            } else if (string2.equalsIgnoreCase("one-of-nature")) {
                string = iConfigurationElement.getAttribute("id");
                if (string == null) {
                    this.fail();
                }
                arrayList2.add(string);
            } else if (string2.equalsIgnoreCase("builder")) {
                string = iConfigurationElement.getAttribute("id");
                if (string == null) {
                    this.fail();
                }
                arrayList3.add(string);
            } else if (string2.equalsIgnoreCase("content-type")) {
                string = iConfigurationElement.getAttribute("id");
                if (string == null) {
                    this.fail();
                }
                arrayList4.add(string);
            } else if (string2.equalsIgnoreCase("options")) {
                string = iConfigurationElement.getAttribute("allowLinking");
                this.allowLinking = !Boolean.FALSE.toString().equalsIgnoreCase(string);
            }
            ++n2;
        }
        this.requiredNatures = arrayList.toArray(new String[arrayList.size()]);
        this.natureSets = arrayList2.toArray(new String[arrayList2.size()]);
        this.builderIds = arrayList3.toArray(new String[arrayList3.size()]);
        this.contentTypeIds = arrayList4.toArray(new String[arrayList4.size()]);
    }

    public String toString() {
        return "ProjectNatureDescriptor(" + this.id + ")";
    }
}

