/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.PathVariableChangeEvent;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.PathVariableManager;
import org.eclipse.core.internal.resources.PathVariableUtil;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ProjectVariableProviderManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectPathVariableManager
implements IPathVariableManager,
IManager {
    private Set listeners = Collections.synchronizedSet(new HashSet());
    private Project project;
    private ProjectVariableProviderManager.Descriptor[] variableProviders = null;

    public ProjectPathVariableManager(Project project) {
        this.project = project;
        this.variableProviders = ProjectVariableProviderManager.getDefault().getDescriptors();
    }

    public void addChangeListener(IPathVariableChangeListener iPathVariableChangeListener) {
        this.listeners.add(iPathVariableChangeListener);
    }

    PathVariableManager getWorkspaceManager() {
        return (PathVariableManager)this.project.getWorkspace().getPathVariableManager();
    }

    private void checkIsValidName(String string) throws CoreException {
        IStatus iStatus = this.validateName(string);
        if (!iStatus.isOK()) {
            throw new CoreException(iStatus);
        }
    }

    private void checkIsValidValue(IPath iPath) throws CoreException {
        IStatus iStatus = this.validateValue(iPath);
        if (!iStatus.isOK()) {
            throw new CoreException(iStatus);
        }
    }

    private void fireVariableChangeEvent(String string, IPath iPath, int n) {
        if (this.listeners.size() == 0) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        final PathVariableChangeEvent pathVariableChangeEvent = new PathVariableChangeEvent(this, string, iPath, n);
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IPathVariableChangeListener iPathVariableChangeListener = (IPathVariableChangeListener)objectArray[n2];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() throws Exception {
                    iPathVariableChangeListener.pathVariableChanged(pathVariableChangeEvent);
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n2;
        }
    }

    public String[] getPathVariableNames() {
        HashMap hashMap;
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            hashMap = ((ProjectDescription)this.project.getDescription()).getVariables();
        }
        catch (CoreException coreException) {
            return new String[0];
        }
        int n = 0;
        while (n < this.variableProviders.length) {
            linkedList.add(this.variableProviders[n].getName());
            ++n;
        }
        if (hashMap != null) {
            linkedList.addAll(hashMap.keySet());
        }
        linkedList.addAll(Arrays.asList(this.getWorkspaceManager().getPathVariableNames()));
        return linkedList.toArray(new String[0]);
    }

    public IPath getValue(String string) {
        String string2 = this.internalGetValue(string);
        if (string2 != null) {
            IPath iPath;
            int n;
            if (string2.indexOf("..") != -1 && (n = string2.indexOf(47)) > 0 && (iPath = this.resolveVariable(string2)) != null) {
                return iPath;
            }
            return Path.fromPortableString((String)string2);
        }
        return this.getWorkspaceManager().getValue(string);
    }

    public String internalGetValue(String string) {
        HashMap hashMap;
        try {
            hashMap = ((ProjectDescription)this.project.getDescription()).getVariables();
        }
        catch (CoreException coreException) {
            return null;
        }
        if (hashMap != null && hashMap.containsKey(string)) {
            return ((VariableDescription)hashMap.get(string)).getValue();
        }
        int n = string.indexOf(45);
        String string2 = n != -1 ? string.substring(0, n) : string;
        int n2 = 0;
        while (n2 < this.variableProviders.length) {
            if (this.variableProviders[n2].getName().equals(string2)) {
                return this.variableProviders[n2].getValue(string, this.project);
            }
            ++n2;
        }
        return null;
    }

    public boolean isDefined(String string) {
        return this.getValue(string) != null;
    }

    public void removeChangeListener(IPathVariableChangeListener iPathVariableChangeListener) {
        this.listeners.remove(iPathVariableChangeListener);
    }

    public IPath resolvePath(IPath iPath) {
        if (iPath == null || iPath.segmentCount() == 0 || iPath.isAbsolute() || iPath.getDevice() != null) {
            return iPath;
        }
        IPath iPath2 = this.resolveVariable(iPath.segment(0));
        return iPath2 == null ? iPath : iPath2.append(iPath.removeFirstSegments(1));
    }

    public IPath resolveVariable(String string) {
        LinkedList linkedList = new LinkedList();
        String string2 = this.resolveVariable(string, linkedList);
        if (string2 != null) {
            return Path.fromPortableString((String)string2);
        }
        return null;
    }

    public static String[] splitVariablesAndContent(String string) {
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((n = string.indexOf("${")) != -1) {
            int n2 = ProjectPathVariableManager.getMatchingBrace(string, n);
            if (n > 0) {
                linkedList.add(string.substring(0, n));
            }
            linkedList.add(string.substring(n, n2 + 1));
            string = string.substring(n2 + 1);
        }
        if (string.length() > 0) {
            linkedList.add(string);
        }
        return linkedList.toArray(new String[0]);
    }

    public static String[] splitVariableNames(String string) {
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((n = string.indexOf("${")) != -1) {
            int n2 = ProjectPathVariableManager.getMatchingBrace(string, n);
            linkedList.add(string.substring(n + 2, n2));
            string = string.substring(n2 + 1);
        }
        return linkedList.toArray(new String[0]);
    }

    public static String extractVariable(String string) {
        int n = string.indexOf("${");
        if (n != -1) {
            int n2 = ProjectPathVariableManager.getMatchingBrace(string, n);
            return string.substring(n + 2, n2);
        }
        return "";
    }

    public String resolveVariable(String string, LinkedList linkedList) {
        int n;
        String string2;
        if (linkedList == null) {
            linkedList = new LinkedList<String>();
        }
        if ((string2 = this.internalGetValue(string)) == null) {
            IPath iPath = this.getWorkspaceManager().getValue(string);
            if (iPath != null) {
                return iPath.toPortableString();
            }
        } else {
            string = string2;
        }
        while ((n = string.indexOf("${")) != -1) {
            int n2 = ProjectPathVariableManager.getMatchingBrace(string, n);
            String string3 = string.substring(n + 2, n2);
            String string4 = "";
            if (!linkedList.contains(string3)) {
                linkedList.add(string3);
                string4 = this.resolveVariable(string3, linkedList);
                if (string4 == null) {
                    string4 = "";
                }
            }
            if (string.length() > n2) {
                string = String.valueOf(string.substring(0, n)) + string4 + string.substring(n2 + 1);
                continue;
            }
            string = string4;
        }
        return string;
    }

    static int getMatchingBrace(String string, int n) {
        int n2 = 0;
        int n3 = n + 1;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '}') {
                if (n2 == 0) {
                    return n3;
                }
                --n2;
            }
            if (c == '$' && n3 + 1 < string.length() && string.charAt(n3 + 1) == '{') {
                ++n2;
            }
            ++n3;
        }
        return string.length();
    }

    public URI resolveURI(URI uRI) {
        IPath iPath;
        if (uRI == null || uRI.isAbsolute() || uRI.getSchemeSpecificPart() == null) {
            return uRI;
        }
        Path path = new Path(uRI.getSchemeSpecificPart());
        return path == (iPath = this.resolvePath((IPath)path)) ? uRI : URIUtil.toURI((IPath)iPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String string, IPath iPath) throws CoreException {
        this.checkIsValidName(string);
        if (iPath != null && iPath.isAbsolute() && iPath.getDevice() == null) {
            iPath = new Path(iPath.toFile().getAbsolutePath());
        }
        this.checkIsValidValue(iPath);
        int n = 0;
        boolean bl = false;
        ProjectPathVariableManager projectPathVariableManager = this;
        synchronized (projectPathVariableManager) {
            boolean bl2;
            String string2 = this.internalGetValue(string);
            IPath iPath2 = null;
            iPath2 = string2 == null ? this.getWorkspaceManager().getValue(string) : Path.fromPortableString((String)string2);
            boolean bl3 = bl2 = iPath2 != null;
            if (!bl2 && iPath == null) {
                return;
            }
            if (bl2 && iPath2.equals((Object)iPath)) {
                return;
            }
            int n2 = 0;
            while (n2 < this.variableProviders.length) {
                if (this.variableProviders[n2].getName().equals(string)) {
                    return;
                }
                ++n2;
            }
            if (string2 == null && bl2) {
                bl = true;
            } else {
                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                Project project = this.project;
                try {
                    this.project.workspace.prepareOperation(project, (IProgressMonitor)nullProgressMonitor);
                    this.project.workspace.beginOperation(true);
                    ProjectDescription projectDescription = this.project.internalGetDescription();
                    if (iPath == null) {
                        projectDescription.setVariableDescription(string, null);
                        n = 3;
                    } else {
                        projectDescription.setVariableDescription(string, new VariableDescription(string, iPath.toPortableString()));
                        n = bl2 ? 1 : 2;
                    }
                    this.project.writeDescription(0);
                }
                finally {
                    this.project.workspace.endOperation(project, true, Policy.subMonitorFor((IProgressMonitor)nullProgressMonitor, Policy.endOpWork));
                }
            }
        }
        if (!bl) {
            this.fireVariableChangeEvent(string, iPath, n);
        } else {
            this.getWorkspaceManager().setValue(string, iPath);
        }
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
    }

    public void startup(IProgressMonitor iProgressMonitor) {
    }

    public IStatus validateName(String string) {
        String string2 = null;
        if (string.length() == 0) {
            string2 = Messages.pathvar_length;
            return new ResourceStatus(77, null, string2);
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            string2 = NLS.bind((String)Messages.pathvar_beginLetter, (Object)String.valueOf(c));
            return new ResourceStatus(77, null, string2);
        }
        int n = 1;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (Character.isWhitespace(c2)) {
                return new ResourceStatus(77, null, Messages.pathvar_whitespace);
            }
            if (!Character.isLetter(c2) && !Character.isDigit(c2) && c2 != '_') {
                string2 = NLS.bind((String)Messages.pathvar_invalidChar, (Object)String.valueOf(c2));
                return new ResourceStatus(77, null, string2);
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateValue(IPath iPath) {
        return Status.OK_STATUS;
    }

    public IPath convertToRelative(IPath iPath, boolean bl, String string) throws CoreException {
        return PathVariableUtil.convertToRelative(this, iPath, bl, string);
    }
}

