/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferences
extends EclipsePreferences {
    protected static Set loadedNodes = new HashSet();
    private IFile file;
    private boolean initialized = false;
    private boolean isReading;
    private boolean isWriting;
    private IEclipsePreferences loadLevel;
    private IProject project;
    private String qualifier;
    private int segmentCount;

    static void deleted(IFile iFile) throws CoreException {
        IPath iPath = iFile.getFullPath();
        int n = iPath.segmentCount();
        if (n != 3) {
            return;
        }
        if (!".settings".equals(iPath.segment(1))) {
            return;
        }
        IEclipsePreferences iEclipsePreferences = Platform.getPreferencesService().getRootNode();
        String string = iPath.segment(0);
        String string2 = iPath.removeFileExtension().lastSegment();
        ProjectPreferences projectPreferences = (ProjectPreferences)iEclipsePreferences.node("project").node(string);
        try {
            if (!projectPreferences.nodeExists(string2)) {
                return;
            }
        }
        catch (BackingStoreException backingStoreException) {}
        ProjectPreferences.clearNode(projectPreferences.node(string2));
        if (string2.equals("org.eclipse.core.resources")) {
            ProjectPreferences.preferencesChanged(iFile.getProject());
        }
    }

    static void deleted(IFolder iFolder) throws CoreException {
        IPath iPath = iFolder.getFullPath();
        int n = iPath.segmentCount();
        if (n != 2) {
            return;
        }
        if (!".settings".equals(iPath.segment(1))) {
            return;
        }
        IEclipsePreferences iEclipsePreferences = Platform.getPreferencesService().getRootNode();
        String string = iPath.segment(0);
        Preferences preferences = iEclipsePreferences.node("project").node(string);
        boolean bl = ProjectPreferences.getFile(iFolder, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(preferences);
        if (bl) {
            ProjectPreferences.preferencesChanged(iFolder.getProject());
        }
    }

    static void deleted(IProject iProject) throws CoreException {
        IEclipsePreferences iEclipsePreferences = Platform.getPreferencesService().getRootNode();
        Preferences preferences = iEclipsePreferences.node("project").node(iProject.getName());
        boolean bl = ProjectPreferences.getFile(iProject, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(preferences);
        if (bl) {
            ProjectPreferences.preferencesChanged(iProject);
        }
    }

    static void deleted(IResource iResource) throws CoreException {
        switch (iResource.getType()) {
            case 1: {
                ProjectPreferences.deleted((IFile)iResource);
                return;
            }
            case 2: {
                ProjectPreferences.deleted((IFolder)iResource);
                return;
            }
            case 4: {
                ProjectPreferences.deleted((IProject)iResource);
                return;
            }
        }
    }

    static IFile getFile(IFolder iFolder, String string) {
        Assert.isLegal((boolean)iFolder.getName().equals(".settings"));
        return iFolder.getFile(new Path(string).addFileExtension("prefs"));
    }

    static IFile getFile(IProject iProject, String string) {
        return iProject.getFile(new Path(".settings").append(string).addFileExtension("prefs"));
    }

    private static Properties loadProperties(IFile iFile) throws BackingStoreException {
        if (Policy.DEBUG_PREFERENCES) {
            Policy.debug("Loading preferences from file: " + iFile.getFullPath());
        }
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(iFile.getContents(true));
                properties.load(bufferedInputStream);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.preferences_loadException, (Object)iFile.getFullPath());
                ProjectPreferences.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)coreException));
                throw new BackingStoreException(string);
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.preferences_loadException, (Object)iFile.getFullPath());
                ProjectPreferences.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)iOException));
                throw new BackingStoreException(string);
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(bufferedInputStream);
            throw throwable;
        }
        FileUtil.safeClose(bufferedInputStream);
        return properties;
    }

    private static void preferencesChanged(IProject iProject) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        workspace.getCharsetManager().projectPreferencesChanged(iProject);
        workspace.getContentDescriptionManager().projectPreferencesChanged(iProject);
    }

    private static void read(ProjectPreferences projectPreferences, IFile iFile) throws BackingStoreException, CoreException {
        if (iFile == null || !iFile.exists()) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Unable to determine preference file or file does not exist for node: " + projectPreferences.absolutePath());
            }
            return;
        }
        Properties properties = ProjectPreferences.loadProperties(iFile);
        if (properties.isEmpty()) {
            return;
        }
        IExportedPreferences iExportedPreferences = (IExportedPreferences)ExportedPreferences.newRoot().node(projectPreferences.absolutePath());
        ProjectPreferences.convertFromProperties((EclipsePreferences)((EclipsePreferences)iExportedPreferences), (Properties)properties, (boolean)false);
        boolean bl = projectPreferences.isReading;
        projectPreferences.isReading = true;
        try {
            Platform.getPreferencesService().applyPreferences(iExportedPreferences);
        }
        finally {
            projectPreferences.isReading = bl;
        }
    }

    static void removeNode(Preferences preferences) throws CoreException {
        String string = NLS.bind((String)Messages.preferences_removeNodeException, (Object)preferences.absolutePath());
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
        ProjectPreferences.removeLoadedNodes(preferences);
    }

    static void clearNode(Preferences preferences) throws CoreException {
        try {
            ProjectPreferences.clearAll(preferences);
        }
        catch (BackingStoreException backingStoreException) {
            String string = NLS.bind((String)Messages.preferences_clearNodeException, (Object)preferences.absolutePath());
            Status status = new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
        ProjectPreferences.removeLoadedNodes(preferences);
    }

    private static void clearAll(Preferences preferences) throws BackingStoreException {
        preferences.clear();
        String[] stringArray = preferences.childrenNames();
        int n = 0;
        while (n < stringArray.length) {
            ProjectPreferences.clearAll(preferences.node(stringArray[n]));
            ++n;
        }
    }

    private static synchronized void removeLoadedNodes(Preferences preferences) {
        String string = preferences.absolutePath();
        Iterator iterator = loadedNodes.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    public static void updatePreferences(IFile iFile) throws CoreException {
        IPath iPath = iFile.getFullPath();
        if (!"prefs".equals(iPath.getFileExtension())) {
            return;
        }
        String string = iPath.segment(0);
        String string2 = iPath.removeFileExtension().lastSegment();
        IEclipsePreferences iEclipsePreferences = Platform.getPreferencesService().getRootNode();
        Preferences preferences = iEclipsePreferences.node("project").node(string).node(string2);
        String string3 = null;
        try {
            string3 = NLS.bind((String)Messages.preferences_syncException, (Object)preferences.absolutePath());
            if (!(preferences instanceof ProjectPreferences)) {
                return;
            }
            ProjectPreferences projectPreferences = (ProjectPreferences)preferences;
            if (projectPreferences.isWriting) {
                return;
            }
            ProjectPreferences.read(projectPreferences, iFile);
            if ("org.eclipse.core.resources".equals(string2)) {
                ProjectPreferences.preferencesChanged(iFile.getProject());
            }
        }
        catch (BackingStoreException backingStoreException) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, string3, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
    }

    public ProjectPreferences() {
        super(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectPreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        String string2 = this.absolutePath();
        this.segmentCount = ProjectPreferences.getSegmentCount((String)string2);
        if (this.segmentCount == 1) {
            return;
        }
        String string3 = ProjectPreferences.getSegment((String)string2, (int)1);
        if (string3 != null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(string3);
        }
        if (this.segmentCount > 2) {
            this.qualifier = ProjectPreferences.getSegment((String)string2, (int)2);
        }
        if (this.segmentCount != 2) {
            return;
        }
        if (this.initialized) {
            return;
        }
        try {
            ProjectPreferences projectPreferences = this;
            synchronized (projectPreferences) {
                String[] stringArray = this.computeChildren();
                int n = 0;
                while (n < stringArray.length) {
                    this.addChild(stringArray[n], null);
                    ++n;
                }
            }
        }
        finally {
            this.initialized = true;
        }
    }

    private String[] computeChildren() {
        if (this.project == null) {
            return EMPTY_STRING_ARRAY;
        }
        IFolder iFolder = this.project.getFolder(".settings");
        if (!iFolder.exists()) {
            return EMPTY_STRING_ARRAY;
        }
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iFolder.members();
        }
        catch (CoreException coreException) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.getType() == 1 && "prefs".equals(iResource.getFullPath().getFileExtension())) {
                arrayList.add(iResource.getFullPath().removeFileExtension().lastSegment());
            }
            ++n;
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    public void flush() throws BackingStoreException {
        if (this.isReading) {
            return;
        }
        this.isWriting = true;
        try {
            super.flush();
        }
        finally {
            this.isWriting = false;
        }
    }

    private IFile getFile() {
        if (this.file == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            this.file = ProjectPreferences.getFile(this.project, this.qualifier);
        }
        return this.file;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            ProjectPreferences projectPreferences = this;
            int n = 3;
            while (n < this.segmentCount) {
                projectPreferences = (EclipsePreferences)projectPreferences.parent();
                ++n;
            }
            this.loadLevel = projectPreferences;
        }
        return this.loadLevel;
    }

    protected IPath getLocation() {
        if (this.project == null || this.qualifier == null) {
            return null;
        }
        IPath iPath = this.project.getLocation();
        return this.computeLocation(iPath, this.qualifier);
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new ProjectPreferences(eclipsePreferences, string);
    }

    protected synchronized boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.absolutePath());
    }

    protected synchronized boolean isAlreadyLoaded(String string) {
        return loadedNodes.contains(string);
    }

    protected void load() throws BackingStoreException {
        IFile iFile = this.getFile();
        if (iFile == null || !iFile.exists()) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Unable to determine preference file or file does not exist for node: " + this.absolutePath());
            }
            return;
        }
        if (Policy.DEBUG_PREFERENCES) {
            Policy.debug("Loading preferences from file: " + iFile.getFullPath());
        }
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(iFile.getContents(true));
                properties.load(bufferedInputStream);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.preferences_loadException, (Object)iFile.getFullPath());
                ProjectPreferences.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)coreException));
                throw new BackingStoreException(string);
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.preferences_loadException, (Object)iFile.getFullPath());
                ProjectPreferences.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)iOException));
                throw new BackingStoreException(string);
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(bufferedInputStream);
            throw throwable;
        }
        FileUtil.safeClose(bufferedInputStream);
        ProjectPreferences.convertFromProperties((EclipsePreferences)this, (Properties)properties, (boolean)true);
    }

    protected synchronized void loaded() {
        loadedNodes.add(this.absolutePath());
    }

    public boolean nodeExists(String string) throws BackingStoreException {
        if (this.segmentCount != 1) {
            return super.nodeExists(string);
        }
        if (string.length() == 0) {
            return super.nodeExists(string);
        }
        if (string.charAt(0) == '/') {
            return super.nodeExists(string);
        }
        if (string.indexOf(47) != -1) {
            return super.nodeExists(string);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(string).exists() || super.nodeExists(string);
    }

    protected void save() throws BackingStoreException {
        final IFile iFile = this.getFile();
        if (iFile == null) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Not saving preferences since there is no file for node: " + this.absolutePath());
            }
            return;
        }
        Properties properties = this.convertToProperties(new SortedProperties(), "");
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IResourceRuleFactory iResourceRuleFactory = iWorkspace.getRuleFactory();
        try {
            if (properties.isEmpty()) {
                IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                        if (iFile.exists()) {
                            String string;
                            if (Policy.DEBUG_PREFERENCES) {
                                Policy.debug("Deleting preference file: " + iFile.getFullPath());
                            }
                            if (iFile.isReadOnly() && !(string = iFile.getWorkspace().validateEdit(new IFile[]{iFile}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                                throw new CoreException((IStatus)string);
                            }
                            try {
                                iFile.delete(true, null);
                            }
                            catch (CoreException coreException) {
                                string = NLS.bind((String)Messages.preferences_deleteException, (Object)iFile.getFullPath());
                                ProjectPreferences.log((IStatus)new Status(2, "org.eclipse.core.resources", 2, string, null));
                            }
                        }
                    }
                };
                ISchedulingRule iSchedulingRule = iResourceRuleFactory.deleteRule(iFile);
                try {
                    ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, iSchedulingRule, 0, null);
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new BackingStoreException(Messages.preferences_operationCanceled);
                }
                return;
            }
            properties.put("eclipse.preferences.version", "1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                try {
                    properties.store(byteArrayOutputStream, null);
                }
                catch (IOException iOException) {
                    String string = NLS.bind((String)Messages.preferences_saveProblems, (Object)this.absolutePath());
                    ProjectPreferences.log((IStatus)new Status(4, "org.eclipse.core.runtime", 4, string, (Throwable)iOException));
                    throw new BackingStoreException(string);
                }
            }
            catch (Throwable throwable) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            final BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    if (iFile.exists()) {
                        IStatus iStatus;
                        if (Policy.DEBUG_PREFERENCES) {
                            Policy.debug("Setting preference file contents for: " + iFile.getFullPath());
                        }
                        if (iFile.isReadOnly() && !(iStatus = iFile.getWorkspace().validateEdit(new IFile[]{iFile}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                            throw new CoreException(iStatus);
                        }
                        iFile.setContents(bufferedInputStream, 2, null);
                    } else {
                        IFolder iFolder = (IFolder)iFile.getParent();
                        if (!iFolder.exists()) {
                            if (Policy.DEBUG_PREFERENCES) {
                                Policy.debug("Creating parent preference directory: " + iFolder.getFullPath());
                            }
                            iFolder.create(0, true, null);
                        }
                        if (Policy.DEBUG_PREFERENCES) {
                            Policy.debug("Creating preference file: " + iFile.getLocation());
                        }
                        iFile.create(bufferedInputStream, 0, null);
                    }
                }
            };
            try {
                if (((Workspace)iWorkspace).getWorkManager().isLockAlreadyAcquired()) {
                    iWorkspaceRunnable.run(null);
                } else {
                    ISchedulingRule iSchedulingRule = MultiRule.combine((ISchedulingRule)iResourceRuleFactory.createRule(iFile.getParent()), (ISchedulingRule)iResourceRuleFactory.modifyRule(iFile));
                    iWorkspace.run(iWorkspaceRunnable, iSchedulingRule, 0, null);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new BackingStoreException(Messages.preferences_operationCanceled);
            }
        }
        catch (CoreException coreException) {
            String string = NLS.bind((String)Messages.preferences_saveProblems, (Object)iFile.getFullPath());
            ProjectPreferences.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)coreException));
            throw new BackingStoreException(string);
        }
    }

    class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        SortedProperties() {
        }

        public synchronized Enumeration keys() {
            TreeSet<Object> treeSet = new TreeSet<Object>();
            Enumeration<Object> enumeration = super.keys();
            while (enumeration.hasMoreElements()) {
                treeSet.add(enumeration.nextElement());
            }
            return new IteratorWrapper(treeSet.iterator());
        }

        class IteratorWrapper
        implements Enumeration {
            Iterator iterator;

            public IteratorWrapper(Iterator iterator) {
                this.iterator = iterator;
            }

            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                return this.iterator.next();
            }
        }
    }
}

