/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceProxy;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.Rules;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;

public abstract class Resource
extends PlatformObject
implements IResource,
ICoreConstants,
Cloneable,
IPathRequestor {
    IPath path;
    Workspace workspace;
    static /* synthetic */ Class class$0;

    protected Resource(IPath iPath, Workspace workspace) {
        this.path = iPath.removeTrailingSeparator();
        this.workspace = workspace;
    }

    public void accept(final IResourceProxyVisitor iResourceProxyVisitor, final int n) throws CoreException {
        boolean bl = (n & 1) != 0;
        this.checkAccessible(this.getFlags(this.getResourceInfo(bl, false)));
        final ResourceProxy resourceProxy = new ResourceProxy();
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                ResourceInfo resourceInfo = (ResourceInfo)object;
                if (!Resource.this.isMember(Resource.this.getFlags(resourceInfo), n)) {
                    return false;
                }
                resourceProxy.requestor = iPathRequestor;
                resourceProxy.info = resourceInfo;
                try {
                    boolean bl = iResourceProxyVisitor.visit(resourceProxy);
                    return bl;
                }
                catch (CoreException coreException) {
                    throw new WrappedRuntimeException(coreException);
                }
                finally {
                    resourceProxy.reset();
                }
            }
        };
        try {
            try {
                new ElementTreeIterator(this.workspace.getElementTree(), this.getFullPath()).iterate(iElementContentVisitor);
            }
            catch (WrappedRuntimeException wrappedRuntimeException) {
                throw (CoreException)wrappedRuntimeException.getTargetException();
            }
            catch (OperationCanceledException operationCanceledException) {
                throw operationCanceledException;
            }
            catch (RuntimeException runtimeException) {
                String string = Messages.resources_errorVisiting;
                ResourceStatus resourceStatus = new ResourceStatus(566, this.getFullPath(), string, runtimeException);
                Policy.log(resourceStatus);
                throw new ResourceException(resourceStatus);
            }
        }
        finally {
            resourceProxy.requestor = null;
            resourceProxy.info = null;
        }
    }

    public void accept(IResourceVisitor iResourceVisitor) throws CoreException {
        this.accept(iResourceVisitor, 2, 0);
    }

    public void accept(IResourceVisitor iResourceVisitor, int n, boolean bl) throws CoreException {
        this.accept(iResourceVisitor, n, bl ? 1 : 0);
    }

    public void accept(final IResourceVisitor iResourceVisitor, int n, int n2) throws CoreException {
        if (n == 2) {
            this.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                    return iResourceVisitor.visit(iResourceProxy.requestResource());
                }
            }, n2);
            return;
        }
        boolean bl = (n2 & 1) != 0;
        ResourceInfo resourceInfo = this.getResourceInfo(bl, false);
        int n3 = this.getFlags(resourceInfo);
        this.checkAccessible(n3);
        if (!this.isMember(n3, n2)) {
            return;
        }
        if (!iResourceVisitor.visit(this) || n == 0) {
            return;
        }
        resourceInfo = this.getResourceInfo(bl, false);
        if (resourceInfo == null) {
            return;
        }
        int n4 = resourceInfo.getType();
        if (n4 == 1) {
            return;
        }
        IContainer iContainer = this.getType() != n4 ? (IContainer)((Object)this.workspace.newResource(this.getFullPath(), n4)) : (IContainer)((Object)this);
        IResource[] iResourceArray = iContainer.members(n2);
        int n5 = 0;
        while (n5 < iResourceArray.length) {
            iResourceArray[n5].accept(iResourceVisitor, 0, n2);
            ++n5;
        }
    }

    protected void assertCopyRequirements(IPath iPath, int n, int n2) throws CoreException {
        IStatus iStatus = this.checkCopyRequirements(iPath, n, n2);
        if (!iStatus.isOK()) {
            Assert.isTrue((boolean)false, (String)iStatus.getChildren()[0].getMessage());
        }
    }

    protected IFileInfo assertLinkRequirements(URI uRI, int n) throws CoreException {
        IStatus iStatus;
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = (n & 0x10) != 0;
        if ((n & 0x100) == 0) {
            this.checkDoesNotExist(this.getFlags(this.getResourceInfo(false, false)), true);
        }
        boolean bl4 = bl = (iStatus = this.workspace.validateLinkLocationURI(this, uRI)).getCode() == 333;
        if (iStatus.getSeverity() == 4 || bl && !bl2) {
            throw new ResourceException(iStatus);
        }
        Container container = (Container)this.getParent();
        container.checkAccessible(this.getFlags(container.getResourceInfo(false, false)));
        if (bl) {
            return null;
        }
        URI uRI2 = container.getProject() != null ? container.getProject().getPathVariableManager().resolveURI(uRI) : this.workspace.getPathVariableManager().resolveURI(uRI);
        IFileStore iFileStore = EFS.getStore((URI)uRI2);
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        boolean bl5 = iFileInfo.exists();
        if (!bl2 && !bl5) {
            String string = NLS.bind((String)Messages.links_localDoesNotExist, (Object)iFileStore.toString());
            throw new ResourceException(269, this.getFullPath(), string, null);
        }
        if (bl5 && this.getType() == 2 != iFileInfo.isDirectory()) {
            String string = NLS.bind((String)Messages.links_wrongLocalType, (Object)this.getFullPath());
            throw new ResourceException(276, this.getFullPath(), string, null);
        }
        return iFileInfo;
    }

    protected void assertMoveRequirements(IPath iPath, int n, int n2) throws CoreException {
        IStatus iStatus = this.checkMoveRequirements(iPath, n, n2);
        if (!iStatus.isOK()) {
            Assert.isTrue((boolean)false, (String)iStatus.getChildren()[0].getMessage());
        }
    }

    public void checkAccessible(int n) throws CoreException {
        this.checkExists(n, true);
    }

    private ResourceInfo checkAccessibleAndLocal(int n) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n2 = this.getFlags(resourceInfo);
        this.checkAccessible(n2);
        this.checkLocal(n2, n);
        return resourceInfo;
    }

    public IStatus checkCopyRequirements(IPath iPath, int n, int n2) throws CoreException {
        Object object;
        Object object2;
        String string = Messages.resources_copyNotMet;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 77, string, null);
        if (iPath == null) {
            string = Messages.resources_destNotNull;
            return new ResourceStatus(77, this.getFullPath(), string);
        }
        iPath = this.makePathAbsolute(iPath);
        if (this.getFullPath().isPrefixOf(iPath)) {
            string = NLS.bind((String)Messages.resources_copyDestNotSub, (Object)this.getFullPath());
            multiStatus.add((IStatus)new ResourceStatus(77, this.getFullPath(), string));
        }
        this.checkValidPath(iPath, n, false);
        this.checkAccessibleAndLocal(2);
        IPath iPath2 = iPath.removeLastSegments(1);
        this.checkValidGroupContainer(iPath2, this.isLinked(), this.isGroup());
        Resource resource = this.workspace.newResource(iPath, n);
        resource.checkDoesNotExist();
        if (this.getType() == 1 && n == 4) {
            string = Messages.resources_fileToProj;
            throw new ResourceException(77, this.getFullPath(), string, null);
        }
        if (n != 4) {
            object2 = (Project)resource.getProject();
            ResourceInfo resourceInfo = ((Resource)object2).getResourceInfo(false, false);
            ((Project)object2).checkAccessible(this.getFlags(resourceInfo));
            object = (Container)resource.getParent();
            if (!((Resource)object).equals(object2)) {
                resourceInfo = ((Resource)object).getResourceInfo(false, false);
                ((Resource)object).checkExists(this.getFlags(resourceInfo), true);
            }
        }
        if (this.isUnderLink() || resource.isUnderLink()) {
            object2 = this.getLocationURI();
            if (object2 == null) {
                string = NLS.bind((String)Messages.localstore_locationUndefined, (Object)this.getFullPath());
                throw new ResourceException(271, this.getFullPath(), string, null);
            }
            object = resource.getLocationURI();
            if (object == null && !resource.isUnderGroup()) {
                string = NLS.bind((String)Messages.localstore_locationUndefined, (Object)resource.getFullPath());
                throw new ResourceException(271, resource.getFullPath(), string, null);
            }
            if (this.getStore().isParentOf(resource.getStore())) {
                string = NLS.bind((String)Messages.resources_copyDestNotSub, (Object)this.getFullPath());
                throw new ResourceException(77, this.getFullPath(), string, null);
            }
        }
        return multiStatus.isOK() ? Status.OK_STATUS : multiStatus;
    }

    protected void checkDoesNotExist() throws CoreException {
        this.checkDoesNotExist(this.getFlags(this.getResourceInfo(false, false)), false);
    }

    public void checkDoesNotExist(int n, boolean bl) throws CoreException {
        if (this.exists(n, bl)) {
            String string = NLS.bind((String)Messages.resources_mustNotExist, (Object)this.getFullPath());
            throw new ResourceException(bl ? 367 : 374, this.getFullPath(), string, null);
        }
        if (Workspace.caseSensitive) {
            return;
        }
        IResource iResource = this.findExistingResourceVariant(this.getFullPath());
        if (iResource == null) {
            return;
        }
        String string = NLS.bind((String)Messages.resources_existsDifferentCase, (Object)iResource.getFullPath());
        throw new ResourceException(275, iResource.getFullPath(), string, null);
    }

    public void checkExists(int n, boolean bl) throws CoreException {
        if (!this.exists(n, bl)) {
            String string = NLS.bind((String)Messages.resources_mustExist, (Object)this.getFullPath());
            throw new ResourceException(368, this.getFullPath(), string, null);
        }
    }

    public void checkLocal(int n, int n2) throws CoreException {
        if (!this.isLocal(n, n2)) {
            String string = NLS.bind((String)Messages.resources_mustBeLocal, (Object)this.getFullPath());
            throw new ResourceException(369, this.getFullPath(), string, null);
        }
    }

    protected IStatus checkMoveRequirements(IPath iPath, int n, int n2) throws CoreException {
        Object object;
        Object object2;
        IResource iResource;
        String string = Messages.resources_moveNotMet;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 77, string, null);
        if (iPath == null) {
            string = Messages.resources_destNotNull;
            return new ResourceStatus(77, this.getFullPath(), string);
        }
        iPath = this.makePathAbsolute(iPath);
        if (this.getFullPath().isPrefixOf(iPath)) {
            string = NLS.bind((String)Messages.resources_moveDestNotSub, (Object)this.getFullPath());
            multiStatus.add((IStatus)new ResourceStatus(77, this.getFullPath(), string));
        }
        this.checkValidPath(iPath, n, false);
        this.checkAccessibleAndLocal(2);
        IPath iPath2 = iPath.removeLastSegments(1);
        this.checkValidGroupContainer(iPath2, this.isLinked(), this.isGroup());
        Resource resource = this.workspace.newResource(iPath, n);
        IResource iResource2 = iResource = Workspace.caseSensitive ? null : this.findExistingResourceVariant(iPath);
        if (iResource == null || !this.equals(iResource)) {
            resource.checkDoesNotExist();
        }
        if (this.getType() == 1 && resource.getType() == 4) {
            string = Messages.resources_fileToProj;
            throw new ResourceException(new ResourceStatus(77, this.getFullPath(), string));
        }
        if (n != 4) {
            object2 = (Project)resource.getProject();
            ResourceInfo resourceInfo = ((Resource)object2).getResourceInfo(false, false);
            ((Project)object2).checkAccessible(this.getFlags(resourceInfo));
            object = (Container)resource.getParent();
            if (!((Resource)object).equals(object2)) {
                resourceInfo = ((Resource)object).getResourceInfo(false, false);
                ((Resource)object).checkExists(this.getFlags(resourceInfo), true);
            }
        }
        if (this.isUnderLink() || resource.isUnderLink()) {
            object2 = this.getLocationURI();
            if (object2 == null) {
                string = NLS.bind((String)Messages.localstore_locationUndefined, (Object)this.getFullPath());
                throw new ResourceException(271, this.getFullPath(), string, null);
            }
            object = resource.getLocationURI();
            if (object == null && !resource.isUnderGroup()) {
                string = NLS.bind((String)Messages.localstore_locationUndefined, (Object)resource.getFullPath());
                throw new ResourceException(271, resource.getFullPath(), string, null);
            }
            if (this.getStore().isParentOf(resource.getStore())) {
                string = NLS.bind((String)Messages.resources_moveDestNotSub, (Object)this.getFullPath());
                throw new ResourceException(77, this.getFullPath(), string, null);
            }
        }
        return multiStatus.isOK() ? Status.OK_STATUS : multiStatus;
    }

    public void checkValidPath(IPath iPath, int n, boolean bl) throws CoreException {
        IStatus iStatus = this.workspace.locationValidator.validatePath(iPath, n, bl);
        if (!iStatus.isOK()) {
            throw new ResourceException(iStatus);
        }
    }

    public void checkValidGroupContainer(IPath iPath, boolean bl, boolean bl2) throws CoreException {
        if (!bl && !bl2) {
            String string = Messages.group_invalidParent;
            ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, false, false);
            if (resourceInfo != null && resourceInfo.isSet(524288)) {
                throw new ResourceException(new ResourceStatus(77, null, string));
            }
        }
    }

    public void checkValidGroupContainer(Container container, boolean bl, boolean bl2) throws CoreException {
        if (!bl && !bl2) {
            String string = Messages.group_invalidParent;
            if (container.isGroup()) {
                throw new ResourceException(new ResourceStatus(77, null, string));
            }
        }
    }

    public IStatus getValidGroupContainer(IPath iPath, boolean bl, boolean bl2) throws CoreException {
        if (!bl && !bl2) {
            String string = Messages.group_invalidParent;
            ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, false, false);
            if (resourceInfo.isSet(524288)) {
                return new ResourceStatus(77, null, string);
            }
        }
        return Status.OK_STATUS;
    }

    public void clearHistory(IProgressMonitor iProgressMonitor) {
        this.getLocalManager().getHistoryStore().remove(this.getFullPath(), iProgressMonitor);
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        if (this == iSchedulingRule) {
            return true;
        }
        Class<?> clazz = iSchedulingRule.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.WorkManager$NotifyRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (iSchedulingRule instanceof MultiRule) {
            MultiRule multiRule = (MultiRule)iSchedulingRule;
            ISchedulingRule[] iSchedulingRuleArray = multiRule.getChildren();
            int n = 0;
            while (n < iSchedulingRuleArray.length) {
                if (!this.contains(iSchedulingRuleArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (!(iSchedulingRule instanceof IResource)) {
            return false;
        }
        return this.path.isPrefixOf(((IResource)iSchedulingRule).getFullPath());
    }

    public void convertToPhantom() throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, true);
        if (resourceInfo == null || this.isPhantom(this.getFlags(resourceInfo))) {
            return;
        }
        resourceInfo.clearSessionProperties();
        resourceInfo.set(8);
        this.getLocalManager().updateLocalSync(resourceInfo, -1L);
        resourceInfo.clearModificationStamp();
        resourceInfo.setMarkers(null);
    }

    public void copy(IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.copy(iPath, n, iProgressMonitor);
    }

    public void copy(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor = Policy.monitorFor(iProgressMonitor);
            String string = NLS.bind((String)Messages.resources_copying, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            Policy.checkCanceled(iProgressMonitor);
            iPath = this.makePathAbsolute(iPath);
            this.checkValidPath(iPath, this.getType(), false);
            Resource resource = this.workspace.newResource(iPath, this.getType());
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().copyRule(this, resource);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.assertCopyRequirements(iPath, this.getType(), n);
                    this.workspace.beginOperation(true);
                    this.getLocalManager().copy(this, resource, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void copy(IProjectDescription iProjectDescription, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.copy(iProjectDescription, n, iProgressMonitor);
    }

    public void copy(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iProjectDescription);
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_copying, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            try {
                try {
                    this.workspace.prepareOperation(this.workspace.getRoot(), iProgressMonitor);
                    IPath iPath = new Path(iProjectDescription.getName()).makeAbsolute();
                    this.assertCopyRequirements(iPath, this.getType(), n);
                    Project project = (Project)this.workspace.getRoot().getProject(iPath.lastSegment());
                    this.workspace.beginOperation(true);
                    project.create(iProjectDescription, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 5 / 100));
                    project.open(Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 5 / 100));
                    IResource[] iResourceArray = ((IContainer)((Object)this)).members(10);
                    int n2 = 0;
                    while (n2 < iResourceArray.length) {
                        Resource resource = (Resource)iResourceArray[n2];
                        resource.copy(iPath.append(resource.getName()), n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 60 / 100 / iResourceArray.length));
                        ++n2;
                    }
                    this.getPropertyManager().copy(this, project, 0);
                    iProgressMonitor.worked(Policy.opWork * 15 / 100);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(this.workspace.getRoot(), true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public int countResources(int n, boolean bl) {
        return this.workspace.countResources(this.path, n, bl);
    }

    public void createLink(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iPath);
        this.createLink(URIUtil.toURI((IPath)iPath), n, iProgressMonitor);
    }

    public void createLink(URI uRI, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)uRI);
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.links_creating, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            Policy.checkCanceled(iProgressMonitor);
            this.checkValidPath(this.path, 2, true);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    Object object;
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    IFileInfo iFileInfo = this.assertLinkRequirements(uRI, n);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(512, this));
                    this.workspace.beginOperation(true);
                    if ((n & 0x100) != 0 && (object = this.workspace.getRoot().findMember(this.getFullPath())) != null) {
                        this.workspace.deleteResource((IResource)object);
                    }
                    object = this.workspace.createResource((IResource)this, false);
                    if ((n & 0x1000) != 0) {
                        ((ResourceInfo)object).set(0x200000);
                    }
                    ((ResourceInfo)object).set(65536);
                    uRI = FileUtil.canonicalURI(uRI);
                    LinkDescription linkDescription = new LinkDescription(this, uRI);
                    if (linkDescription.isGroup()) {
                        ((ResourceInfo)object).set(524288);
                    }
                    this.getLocalManager().link(this, uRI, iFileInfo);
                    iProgressMonitor.worked(Policy.opWork * 5 / 100);
                    Project project = (Project)this.getProject();
                    boolean bl = project.internalGetDescription().setLinkLocation(this.getProjectRelativePath(), linkDescription);
                    if (bl) {
                        project.writeDescription(0);
                    }
                    iProgressMonitor.worked(Policy.opWork * 5 / 100);
                    if (this.getType() != 1) {
                        if ((n & 0x80) != 0) {
                            this.workspace.refreshManager.refresh(this);
                            iProgressMonitor.worked(Policy.opWork * 90 / 100);
                        } else {
                            this.refreshLocal(2, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 90 / 100));
                        }
                    } else {
                        iProgressMonitor.worked(Policy.opWork * 90 / 100);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void addFilter(String string, int n, String string2, int n2, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)string);
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string3 = NLS.bind((String)Messages.links_creating, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string3, 100);
            Policy.checkCanceled(iProgressMonitor);
            this.checkValidPath(this.path, 6, true);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(131072, this));
                    this.workspace.beginOperation(true);
                    iProgressMonitor.worked(Policy.opWork * 5 / 100);
                    FilterDescription filterDescription = new FilterDescription(this, n, string, string2);
                    Project project = (Project)this.getProject();
                    project.internalGetDescription().addFilter(this.getProjectRelativePath(), filterDescription);
                    project.writeDescription(0);
                    iProgressMonitor.worked(Policy.opWork * 5 / 100);
                    if (this.getType() != 1) {
                        if ((n2 & 0x80) != 0) {
                            this.workspace.refreshManager.refresh(this);
                            iProgressMonitor.worked(Policy.opWork * 90 / 100);
                        } else {
                            this.refreshLocal(2, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 90 / 100));
                        }
                    } else {
                        iProgressMonitor.worked(Policy.opWork * 90 / 100);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void removeFilter(String string, int n, String string2, int n2, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)string);
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string3 = NLS.bind((String)Messages.links_creating, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string3, 100);
            Policy.checkCanceled(iProgressMonitor);
            this.checkValidPath(this.path, 6, true);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(262144, this));
                    this.workspace.beginOperation(true);
                    iProgressMonitor.worked(Policy.opWork * 5 / 100);
                    FilterDescription filterDescription = new FilterDescription(this, n, string, string2);
                    Project project = (Project)this.getProject();
                    project.internalGetDescription().removeFilter(this.getProjectRelativePath(), filterDescription);
                    project.writeDescription(0);
                    iProgressMonitor.worked(Policy.opWork * 5 / 100);
                    if (this.getType() != 1) {
                        if ((n2 & 0x80) != 0) {
                            this.workspace.refreshManager.refresh(this);
                            iProgressMonitor.worked(Policy.opWork * 90 / 100);
                        } else {
                            this.refreshLocal(2, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 90 / 100));
                        }
                    } else {
                        iProgressMonitor.worked(Policy.opWork * 90 / 100);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IFilter[] getFilters() throws CoreException {
        LinkedList linkedList;
        IFilter[] iFilterArray = null;
        this.checkValidPath(this.path, 6, true);
        Project project = (Project)this.getProject();
        ProjectDescription projectDescription = project.internalGetDescription();
        if (projectDescription != null && (linkedList = projectDescription.getFilter(this.getProjectRelativePath())) != null) {
            iFilterArray = new IFilter[linkedList.size()];
            int n = 0;
            while (n < linkedList.size()) {
                iFilterArray[n] = new Filter(project, (FilterDescription)linkedList.get(n));
                ++n;
            }
            return iFilterArray;
        }
        return new IFilter[0];
    }

    public IMarker createMarker(String string) throws CoreException {
        Assert.isNotNull((Object)string);
        ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().markerRule(this);
        try {
            this.workspace.prepareOperation(iSchedulingRule, null);
            this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
            this.workspace.beginOperation(true);
            MarkerInfo markerInfo = new MarkerInfo();
            markerInfo.setType(string);
            markerInfo.setCreationTime(System.currentTimeMillis());
            this.workspace.getMarkerManager().add(this, markerInfo);
            Marker marker = new Marker(this, markerInfo.getId());
            return marker;
        }
        finally {
            this.workspace.endOperation(iSchedulingRule, false, null);
        }
    }

    public IResourceProxy createProxy() {
        ResourceProxy resourceProxy = new ResourceProxy();
        resourceProxy.info = this.getResourceInfo(false, false);
        resourceProxy.requestor = this;
        resourceProxy.resource = this;
        return resourceProxy;
    }

    public void delete(boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.delete(n |= bl2 ? 2 : 0, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.delete(bl ? 1 : 0, iProgressMonitor);
    }

    public void delete(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_deleting, (Object)this.getFullPath());
            iProgressMonitor.beginTask("", 100000);
            iProgressMonitor.subTask(string);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().deleteRule(this);
            try {
                this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                if (!this.exists()) {
                    return;
                }
                try {
                    this.workspace.beginOperation(true);
                    this.broadcastPreDeleteEvent();
                    if (this.getType() == 4) {
                        this.workspace.flushBuildOrder();
                    }
                    IFileStore iFileStore = this.getStore();
                    boolean bl = this.isLinked();
                    string = Messages.resources_deleteProblem;
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 273, string, null);
                    WorkManager workManager = this.workspace.getWorkManager();
                    ResourceTree resourceTree = new ResourceTree(this.workspace.getFileSystemManager(), workManager.getLock(), multiStatus, n);
                    int n2 = 0;
                    try {
                        n2 = workManager.beginUnprotected();
                        this.unprotectedDelete(resourceTree, n, iProgressMonitor);
                    }
                    finally {
                        workManager.endUnprotected(n2);
                    }
                    if (this.getType() == 8) {
                        this.workspace.getMarkerManager().removeMarkers(this, 0);
                        this.getPropertyManager().deleteProperties(this, 0);
                        this.getResourceInfo(false, false).clearSessionProperties();
                    }
                    resourceTree.makeInvalid();
                    if (!resourceTree.getStatus().isOK()) {
                        throw new ResourceException(resourceTree.getStatus());
                    }
                    if (!bl) {
                        this.workspace.getAliasManager().updateAliases(this, iFileStore, 2, iProgressMonitor);
                    }
                    if (this.getType() == 4) {
                        ((Rules)this.workspace.getRuleFactory()).setRuleFactory((IProject)((Object)this), null);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork * 1000));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void deleteMarkers(String string, boolean bl, int n) throws CoreException {
        ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().markerRule(this);
        try {
            this.workspace.prepareOperation(iSchedulingRule, null);
            ResourceInfo resourceInfo = this.getResourceInfo(false, false);
            this.checkAccessible(this.getFlags(resourceInfo));
            this.workspace.beginOperation(true);
            this.workspace.getMarkerManager().removeMarkers(this, string, bl, n);
        }
        finally {
            this.workspace.endOperation(iSchedulingRule, false, null);
        }
    }

    public void deleteResource(boolean bl, MultiStatus multiStatus) throws CoreException {
        ProjectDescription projectDescription;
        Iterator iterator;
        Object object;
        Object object2;
        List list;
        if (this.exists()) {
            this.getMarkerManager().removeMarkers(this, 2);
        }
        if ((list = this.findLinks()) != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(1024, (IResource)object2.next()));
            }
        }
        ProjectPreferences.deleted(this);
        if (bl && this.getType() != 4 && this.synchronizing(this.getResourceInfo(true, false))) {
            this.convertToPhantom();
        } else {
            this.workspace.deleteResource(this);
        }
        if (this.getType() != 4 && list != null && (object = ((Project)(object2 = (Project)this.getProject())).internalGetDescription()) != null) {
            boolean bl2 = false;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                bl2 |= ((ProjectDescription)object).setLinkLocation(((IResource)iterator.next()).getProjectRelativePath(), null);
            }
            if (bl2) {
                ((Project)object2).internalSetDescription((IProjectDescription)object, true);
                ((Project)object2).writeDescription(1);
            }
        }
        if ((object2 = this.findFilters()) != null && object2.size() > 0 && (projectDescription = ((Project)(object = (Project)this.getProject())).internalGetDescription()) != null) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                projectDescription.setFilters(((IResource)iterator.next()).getProjectRelativePath(), null);
            }
            ((Project)object).internalSetDescription(projectDescription, true);
            ((Project)object).writeDescription(1);
        }
        object = null;
        try {
            this.getPropertyManager().deleteResource(this);
        }
        catch (CoreException coreException) {
            if (multiStatus != null) {
                multiStatus.add(coreException.getStatus());
            }
            object = coreException;
        }
        if (object != null) {
            throw object;
        }
    }

    private List findLinks() {
        Project project = (Project)this.getProject();
        ProjectDescription projectDescription = project.internalGetDescription();
        HashMap hashMap = projectDescription.getLinks();
        if (hashMap == null) {
            return null;
        }
        ArrayList<Resource> arrayList = null;
        IPath iPath = this.getProjectRelativePath();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            LinkDescription linkDescription = (LinkDescription)iterator.next();
            IPath iPath2 = linkDescription.getProjectRelativePath();
            if (!iPath.isPrefixOf(iPath2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Resource>();
            }
            arrayList.add(this.workspace.newResource(project.getFullPath().append(iPath2), linkDescription.getType()));
        }
        return arrayList;
    }

    private List findFilters() {
        HashMap hashMap;
        Project project = (Project)this.getProject();
        ProjectDescription projectDescription = project.internalGetDescription();
        ArrayList<Resource> arrayList = null;
        if (projectDescription != null && (hashMap = projectDescription.getFilters()) != null) {
            IPath iPath = this.getProjectRelativePath();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                IPath iPath2 = (IPath)iterator.next();
                if (!iPath.isPrefixOf(iPath2)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Resource>();
                }
                arrayList.add(this.workspace.newResource(project.getFullPath().append(iPath2), 2));
            }
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)object;
        return this.getType() == resource.getType() && this.path.equals((Object)resource.path) && this.workspace.equals(resource.workspace);
    }

    public boolean exists() {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        return this.exists(this.getFlags(resourceInfo), true);
    }

    public boolean exists(int n, boolean bl) {
        return n != -1 && (!bl || ResourceInfo.getType(n) == this.getType());
    }

    public IResource findExistingResourceVariant(IPath iPath) {
        if (!this.workspace.tree.includesIgnoreCase(iPath)) {
            return null;
        }
        ResourceInfo resourceInfo = (ResourceInfo)this.workspace.tree.getElementDataIgnoreCase(iPath);
        if (resourceInfo != null && resourceInfo.isSet(8)) {
            return null;
        }
        Path path = Path.ROOT;
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = this.workspace.tree.getNamesOfChildren((IPath)path);
            String string = this.findVariant(iPath.segment(n2), stringArray);
            if (string == null) {
                return null;
            }
            path = path.append(string);
            ++n2;
        }
        return this.workspace.getRoot().findMember((IPath)path);
    }

    public IMarker findMarker(long l) {
        return this.workspace.getMarkerManager().findMarker(this, l);
    }

    public IMarker[] findMarkers(String string, boolean bl, int n) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(resourceInfo));
        return this.workspace.getMarkerManager().findMarkers(this, string, bl, n);
    }

    public int findMaxProblemSeverity(String string, boolean bl, int n) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(resourceInfo));
        return this.workspace.getMarkerManager().findMaxProblemSeverity(this, string, bl, n);
    }

    private String findVariant(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    protected void fixupAfterMoveSource() throws CoreException {
        Object object;
        ResourceInfo resourceInfo = this.getResourceInfo(true, true);
        if ((this.isLinked() || this.isGroup()) && ((Project)(object = (Project)this.getProject())).internalGetDescription().setLinkLocation(this.getProjectRelativePath(), null)) {
            ((Project)object).writeDescription(0);
        }
        if ((object = this.findFilters()) != null && object.size() > 0) {
            Project project = (Project)this.getProject();
            ProjectDescription projectDescription = project.internalGetDescription();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                projectDescription.setFilters(((IResource)iterator.next()).getProjectRelativePath(), null);
            }
            project.writeDescription(0);
        }
        ProjectPreferences.deleted(this);
        if (!this.synchronizing(resourceInfo)) {
            this.workspace.deleteResource(this);
            return;
        }
        resourceInfo.clearSessionProperties();
        resourceInfo.clear(2);
        resourceInfo.setLocalSyncInfo(-1L);
        resourceInfo.set(8);
        resourceInfo.clearModificationStamp();
        resourceInfo.setMarkers(null);
    }

    public String getFileExtension() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public int getFlags(ResourceInfo resourceInfo) {
        return resourceInfo == null ? -1 : resourceInfo.getFlags();
    }

    public IPath getFullPath() {
        return this.path;
    }

    public FileSystemResourceManager getLocalManager() {
        return this.workspace.getFileSystemManager();
    }

    public long getLocalTimeStamp() {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        return resourceInfo == null ? -1L : resourceInfo.getLocalSyncInfo();
    }

    public IPath getLocation() {
        IProject iProject = this.getProject();
        if (iProject != null && !iProject.exists()) {
            return null;
        }
        return this.getLocalManager().locationFor(this);
    }

    public URI getLocationURI() {
        IProject iProject = this.getProject();
        if (iProject != null && !iProject.exists()) {
            return null;
        }
        return this.getLocalManager().locationURIFor(this);
    }

    public IMarker getMarker(long l) {
        return new Marker(this, l);
    }

    protected MarkerManager getMarkerManager() {
        return this.workspace.getMarkerManager();
    }

    public long getModificationStamp() {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        return resourceInfo == null ? -1L : resourceInfo.getModificationStamp();
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IContainer getParent() {
        int n = this.path.segmentCount();
        if (n < 2) {
            Assert.isLegal((boolean)false, (String)this.path.toString());
        }
        if (n == 2) {
            return this.workspace.getRoot().getProject(this.path.segment(0));
        }
        return (IFolder)((Object)this.workspace.newResource(this.path.removeLastSegments(1), 2));
    }

    public String getPersistentProperty(QualifiedName qualifiedName) throws CoreException {
        this.checkAccessibleAndLocal(0);
        return this.getPropertyManager().getProperty(this, qualifiedName);
    }

    public Map getPersistentProperties() throws CoreException {
        this.checkAccessibleAndLocal(0);
        return this.getPropertyManager().getProperties(this);
    }

    public IProject getProject() {
        return this.workspace.getRoot().getProject(this.path.segment(0));
    }

    public IPath getProjectRelativePath() {
        return this.getFullPath().removeFirstSegments(1);
    }

    public IPropertyManager getPropertyManager() {
        return this.workspace.getPropertyManager();
    }

    public IPath getRawLocation() {
        if (this.isLinked()) {
            return FileUtil.toPath(((Project)this.getProject()).internalGetDescription().getLinkLocationURI(this.getProjectRelativePath()));
        }
        return this.getLocation();
    }

    public URI getRawLocationURI() {
        if (this.isLinked()) {
            return ((Project)this.getProject()).internalGetDescription().getLinkLocationURI(this.getProjectRelativePath());
        }
        return this.getLocationURI();
    }

    public ResourceAttributes getResourceAttributes() {
        if (!this.isAccessible()) {
            return null;
        }
        return this.getLocalManager().attributes(this);
    }

    public ResourceInfo getResourceInfo(boolean bl, boolean bl2) {
        return this.workspace.getResourceInfo(this.getFullPath(), bl, bl2);
    }

    public Object getSessionProperty(QualifiedName qualifiedName) throws CoreException {
        ResourceInfo resourceInfo = this.checkAccessibleAndLocal(0);
        return resourceInfo.getSessionProperty(qualifiedName);
    }

    public Map getSessionProperties() throws CoreException {
        ResourceInfo resourceInfo = this.checkAccessibleAndLocal(0);
        return resourceInfo.getSessionProperties();
    }

    public IFileStore getStore() {
        return this.getLocalManager().getStore(this);
    }

    public abstract int getType();

    public String getTypeString() {
        switch (this.getType()) {
            case 1: {
                return "L";
            }
            case 2: {
                return "F";
            }
            case 4: {
                return "P";
            }
            case 8: {
                return "R";
            }
        }
        return "";
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    protected void internalSetLocal(boolean bl, int n) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(true, true);
        if (resourceInfo.isSet(2) != bl) {
            if (bl && !this.isPhantom(this.getFlags(resourceInfo))) {
                resourceInfo.set(2);
                this.workspace.updateModificationStamp(resourceInfo);
            } else {
                resourceInfo.clear(2);
                resourceInfo.clearModificationStamp();
            }
        }
        if (this.getType() == 1 || n == 0) {
            return;
        }
        if (n == 1) {
            n = 0;
        }
        IResource[] iResourceArray = ((IContainer)((Object)this)).members();
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            ((Resource)iResourceArray[n2]).internalSetLocal(bl, n);
            ++n2;
        }
    }

    public boolean isAccessible() {
        return this.exists();
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        Class<?> clazz = iSchedulingRule.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.WorkManager$NotifyRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (!(iSchedulingRule instanceof IResource)) {
            return false;
        }
        IPath iPath = ((IResource)iSchedulingRule).getFullPath();
        return this.path.isPrefixOf(iPath) || iPath.isPrefixOf(this.path);
    }

    public boolean isDerived() {
        return this.isDerived(0);
    }

    public boolean isDerived(int n) {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n2 = this.getFlags(resourceInfo);
        if (n2 != -1 && ResourceInfo.isSet(n2, 16384)) {
            return true;
        }
        if ((n & 0x200) != 0) {
            return this.getParent().isDerived(n);
        }
        return false;
    }

    public boolean isHidden() {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        return n != -1 && ResourceInfo.isSet(n, 0x200000);
    }

    public boolean isHidden(int n) {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n2 = this.getFlags(resourceInfo);
        if (n2 != -1 && ResourceInfo.isSet(n2, 0x200000)) {
            return true;
        }
        if ((n & 0x200) != 0) {
            return this.getParent().isHidden(n);
        }
        return false;
    }

    public boolean isLinked() {
        return this.isLinked(0);
    }

    public boolean isLinked(int n) {
        if ((n & 0x200) != 0) {
            IProject iProject = this.getProject();
            if (iProject == null) {
                return false;
            }
            ProjectDescription projectDescription = ((Project)iProject).internalGetDescription();
            if (projectDescription == null) {
                return false;
            }
            HashMap hashMap = projectDescription.getLinks();
            if (hashMap == null) {
                return false;
            }
            IPath iPath = this.getProjectRelativePath();
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                if (!((LinkDescription)iterator.next()).getProjectRelativePath().isPrefixOf(iPath)) continue;
                return true;
            }
            return false;
        }
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        return resourceInfo != null && resourceInfo.isSet(65536);
    }

    public boolean isGroup() {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        return resourceInfo != null && resourceInfo.isSet(524288);
    }

    public boolean hasFilters() {
        IProject iProject = this.getProject();
        if (iProject == null) {
            return false;
        }
        ProjectDescription projectDescription = ((Project)iProject).internalGetDescription();
        if (projectDescription == null) {
            return false;
        }
        LinkedList linkedList = projectDescription.getFilter(this.getProjectRelativePath());
        return linkedList != null && linkedList.size() > 0;
    }

    public boolean isLocal(int n) {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        return this.isLocal(this.getFlags(resourceInfo), n);
    }

    public boolean isLocal(int n, int n2) {
        return n != -1 && ResourceInfo.isSet(n, 2);
    }

    protected boolean isMember(int n, int n2) {
        int n3 = 0;
        if ((n2 & 1) == 0) {
            n3 |= 8;
        }
        if ((n2 & 8) == 0) {
            n3 |= 0x200000;
        }
        if ((n2 & 2) == 0) {
            n3 |= 0x8000;
        }
        if ((n2 & 4) != 0) {
            n3 |= 0x4000;
        }
        return n != -1 && (n & n3) == 0;
    }

    public boolean isPhantom() {
        ResourceInfo resourceInfo = this.getResourceInfo(true, false);
        return this.isPhantom(this.getFlags(resourceInfo));
    }

    public boolean isPhantom(int n) {
        return n != -1 && ResourceInfo.isSet(n, 8);
    }

    public boolean isReadOnly() {
        ResourceAttributes resourceAttributes = this.getResourceAttributes();
        return resourceAttributes == null ? false : resourceAttributes.isReadOnly();
    }

    public boolean isSynchronized(int n) {
        return this.getLocalManager().isSynchronized(this, n);
    }

    public boolean isTeamPrivateMember() {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        return n != -1 && ResourceInfo.isSet(n, 32768);
    }

    public boolean isTeamPrivateMember(int n) {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n2 = this.getFlags(resourceInfo);
        if (n2 != -1 && ResourceInfo.isSet(n2, 32768)) {
            return true;
        }
        if ((n & 0x200) != 0) {
            return this.getParent().isTeamPrivateMember(n);
        }
        return false;
    }

    public boolean isUnderLink() {
        int n = this.path.segmentCount();
        if (n < 2) {
            return false;
        }
        if (n == 2) {
            return this.isLinked();
        }
        IPath iPath = this.path.removeLastSegments(n - 2);
        return this.workspace.getResourceInfo(iPath, false, false).isSet(65536);
    }

    protected IPath makePathAbsolute(IPath iPath) {
        if (iPath.isAbsolute()) {
            return iPath;
        }
        return this.getParent().getFullPath().append(iPath);
    }

    public void move(IPath iPath, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.move(iPath, n |= bl2 ? 2 : 0, iProgressMonitor);
    }

    public void move(IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.move(iPath, bl ? 1 : 0, iProgressMonitor);
    }

    public void move(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_moving, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            Policy.checkCanceled(iProgressMonitor);
            iPath = this.makePathAbsolute(iPath);
            this.checkValidPath(iPath, this.getType(), false);
            Resource resource = this.workspace.newResource(iPath, this.getType());
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().moveRule(this, resource);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.assertMoveRequirements(iPath, this.getType(), n);
                    this.workspace.beginOperation(true);
                    this.broadcastPreMoveEvent(resource, n);
                    IFileStore iFileStore = this.getStore();
                    string = Messages.resources_moveProblem;
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 4, string, null);
                    WorkManager workManager = this.workspace.getWorkManager();
                    ResourceTree resourceTree = new ResourceTree(this.workspace.getFileSystemManager(), workManager.getLock(), multiStatus, n);
                    boolean bl = false;
                    int n2 = 0;
                    try {
                        n2 = workManager.beginUnprotected();
                        bl = this.unprotectedMove(resourceTree, resource, n, iProgressMonitor);
                    }
                    finally {
                        workManager.endUnprotected(n2);
                    }
                    resourceTree.makeInvalid();
                    if (bl) {
                        this.workspace.getAliasManager().updateAliases(this, iFileStore, 2, iProgressMonitor);
                        this.workspace.getAliasManager().updateAliases(resource, resource.getStore(), 2, iProgressMonitor);
                    }
                    if (!resourceTree.getStatus().isOK()) {
                        throw new ResourceException(resourceTree.getStatus());
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void move(IProjectDescription iProjectDescription, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.move(iProjectDescription, n |= bl2 ? 2 : 0, iProgressMonitor);
    }

    public void move(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iProjectDescription);
        if (this.getType() != 4) {
            String string = NLS.bind((String)Messages.resources_moveNotProject, (Object)this.getFullPath(), (Object)iProjectDescription.getName());
            throw new ResourceException(77, this.getFullPath(), string, null);
        }
        ((Project)this).move(iProjectDescription, n, iProgressMonitor);
    }

    public void refreshLocal(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            boolean bl = this.getType() == 8;
            String string = bl ? Messages.resources_refreshingRoot : NLS.bind((String)Messages.resources_refreshing, (Object)this.getFullPath());
            iProgressMonitor.beginTask("", 100);
            iProgressMonitor.subTask(string);
            boolean bl2 = false;
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().refreshRule(this);
            try {
                this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                if (!bl && !this.getProject().isAccessible()) {
                    return;
                }
                try {
                    this.workspace.beginOperation(true);
                    if (this.getType() == 4 || this.getType() == 8) {
                        this.workspace.broadcastEvent(LifecycleEvent.newEvent(4096, this));
                    }
                    bl2 = this.getLocalManager().refresh(this, n, true, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
                catch (Error error) {
                    Policy.log(error);
                    throw error;
                }
                catch (RuntimeException runtimeException) {
                    Policy.log(runtimeException);
                    throw runtimeException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, bl2, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public String requestName() {
        return this.getName();
    }

    public IPath requestPath() {
        return this.getFullPath();
    }

    public void revertModificationStamp(long l) throws CoreException {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal value: " + l);
        }
        ResourceInfo resourceInfo = this.checkAccessibleAndLocal(0);
        resourceInfo.setModificationStamp(l);
    }

    public void setDerived(boolean bl) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        this.checkAccessible(n);
        if (resourceInfo.getType() == 1 || resourceInfo.getType() == 2) {
            if (bl) {
                resourceInfo.set(16384);
            } else {
                resourceInfo.clear(16384);
            }
        }
    }

    public void setHidden(boolean bl) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        this.checkAccessible(n);
        if (bl) {
            resourceInfo.set(0x200000);
        } else {
            resourceInfo.clear(0x200000);
        }
    }

    public void setLocal(boolean bl, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = Messages.resources_setLocal;
            iProgressMonitor.beginTask(string, 100);
            try {
                this.workspace.prepareOperation(null, iProgressMonitor);
                this.workspace.beginOperation(true);
                this.internalSetLocal(bl, n);
                iProgressMonitor.worked(Policy.opWork);
            }
            finally {
                this.workspace.endOperation(null, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public long setLocalTimeStamp(long l) throws CoreException {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal value: " + l);
        }
        ResourceInfo resourceInfo = this.checkAccessibleAndLocal(0);
        return this.getLocalManager().setLocalTimeStamp(this, resourceInfo, l);
    }

    public void setPersistentProperty(QualifiedName qualifiedName, String string) throws CoreException {
        this.checkAccessibleAndLocal(0);
        this.getPropertyManager().setProperty(this, qualifiedName, string);
    }

    public void setReadOnly(boolean bl) {
        ResourceAttributes resourceAttributes = this.getResourceAttributes();
        if (resourceAttributes == null) {
            return;
        }
        resourceAttributes.setReadOnly(bl);
        try {
            this.setResourceAttributes(resourceAttributes);
        }
        catch (CoreException coreException) {}
    }

    public void setResourceAttributes(ResourceAttributes resourceAttributes) throws CoreException {
        this.checkAccessibleAndLocal(0);
        this.getLocalManager().setResourceAttributes(this, resourceAttributes);
    }

    public void setSessionProperty(QualifiedName qualifiedName, Object object) throws CoreException {
        ResourceInfo resourceInfo = this.checkAccessibleAndLocal(0);
        resourceInfo.setSessionProperty(qualifiedName, object);
    }

    public void setTeamPrivateMember(boolean bl) throws CoreException {
        ResourceInfo resourceInfo = this.getResourceInfo(false, false);
        int n = this.getFlags(resourceInfo);
        this.checkAccessible(n);
        if (resourceInfo.getType() == 1 || resourceInfo.getType() == 2) {
            if (bl) {
                resourceInfo.set(32768);
            } else {
                resourceInfo.clear(32768);
            }
        }
    }

    public boolean synchronizing(ResourceInfo resourceInfo) {
        return resourceInfo != null && resourceInfo.getSyncInfo(false) != null;
    }

    public String toString() {
        return String.valueOf(this.getTypeString()) + this.getFullPath().toString();
    }

    public void touch(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = NLS.bind((String)Messages.resources_touch, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
                    ResourceInfo resourceInfo = this.checkAccessibleAndLocal(0);
                    this.workspace.beginOperation(true);
                    resourceInfo = this.getResourceInfo(false, true);
                    resourceInfo.incrementContentId();
                    resourceInfo.clear(393216);
                    this.workspace.updateModificationStamp(resourceInfo);
                    iProgressMonitor.worked(Policy.opWork);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void unprotectedDelete(ResourceTree resourceTree, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        IMoveDeleteHook iMoveDeleteHook = this.workspace.getMoveDeleteHook();
        switch (this.getType()) {
            case 1: {
                if (iMoveDeleteHook.deleteFile(resourceTree, (IFile)((Object)this), n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000 / 2))) break;
                resourceTree.standardDeleteFile((IFile)((Object)this), n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000));
                break;
            }
            case 2: {
                if (iMoveDeleteHook.deleteFolder(resourceTree, (IFolder)((Object)this), n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000 / 2))) break;
                resourceTree.standardDeleteFolder((IFolder)((Object)this), n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000));
                break;
            }
            case 4: {
                if (iMoveDeleteHook.deleteProject(resourceTree, (IProject)((Object)this), n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000 / 2))) break;
                resourceTree.standardDeleteProject((IProject)((Object)this), n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000));
                break;
            }
            case 8: {
                IProject[] iProjectArray = ((IWorkspaceRoot)((Object)this)).getProjects(8);
                int n2 = 0;
                while (n2 < iProjectArray.length) {
                    if (!iMoveDeleteHook.deleteProject(resourceTree, iProjectArray[n2], n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000 / iProjectArray.length / 2))) {
                        resourceTree.standardDeleteProject(iProjectArray[n2], n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 1000 / iProjectArray.length));
                    }
                    ++n2;
                }
                break;
            }
        }
    }

    private boolean unprotectedMove(ResourceTree resourceTree, IResource iResource, int n, IProgressMonitor iProgressMonitor) throws CoreException, ResourceException {
        IMoveDeleteHook iMoveDeleteHook = this.workspace.getMoveDeleteHook();
        switch (this.getType()) {
            case 1: {
                if (iMoveDeleteHook.moveFile(resourceTree, (IFile)((Object)this), (IFile)iResource, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork / 2))) break;
                resourceTree.standardMoveFile((IFile)((Object)this), (IFile)iResource, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                break;
            }
            case 2: {
                if (iMoveDeleteHook.moveFolder(resourceTree, (IFolder)((Object)this), (IFolder)iResource, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork / 2))) break;
                resourceTree.standardMoveFolder((IFolder)((Object)this), (IFolder)iResource, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                break;
            }
            case 4: {
                IProject iProject = (IProject)((Object)this);
                if (this.getName().equals(iResource.getName())) {
                    return false;
                }
                IProjectDescription iProjectDescription = iProject.getDescription();
                iProjectDescription.setName(iResource.getName());
                if (iMoveDeleteHook.moveProject(resourceTree, iProject, iProjectDescription, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork / 2))) break;
                resourceTree.standardMoveProject(iProject, iProjectDescription, n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                break;
            }
            case 8: {
                String string = Messages.resources_moveRoot;
                throw new ResourceException(new ResourceStatus(77, this.getFullPath(), string));
            }
        }
        return true;
    }

    private void broadcastPreDeleteEvent() throws CoreException {
        switch (this.getType()) {
            case 4: {
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(16, this));
                break;
            }
            case 8: {
                IResource[] iResourceArray = ((Container)this).getChildren(8);
                int n = 0;
                while (n < iResourceArray.length) {
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(16, iResourceArray[n]));
                    ++n;
                }
                break;
            }
        }
    }

    private void broadcastPreMoveEvent(IResource iResource, int n) throws CoreException {
        switch (this.getType()) {
            case 1: {
                if (!this.isLinked()) break;
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(2048, this, iResource, n));
                break;
            }
            case 2: {
                if (this.isLinked()) {
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(2048, this, iResource, n));
                }
                if (!this.isGroup()) break;
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(65536, this, iResource, n));
                break;
            }
            case 4: {
                if (this.getName().equals(iResource.getName())) break;
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(64, this, iResource, n));
            }
        }
    }

    public boolean isFilteredFromParent() {
        Resource resource = this;
        while (resource != null && resource.getParent() != null) {
            IFileInfo[] iFileInfoArray;
            Resource resource2 = (Resource)((Object)resource.getParent());
            IFileStore iFileStore = resource.getStore();
            if (iFileStore != null && (iFileInfoArray = iFileStore.fetchInfo()) != null) {
                IFileInfo[] iFileInfoArray2;
                if (!iFileInfoArray.exists()) {
                    iFileInfoArray2 = new FileInfo(iFileInfoArray.getName());
                    iFileInfoArray2.setDirectory(resource.getType() == 2);
                    iFileInfoArray = iFileInfoArray2;
                }
                if ((iFileInfoArray2 = resource2.filterChildren(new IFileInfo[]{iFileInfoArray})).length == 0) {
                    return true;
                }
            }
            resource = resource2;
        }
        return false;
    }

    public IFileInfo[] filterChildren(IFileInfo[] iFileInfoArray) {
        IPath iPath = this.getProjectRelativePath();
        Project project = (Project)this.getProject();
        if (project != null && iPath != null) {
            Filter filter;
            FilterDescription filterDescription;
            Iterator iterator;
            LinkedList<Filter> linkedList = new LinkedList<Filter>();
            LinkedList<Filter> linkedList2 = new LinkedList<Filter>();
            LinkedList linkedList3 = project.internalGetDescription().getFilter(iPath);
            if (linkedList3 != null) {
                iterator = linkedList3.iterator();
                while (iterator.hasNext()) {
                    filterDescription = (FilterDescription)iterator.next();
                    filter = new Filter(project, filterDescription);
                    if (filter.isIncludeOnly()) {
                        if (filter.isFirst()) {
                            linkedList.addFirst(filter);
                            continue;
                        }
                        linkedList.addLast(filter);
                        continue;
                    }
                    if (filter.isFirst()) {
                        linkedList2.addFirst(filter);
                        continue;
                    }
                    linkedList2.addLast(filter);
                }
            }
            while (iPath.segmentCount() > 0) {
                iPath = iPath.removeLastSegments(1);
                linkedList3 = project.internalGetDescription().getFilter(iPath);
                if (linkedList3 == null) continue;
                iterator = linkedList3.iterator();
                while (iterator.hasNext()) {
                    filterDescription = (FilterDescription)iterator.next();
                    if (!filterDescription.isInheritable()) continue;
                    filter = new Filter(project, filterDescription);
                    if (filter.isIncludeOnly()) {
                        if (filter.isFirst()) {
                            linkedList.addFirst(filter);
                            continue;
                        }
                        linkedList.addLast(filter);
                        continue;
                    }
                    if (filter.isFirst()) {
                        linkedList2.addFirst(filter);
                        continue;
                    }
                    linkedList2.addLast(filter);
                }
            }
            if (linkedList.size() > 0 || linkedList2.size() > 0) {
                try {
                    iFileInfoArray = Filter.filter(project, linkedList, linkedList2, iFileInfoArray);
                }
                catch (CoreException coreException) {}
            }
        }
        return iFileInfoArray;
    }

    public void setLinkLocation(URI uRI, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        String string;
        if (!this.isLinked()) {
            String string2 = NLS.bind((String)Messages.links_resourceIsNotALink, (Object)this.getFullPath());
            throw new ResourceException(77, this.getFullPath(), string2, null);
        }
        ISchedulingRule iSchedulingRule = this.workspace.getRuleFactory().modifyRule(this);
        try {
            string = NLS.bind((String)Messages.links_setLocation, (Object)this.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            this.workspace.prepareOperation(iSchedulingRule, iProgressMonitor);
            this.workspace.broadcastEvent(LifecycleEvent.newEvent(524288, this));
            this.workspace.beginOperation(true);
            ResourceInfo resourceInfo = this.workspace.getResourceInfo(this.getFullPath(), true, false);
            this.getLocalManager().setLocation(this, resourceInfo, uRI);
            LinkDescription linkDescription = new LinkDescription(this, uRI);
            Project project = (Project)this.getProject();
            project.internalGetDescription().setLinkLocation(this.getProjectRelativePath(), linkDescription);
            project.writeDescription(n);
        }
        finally {
            this.workspace.endOperation(iSchedulingRule, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
        }
        string = this.workspace.getRuleFactory().refreshRule(this);
        try {
            this.workspace.prepareOperation((ISchedulingRule)string, iProgressMonitor);
            this.workspace.beginOperation(true);
            if ((n & 0x80) != 0) {
                this.workspace.refreshManager.refresh(this);
                iProgressMonitor.worked(Policy.opWork * 90 / 100);
            } else {
                this.refreshLocal(2, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 90 / 100));
            }
        }
        finally {
            this.workspace.endOperation((ISchedulingRule)string, true, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            iProgressMonitor.done();
        }
    }

    public void setLinkLocation(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iPath.isAbsolute()) {
            this.setLinkLocation(URIUtil.toURI((String)iPath.toPortableString()), n, iProgressMonitor);
        } else {
            try {
                this.setLinkLocation(new URI(null, null, iPath.toPortableString(), null), n, iProgressMonitor);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.setLinkLocation(URIUtil.toURI((String)iPath.toPortableString()), n, iProgressMonitor);
            }
        }
    }

    public boolean isUnderGroup() {
        IContainer iContainer = this.getParent();
        while (iContainer != null) {
            if (iContainer.isGroup()) {
                return true;
            }
            iContainer = iContainer.getParent();
        }
        return false;
    }
}

